/*
 * Decompiled with CFR 0.152.
 */
package org.gvt.util;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Random;
import java.util.Set;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.BioPAXLevel;
import org.biopax.paxtools.model.Model;
import org.biopax.paxtools.model.level2.conversion;
import org.biopax.paxtools.model.level2.pathway;
import org.biopax.paxtools.model.level2.pathwayComponent;
import org.biopax.paxtools.model.level3.Pathway;
import org.biopax.paxtools.model.level3.Process;
import org.gvt.model.GraphObject;
import org.gvt.model.biopaxl2.Conversion;
import org.gvt.model.biopaxl3.ChbConversion;
import org.gvt.util.BioPAXUtil;
import org.gvt.util.ID;

public class PathwayHolder {
    public pathway l2p;
    public Pathway l3p;
    private static final Random random = new Random();

    public PathwayHolder() {
    }

    public PathwayHolder(pathway l2p) {
        this.l2p = l2p;
    }

    public PathwayHolder(Pathway l3p) {
        if (l3p.getDisplayName() == null && l3p.getStandardName() != null) {
            l3p.setDisplayName(l3p.getStandardName());
        }
        this.l3p = l3p;
    }

    public PathwayHolder(Model model, String name) {
        String id = "http://chibecreated#" + System.currentTimeMillis() + "" + random.nextInt();
        if (model.getLevel() == BioPAXLevel.L2) {
            this.l2p = BioPAXLevel.L2.getDefaultFactory().create(pathway.class, id);
            name = BioPAXUtil.makeUniquePathwayName(model, name);
            this.l2p.setNAME(name);
            this.l2p.setSHORT_NAME(name);
            model.add(this.l2p);
        } else if (model.getLevel() == BioPAXLevel.L3) {
            this.l3p = BioPAXLevel.L3.getDefaultFactory().create(Pathway.class, id);
            name = BioPAXUtil.makeUniquePathwayName(model, name);
            this.l3p.setDisplayName(name);
            model.add(this.l3p);
        }
    }

    public String getRDFID() {
        if (this.l2p != null) {
            return ID.get(this.l2p);
        }
        if (this.l3p != null) {
            return ID.get(this.l3p);
        }
        return null;
    }

    public String getName() {
        if (this.l2p != null) {
            return this.l2p.getNAME();
        }
        if (this.l3p != null) {
            return this.l3p.getDisplayName();
        }
        return null;
    }

    public void setName(String name) {
        if (this.l2p != null) {
            this.l2p.setNAME(name);
        } else if (this.l3p != null) {
            this.l3p.setDisplayName(name);
        }
    }

    public void removeFromModel(Model model) {
        if (this.l2p != null) {
            model.remove(this.l2p);
        } else if (this.l3p != null) {
            model.remove(this.l3p);
            for (Pathway p : this.l3p.getPathwayComponentOf()) {
                p.removePathwayComponent(this.l3p);
            }
            for (Process process2 : new HashSet<Process>(this.l3p.getPathwayComponent())) {
                this.l3p.removePathwayComponent(process2);
            }
        }
    }

    public void updateContentWith(Collection<GraphObject> content) {
        block7: {
            block6: {
                if (this.l2p == null) break block6;
                for (pathwayComponent pathwayComponent2 : new HashSet<pathwayComponent>(this.l2p.getPATHWAY_COMPONENTS())) {
                    this.l2p.removePATHWAY_COMPONENTS(pathwayComponent2);
                }
                HashSet<conversion> convSet = new HashSet<conversion>();
                for (GraphObject graphObject : content) {
                    if (!(graphObject instanceof Conversion)) continue;
                    Conversion conv = (Conversion)graphObject;
                    conversion cnv = conv.getConversion();
                    convSet.add(cnv);
                }
                Set<pathwayComponent> set = this.l2p.getPATHWAY_COMPONENTS();
                for (conversion cnv : convSet) {
                    if (set.contains(cnv)) continue;
                    this.l2p.addPATHWAY_COMPONENTS(cnv);
                }
                break block7;
            }
            if (this.l3p == null) break block7;
            for (Process process2 : new HashSet<Process>(this.l3p.getPathwayComponent())) {
                this.l3p.removePathwayComponent(process2);
            }
            HashSet convSet = new HashSet();
            for (GraphObject graphObject : content) {
                if (!(graphObject instanceof ChbConversion)) continue;
                ChbConversion conv = (ChbConversion)graphObject;
                org.biopax.paxtools.model.level3.Conversion cnv = conv.getConversion();
                convSet.add(cnv);
            }
            Set<Process> set = this.l3p.getPathwayComponent();
            Iterator iterator = convSet.iterator();
            while (iterator.hasNext()) {
                org.biopax.paxtools.model.level3.Conversion cnv = (org.biopax.paxtools.model.level3.Conversion)iterator.next();
                if (set.contains(cnv)) continue;
                this.l3p.addPathwayComponent(cnv);
            }
        }
    }

    public boolean isEmpty() {
        if (this.l2p != null) {
            return this.l2p.getPATHWAY_COMPONENTS().isEmpty();
        }
        if (this.l3p != null) {
            return this.l3p.getPathwayComponent().isEmpty();
        }
        return true;
    }

    public boolean hasEdge() {
        if (this.l2p != null) {
            return !this.l2p.isPARTICIPANTSof().isEmpty() || !this.l2p.isCONTROLLEDOf().isEmpty();
        }
        if (this.l3p != null) {
            return !this.l3p.getParticipantOf().isEmpty() || !this.l3p.getControlledOf().isEmpty() || !this.l3p.getControllerOf().isEmpty();
        }
        return false;
    }

    public boolean isLevel3() {
        return this.l3p != null;
    }

    public BioPAXElement getPathway() {
        if (this.l3p != null) {
            return this.l3p;
        }
        return this.l2p;
    }
}

