/*
 * Decompiled with CFR 0.152.
 */
package org.gvt.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.biopax.paxtools.pattern.miner.SIFType;
import org.cbio.causality.idmapping.HGNC;

public class QueryOptionsPack
implements Serializable {
    private boolean useID;
    private int lengthLimit = 1;
    private boolean currentView = false;
    private boolean cancel = true;
    private List<String> sourceList = null;
    private List<String> targetList = null;
    private List<String> unknownSymbols;
    private boolean downstream = true;
    private boolean upstream = false;
    private int shortestPlusKLimit = 0;
    private boolean limitType = false;
    private boolean strict = true;
    private List<SIFType> sifTypes;

    public boolean isCancel() {
        return this.cancel;
    }

    public void setCancel(boolean cancel) {
        this.cancel = cancel;
    }

    public int getLengthLimit() {
        return this.lengthLimit;
    }

    public void setLengthLimit(int lengthLimit) {
        this.lengthLimit = lengthLimit;
    }

    public boolean isCurrentView() {
        return this.currentView;
    }

    public void setCurrentView(boolean currentView) {
        this.currentView = currentView;
    }

    public List<String> getSourceList() {
        return this.sourceList;
    }

    public List<String> getTargetList() {
        return this.targetList;
    }

    public void setSourceList(List<String> sourceList) {
        this.sourceList = sourceList;
    }

    public void setTargetList(List<String> targetList) {
        this.targetList = targetList;
    }

    public List<String> getUnknownSymbols() {
        return this.unknownSymbols;
    }

    public void clearUnknownSymbols() {
        if (this.unknownSymbols != null) {
            this.unknownSymbols.clear();
        }
    }

    protected List<String> getConvertedSymbols(List<String> symbols) {
        if (this.unknownSymbols == null) {
            this.unknownSymbols = new ArrayList<String>();
        }
        ArrayList<String> list = new ArrayList<String>();
        for (String s : symbols) {
            String official = HGNC.getSymbol(s);
            if (QueryOptionsPack.isChemID(s)) {
                list.add(s);
                continue;
            }
            if (official == null) {
                this.unknownSymbols.add(s);
                continue;
            }
            list.add(official);
        }
        return list;
    }

    public static boolean isChemID(String s) {
        if (!s.startsWith("CHEBI:") || s.length() < 7) {
            return false;
        }
        for (int i = 6; i < s.length(); ++i) {
            if (Character.isDigit(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    protected String getOneStringSymbols(List<String> symbols) {
        String text = "";
        for (String s : symbols) {
            text = text + s + "\n";
        }
        return text.trim();
    }

    public List<String> getConvertedSourceList() {
        if (this.useID) {
            return this.sourceList;
        }
        return this.sourceList == null ? Collections.emptyList() : this.getConvertedSymbols(this.sourceList);
    }

    public List<String> getConvertedTargetList() {
        if (this.useID) {
            return this.targetList;
        }
        return this.targetList == null ? Collections.emptyList() : this.getConvertedSymbols(this.targetList);
    }

    public String getOneStringSources() {
        return this.getOneStringSymbols(this.sourceList);
    }

    public String getOneStringTargets() {
        return this.getOneStringSymbols(this.targetList);
    }

    public boolean isDownstream() {
        return this.downstream;
    }

    public void setDownstream(boolean downstream) {
        this.downstream = downstream;
    }

    public boolean isUpstream() {
        return this.upstream;
    }

    public void setUpstream(boolean upstream) {
        this.upstream = upstream;
    }

    public boolean isBothstream() {
        return this.isUpstream() && this.isDownstream();
    }

    public int getShortestPlusKLimit() {
        return this.shortestPlusKLimit;
    }

    public void setShortestPlusKLimit(int shortestPlusKLimit) {
        this.shortestPlusKLimit = shortestPlusKLimit;
    }

    public boolean isStrict() {
        return this.strict;
    }

    public void setStrict(boolean strict) {
        this.strict = strict;
    }

    public boolean getLimitType() {
        return this.limitType;
    }

    public void setLimitType(boolean limitType) {
        this.limitType = limitType;
    }

    public boolean isUseID() {
        return this.useID;
    }

    public void setUseID(boolean useID) {
        this.useID = useID;
    }

    public List<SIFType> getSifTypes() {
        return this.sifTypes;
    }

    public void setSifTypes(List<SIFType> sifTypes) {
        this.sifTypes = sifTypes;
    }

    public boolean undirectedSIFTypeSelected() {
        for (SIFType sifType : this.sifTypes) {
            if (sifType.isDirected()) continue;
            return true;
        }
        return false;
    }

    public void setDefaultValues() {
        this.setLengthLimit(1);
        this.setCurrentView(true);
        this.setUpstream(true);
        this.setDownstream(true);
        this.setShortestPlusKLimit(0);
        this.setLimitType(true);
        this.setStrict(false);
    }
}

