/*
 * Decompiled with CFR 0.152.
 */
package org.ivis.layout;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Stack;
import org.ivis.layout.ClusterManager;
import org.ivis.layout.Clustered;
import org.ivis.util.PointD;

public class Cluster
implements Comparable {
    protected Set<Clustered> nodes = new HashSet<Clustered>();
    protected ClusterManager clusterManager;
    protected int clusterID;
    protected String clusterName;
    protected ArrayList<PointD> polygon;

    public Cluster(ClusterManager clusterManager, String clusterName) {
        this.polygon = new ArrayList();
        this.clusterManager = clusterManager;
        this.clusterName = clusterName;
        if (this.clusterManager != null) {
            while (!this.clusterManager.isClusterIDUsed(ClusterManager.idCounter)) {
                ++ClusterManager.idCounter;
            }
        }
        this.clusterID = ClusterManager.idCounter++;
    }

    public Cluster(ClusterManager clusterManager, int clusterID, String clusterName) {
        this.polygon = new ArrayList();
        this.clusterManager = clusterManager;
        if (this.clusterManager != null && this.clusterManager.isClusterIDUsed(clusterID)) {
            System.err.println("Cluster ID " + clusterID + " is used" + " before. ClusterID is set automatically.");
            while (this.clusterManager.isClusterIDUsed(ClusterManager.idCounter)) {
                ++ClusterManager.idCounter;
            }
            clusterID = ClusterManager.idCounter++;
        }
        this.clusterName = clusterName;
        this.clusterID = clusterID;
    }

    public Cluster(Cluster c) {
        Iterator<Object> i$ = c.nodes.iterator();
        while (i$.hasNext()) {
            Clustered clustered;
            Clustered node = clustered = i$.next();
            this.nodes.add(node);
        }
        this.polygon = new ArrayList();
        i$ = c.polygon.iterator();
        while (i$.hasNext()) {
            PointD pointD;
            PointD pt = pointD = (PointD)i$.next();
            this.polygon.add(pt);
        }
        this.clusterName = c.clusterName;
        this.clusterID = c.clusterID;
    }

    public Set<Clustered> getNodes() {
        return this.nodes;
    }

    public int getClusterID() {
        return this.clusterID;
    }

    public void setClusterManager(ClusterManager clusterManager) {
        this.clusterManager = clusterManager;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    public ArrayList<PointD> getPolygon() {
        return this.polygon;
    }

    public void setPolygon(ArrayList<PointD> points) {
        this.polygon = points;
    }

    public void addNode(Clustered node) {
        node.addCluster(this);
    }

    public void removeNode(Clustered node) {
        node.removeCluster(this);
    }

    public void delete() {
        ArrayList<Clustered> copy = new ArrayList<Clustered>();
        copy.addAll(this.nodes);
        for (Clustered node : copy) {
            node.removeCluster(this);
        }
        this.clusterManager.getClusters().remove(this);
    }

    public void calculatePolygon() {
        if (this.clusterID == 0) {
            return;
        }
        this.calculateConvexHull();
    }

    private void findPoints() {
        this.polygon.clear();
        if (this.nodes.isEmpty()) {
            return;
        }
        for (Clustered node : this.nodes) {
            double left = node.getLeft();
            double right = node.getRight();
            double top = node.getTop();
            double bottom = node.getBottom();
            for (Clustered parent = node.getParent(); parent != null; parent = parent.getParent()) {
                left += parent.getLeft();
                right += parent.getLeft();
                top += parent.getTop();
                bottom += parent.getTop();
            }
            if (right - left > 8.0) {
                left -= 4.0;
                right += 4.0;
            }
            if (bottom - top > 8.0) {
                top -= 4.0;
                bottom += 4.0;
            }
            this.polygon.add(new PointD(left, top));
            this.polygon.add(new PointD(right, top));
            this.polygon.add(new PointD(right, bottom));
            this.polygon.add(new PointD(left, bottom));
        }
    }

    private void calculateConvexHull() {
        PointD pt2;
        PointD pt1;
        PointD pt3;
        int i;
        this.findPoints();
        if (this.polygon.isEmpty()) {
            return;
        }
        Collections.sort(this.polygon, new PointComparator());
        Stack<PointD> upperHull = new Stack<PointD>();
        Stack<PointD> lowerHull = new Stack<PointD>();
        int n = this.polygon.size();
        if (n < 3) {
            return;
        }
        upperHull.push(this.polygon.get(0));
        upperHull.push(this.polygon.get(1));
        block0: for (i = 2; i < this.polygon.size(); ++i) {
            pt3 = this.polygon.get(i);
            do {
                pt2 = (PointD)upperHull.pop();
                if (!upperHull.empty()) continue;
                upperHull.push(pt2);
                upperHull.push(pt3);
                continue block0;
            } while (!Cluster.rightTurn(pt1 = (PointD)upperHull.peek(), pt2, pt3));
            upperHull.push(pt2);
            upperHull.push(pt3);
        }
        lowerHull.push(this.polygon.get(n - 1));
        lowerHull.push(this.polygon.get(n - 2));
        block2: for (i = n - 3; i >= 0; --i) {
            pt3 = this.polygon.get(i);
            do {
                pt2 = (PointD)lowerHull.pop();
                if (!lowerHull.empty()) continue;
                lowerHull.push(pt2);
                lowerHull.push(pt3);
                continue block2;
            } while (!Cluster.rightTurn(pt1 = (PointD)lowerHull.peek(), pt2, pt3));
            lowerHull.push(pt2);
            lowerHull.push(pt3);
        }
        this.polygon.clear();
        n = lowerHull.size();
        for (i = 0; i < n; ++i) {
            this.polygon.add((PointD)lowerHull.pop());
        }
        n = upperHull.size();
        for (i = 0; i < n; ++i) {
            this.polygon.add((PointD)upperHull.pop());
        }
    }

    private static boolean rightTurn(PointD pt1, PointD pt2, PointD pt3) {
        double x1 = pt2.x - pt1.x;
        double y2 = -(pt3.y - pt2.y);
        double y1 = -(pt2.y - pt1.y);
        double x2 = pt3.x - pt2.x;
        return x1 * y2 - y1 * x2 <= 0.0;
    }

    public boolean isCompletelyInsideClusterBounds(Clustered node) {
        double left = node.getLeft();
        double right = node.getRight();
        double top = node.getTop();
        double bottom = node.getBottom();
        if (right - left > 8.0) {
            left += 4.0;
            right -= 4.0;
        }
        if (bottom - top > 8.0) {
            top += 4.0;
            bottom -= 4.0;
        }
        return this.isInside(new PointD(left, top)) && this.isInside(new PointD(left, bottom)) && this.isInside(new PointD(right, top)) && this.isInside(new PointD(right, bottom));
    }

    public boolean isPartiallyInsideClusterBounds(Clustered node) {
        double left = node.getLeft();
        double right = node.getRight();
        double top = node.getTop();
        double bottom = node.getBottom();
        if (right - left > 8.0) {
            left += 4.0;
            right -= 4.0;
        }
        if (bottom - top > 8.0) {
            top += 4.0;
            bottom -= 4.0;
        }
        return this.isInside(new PointD(left, top)) || this.isInside(new PointD(left, bottom)) || this.isInside(new PointD(right, top)) || this.isInside(new PointD(right, bottom));
    }

    boolean isInside(PointD p) {
        int next;
        int n = this.polygon.size();
        if (n < 3) {
            return false;
        }
        PointD extreme = new PointD(Double.MAX_VALUE, p.y);
        int count = 0;
        int i = 0;
        do {
            PointD p_next;
            next = (i + 1) % n;
            PointD p_i = this.polygon.get(i);
            if (!this.doIntersect(p_i, p_next = this.polygon.get(next), p, extreme)) continue;
            if (this.calcOrientation(p_i, p, p_next) == 0) {
                return this.isOnSegment(p_i, p, p_next);
            }
            if (this.calcOrientation(p, p_i, extreme) == 0) continue;
            ++count;
        } while ((i = next) != 0);
        return count % 2 == 1;
    }

    public boolean isOnSegment(PointD p, PointD q, PointD r) {
        return q.x <= Math.max(p.x, r.x) && q.x >= Math.min(p.x, r.x) && q.y <= Math.max(p.y, r.y) && q.y >= Math.min(p.y, r.y);
    }

    public int calcOrientation(PointD p, PointD q, PointD r) {
        int val = (int)((q.y - p.y) * (r.x - q.x) - (q.x - p.x) * (r.y - q.y));
        if (val == 0) {
            return 0;
        }
        return val > 0 ? 1 : 2;
    }

    public boolean doIntersect(PointD p1, PointD q1, PointD p2, PointD q2) {
        int o1 = this.calcOrientation(p1, q1, p2);
        int o2 = this.calcOrientation(p1, q1, q2);
        int o3 = this.calcOrientation(p2, q2, p1);
        int o4 = this.calcOrientation(p2, q2, q1);
        if (o1 != o2 && o3 != o4) {
            return true;
        }
        if (o1 == 0 && this.isOnSegment(p1, p2, q1)) {
            return true;
        }
        if (o2 == 0 && this.isOnSegment(p1, q2, q1)) {
            return true;
        }
        if (o3 == 0 && this.isOnSegment(p2, p1, q2)) {
            return true;
        }
        return o4 == 0 && this.isOnSegment(p2, q1, q2);
    }

    public int compareTo(Object obj) {
        if (obj instanceof Cluster) {
            Cluster cluster = (Cluster)obj;
            return Integer.valueOf(this.clusterID).compareTo(cluster.getClusterID());
        }
        return 0;
    }

    private class PointComparator
    implements Comparator<PointD> {
        private PointComparator() {
        }

        @Override
        public int compare(PointD o1, PointD o2) {
            PointD pt1 = o1;
            PointD pt2 = o2;
            if (pt1.x < pt2.x) {
                return -1;
            }
            if (pt1.x > pt2.x) {
                return 1;
            }
            if (Math.abs(pt1.x - pt2.x) < 1.0E-9 && pt1.y > pt2.y) {
                return -1;
            }
            if (Math.abs(pt1.x - pt2.x) < 1.0E-9 && pt1.y < pt2.y) {
                return 1;
            }
            return 0;
        }
    }
}

