/*
 * Decompiled with CFR 0.152.
 */
package org.ivis.layout;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import org.ivis.layout.Cluster;
import org.ivis.util.IGeometry;
import org.ivis.util.PointD;

public class ClusterManager {
    protected ArrayList clusters = new ArrayList();
    protected boolean polygonUsed = false;
    public static int idCounter = 1;

    public ArrayList<Cluster> getClusters() {
        return this.clusters;
    }

    public void setPolygonUsed(boolean polygonUsed) {
        this.polygonUsed = polygonUsed;
    }

    public ArrayList<Integer> getClusterIDs() {
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (Cluster cluster : this.clusters) {
            if (cluster.getClusterID() <= 0) continue;
            result.add(cluster.getClusterID());
        }
        Collections.sort(result);
        return result;
    }

    public void createCluster(int clusterID, String clusterName) {
        Cluster cluster = new Cluster(this, clusterID, clusterName);
        this.clusters.add(cluster);
    }

    public void createCluster(String clusterName) {
        Cluster lCluster = new Cluster(this, clusterName);
        this.clusters.add(lCluster);
    }

    public void addCluster(Cluster cluster) {
        cluster.setClusterManager(this);
        this.clusters.add(cluster);
    }

    public void removeCluster(Cluster cluster) {
        cluster.delete();
    }

    public boolean isClusterIDUsed(int clusterID) {
        for (Cluster cluster : this.clusters) {
            if (cluster.getClusterID() != clusterID) continue;
            return true;
        }
        return false;
    }

    public Cluster getClusterByID(int clusterID) {
        for (Cluster cluster : this.clusters) {
            if (cluster.getClusterID() != clusterID) continue;
            return cluster;
        }
        return null;
    }

    public void clearClusters() {
        ArrayList<Integer> clusterIDs = new ArrayList<Integer>();
        Iterator iter = this.clusters.iterator();
        while (iter.hasNext()) {
            clusterIDs.add(((Cluster)iter.next()).getClusterID());
        }
        for (Integer id : clusterIDs) {
            this.getClusterByID(id).delete();
        }
    }

    public ArrayList<Object[]> getOverlapInformation() {
        int numberOfClusters = this.clusters.size();
        ArrayList<Object[]> overlapInfo = new ArrayList<Object[]>();
        for (int i = 0; i < numberOfClusters; ++i) {
            Cluster c1 = (Cluster)this.clusters.get(i);
            ArrayList<PointD> p1 = c1.getPolygon();
            for (int j = i + 1; j < numberOfClusters; ++j) {
                Object[] overlap;
                Cluster c2 = (Cluster)this.clusters.get(j);
                ArrayList<PointD> p2 = c2.getPolygon();
                if (p1.size() <= 3 || p2.size() <= 3 || (Double)(overlap = IGeometry.convexPolygonOverlap(p1, p2))[0] == 0.0) continue;
                Object[] newOverlap = new Object[]{c1.clusterID, c2.clusterID, overlap[0], overlap[1]};
                PointD temp = IGeometry.getXYProjection((Double)overlap[0], (PointD)overlap[1]);
                newOverlap[2] = temp.x;
                newOverlap[3] = temp.y;
                overlapInfo.add(newOverlap);
            }
        }
        return overlapInfo;
    }
}

