/*
 * Decompiled with CFR 0.152.
 */
package org.ivis.layout;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.ivis.layout.ClusterManager;
import org.ivis.layout.LEdge;
import org.ivis.layout.LGraph;
import org.ivis.layout.LNode;
import org.ivis.layout.Layout;

public class LGraphManager {
    private List graphs;
    private List edges;
    private Object[] allNodes;
    private Object[] allEdges;
    private Object[] allNodesToApplyGravitation;
    private LGraph rootGraph;
    private Layout layout;
    private ClusterManager clusterManager;

    protected LGraphManager() {
        this.layout = null;
        this.init();
    }

    public LGraphManager(Layout layout) {
        this.layout = layout;
        this.init();
    }

    private void init() {
        this.graphs = new ArrayList();
        this.edges = new ArrayList();
        this.allNodes = null;
        this.allEdges = null;
        this.allNodesToApplyGravitation = null;
        this.rootGraph = null;
        this.clusterManager = new ClusterManager();
    }

    public LGraph addRoot() {
        this.setRootGraph(this.add(this.layout.newGraph(null), this.layout.newNode(null)));
        return this.rootGraph;
    }

    public LGraph add(LGraph newGraph, LNode parentNode) {
        assert (newGraph != null) : "Graph is null!";
        assert (parentNode != null) : "Parent node is null!";
        assert (!this.graphs.contains(newGraph)) : "Graph already in this graph mgr!";
        this.graphs.add(newGraph);
        assert (newGraph.parent == null) : "Already has a parent!";
        assert (parentNode.child == null) : "Already has a child!";
        newGraph.parent = parentNode;
        parentNode.child = newGraph;
        return newGraph;
    }

    public LEdge add(LEdge newEdge, LNode sourceNode, LNode targetNode) {
        LGraph sourceGraph = sourceNode.getOwner();
        LGraph targetGraph = targetNode.getOwner();
        assert (sourceGraph != null && sourceGraph.getGraphManager() == this) : "Source not in this graph mgr!";
        assert (targetGraph != null && targetGraph.getGraphManager() == this) : "Target not in this graph mgr!";
        if (sourceGraph == targetGraph) {
            newEdge.isInterGraph = false;
            return sourceGraph.add(newEdge, sourceNode, targetNode);
        }
        newEdge.isInterGraph = true;
        newEdge.source = sourceNode;
        newEdge.target = targetNode;
        assert (!this.edges.contains(newEdge)) : "Edge already in inter-graph edge list!";
        this.edges.add(newEdge);
        assert (newEdge.source != null && newEdge.target != null) : "Edge source and/or target is null!";
        assert (!newEdge.source.edges.contains(newEdge) && !newEdge.target.edges.contains(newEdge)) : "Edge already in source and/or target incidency list!";
        newEdge.source.edges.add(newEdge);
        newEdge.target.edges.add(newEdge);
        return newEdge;
    }

    public void remove(LGraph graph) {
        assert (graph.getGraphManager() == this) : "Graph not in this graph mgr";
        assert (graph == this.rootGraph || graph.parent != null && graph.parent.graphManager == this) : "Invalid parent node!";
        ArrayList edgesToBeRemoved = new ArrayList();
        edgesToBeRemoved.addAll(graph.getEdges());
        for (Object obj : edgesToBeRemoved) {
            LEdge edge = (LEdge)obj;
            graph.remove(edge);
        }
        ArrayList nodesToBeRemoved = new ArrayList();
        nodesToBeRemoved.addAll(graph.getNodes());
        for (Object obj : nodesToBeRemoved) {
            LNode node = (LNode)obj;
            graph.remove(node);
        }
        if (graph == this.rootGraph) {
            this.setRootGraph(null);
        }
        this.graphs.remove(graph);
        graph.parent = null;
    }

    public void remove(LEdge edge) {
        assert (edge != null) : "Edge is null!";
        assert (edge.isInterGraph) : "Not an inter-graph edge!";
        assert (edge.source != null && edge.target != null) : "Source and/or target is null!";
        assert (edge.source.edges.contains(edge) && edge.target.edges.contains(edge)) : "Source and/or target doesn't know this edge!";
        edge.source.edges.remove(edge);
        edge.target.edges.remove(edge);
        assert (edge.source.owner != null && edge.source.owner.getGraphManager() != null) : "Edge owner graph or owner graph manager is null!";
        assert (edge.source.owner.getGraphManager().edges.contains(edge)) : "Not in owner graph manager's edge list!";
        edge.source.owner.getGraphManager().edges.remove(edge);
    }

    public void updateBounds() {
        this.rootGraph.updateBounds(true);
    }

    public ClusterManager getClusterManager() {
        return this.clusterManager;
    }

    public List getGraphs() {
        return this.graphs;
    }

    public List getInterGraphEdges() {
        return this.edges;
    }

    public Object[] getAllNodes() {
        if (this.allNodes == null) {
            LinkedList nodeList = new LinkedList();
            Iterator iterator = this.getGraphs().iterator();
            while (iterator.hasNext()) {
                nodeList.addAll(((LGraph)iterator.next()).getNodes());
            }
            this.allNodes = nodeList.toArray();
        }
        return this.allNodes;
    }

    public void resetAllNodes() {
        this.allNodes = null;
    }

    public void resetAllEdges() {
        this.allEdges = null;
    }

    public void resetAllNodesToApplyGravitation() {
        this.allNodesToApplyGravitation = null;
    }

    public Object[] getAllEdges() {
        if (this.allEdges == null) {
            LinkedList edgeList = new LinkedList();
            Iterator iterator = this.getGraphs().iterator();
            while (iterator.hasNext()) {
                edgeList.addAll(((LGraph)iterator.next()).getEdges());
            }
            edgeList.addAll(this.edges);
            this.allEdges = edgeList.toArray();
        }
        return this.allEdges;
    }

    public Object[] getAllNodesToApplyGravitation() {
        return this.allNodesToApplyGravitation;
    }

    public void setAllNodesToApplyGravitation(List nodeList) {
        assert (this.allNodesToApplyGravitation == null);
        this.allNodesToApplyGravitation = nodeList.toArray();
    }

    public void setAllNodesToApplyGravitation(Object[] nodes) {
        assert (this.allNodesToApplyGravitation == null);
        this.allNodesToApplyGravitation = nodes;
    }

    public LGraph getRoot() {
        return this.rootGraph;
    }

    public void setRootGraph(LGraph graph) {
        assert (graph.getGraphManager() == this) : "Root not in this graph mgr!";
        this.rootGraph = graph;
        if (graph.parent == null) {
            graph.parent = this.layout.newNode("Root node");
        }
    }

    public Layout getLayout() {
        return this.layout;
    }

    public void setLayout(Layout layout) {
        this.layout = layout;
    }

    public static boolean isOneAncestorOfOther(LNode firstNode, LNode secondNode) {
        LNode parentNode;
        assert (firstNode != null && secondNode != null);
        if (firstNode == secondNode) {
            return true;
        }
        LGraph ownerGraph = firstNode.getOwner();
        while ((parentNode = ownerGraph.getParent()) != null) {
            if (parentNode == secondNode) {
                return true;
            }
            ownerGraph = parentNode.getOwner();
            if (ownerGraph != null) continue;
        }
        ownerGraph = secondNode.getOwner();
        while ((parentNode = ownerGraph.getParent()) != null) {
            if (parentNode == firstNode) {
                return true;
            }
            ownerGraph = parentNode.getOwner();
            if (ownerGraph != null) continue;
            break;
        }
        return false;
    }

    public void calcLowestCommonAncestors() {
        for (Object obj : this.getAllEdges()) {
            LEdge edge = (LEdge)obj;
            LNode sourceNode = edge.source;
            LNode targetNode = edge.target;
            edge.lca = null;
            edge.sourceInLca = sourceNode;
            edge.targetInLca = targetNode;
            if (sourceNode == targetNode) {
                edge.lca = sourceNode.getOwner();
                continue;
            }
            LGraph sourceAncestorGraph = sourceNode.getOwner();
            while (edge.lca == null) {
                edge.targetInLca = targetNode;
                LGraph targetAncestorGraph = targetNode.getOwner();
                while (edge.lca == null) {
                    if (targetAncestorGraph == sourceAncestorGraph) {
                        edge.lca = targetAncestorGraph;
                        break;
                    }
                    if (targetAncestorGraph == this.rootGraph) break;
                    assert (edge.lca == null);
                    edge.targetInLca = targetAncestorGraph.getParent();
                    targetAncestorGraph = edge.targetInLca.getOwner();
                }
                if (sourceAncestorGraph == this.rootGraph) break;
                if (edge.lca != null) continue;
                edge.sourceInLca = sourceAncestorGraph.getParent();
                sourceAncestorGraph = edge.sourceInLca.getOwner();
            }
            assert (edge.lca != null);
        }
    }

    public LGraph calcLowestCommonAncestor(LNode firstNode, LNode secondNode) {
        if (firstNode == secondNode) {
            return firstNode.getOwner();
        }
        LGraph firstOwnerGraph = firstNode.getOwner();
        while (firstOwnerGraph != null) {
            LGraph secondOwnerGraph = secondNode.getOwner();
            while (secondOwnerGraph != null) {
                if (secondOwnerGraph == firstOwnerGraph) {
                    return secondOwnerGraph;
                }
                secondOwnerGraph = secondOwnerGraph.getParent().getOwner();
            }
            firstOwnerGraph = firstOwnerGraph.getParent().getOwner();
        }
        return firstOwnerGraph;
    }

    public void calcInclusionTreeDepths() {
        this.calcInclusionTreeDepths(this.rootGraph, 1);
    }

    private void calcInclusionTreeDepths(LGraph graph, int depth) {
        for (Object obj : graph.getNodes()) {
            LNode node = (LNode)obj;
            node.inclusionTreeDepth = depth;
            if (node.child == null) continue;
            this.calcInclusionTreeDepths(node.child, depth + 1);
        }
    }

    public boolean includesInvalidEdge() {
        for (Object obj : this.edges) {
            LEdge edge = (LEdge)obj;
            if (!LGraphManager.isOneAncestorOfOther(edge.source, edge.target)) continue;
            return true;
        }
        return false;
    }

    public void printTopology() {
        this.rootGraph.printTopology();
        for (Object obj : this.graphs) {
            LGraph graph = (LGraph)obj;
            if (graph == this.rootGraph) continue;
            graph.printTopology();
        }
        System.out.print("Inter-graph edges:");
        for (Object obj : this.edges) {
            LEdge edge = (LEdge)obj;
            edge.printTopology();
        }
        System.out.println();
        System.out.println();
    }
}

