/*
 * Decompiled with CFR 0.152.
 */
package org.ivis.layout.cluster;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.ivis.layout.Cluster;
import org.ivis.layout.Layout;
import org.ivis.layout.cluster.ClusterEdge;
import org.ivis.layout.cluster.ClusterLayout;
import org.ivis.layout.cluster.ZoneEdge;
import org.ivis.layout.cluster.ZoneGraph;
import org.ivis.layout.cluster.ZoneNode;
import org.ivis.layout.cose.CoSEGraphManager;
import org.ivis.layout.cose.CoSELayout;
import org.ivis.layout.cose.CoSENode;
import org.ivis.util.IntegerQuickSort;

public class ClusterGraphManager
extends CoSEGraphManager {
    HashMap overlappingClusterMap;
    ArrayList zoneGraphEdgeTable;
    int maxClusterId;
    ArrayList zoneGraphEdges;
    ArrayList zoneGraphNodes;
    ZoneGraph zoneGraph;
    ArrayList firstLevelClusters = new ArrayList();

    public ClusterGraphManager(Layout layout) {
        super(layout);
        this.overlappingClusterMap = new HashMap();
        this.zoneGraphEdgeTable = new ArrayList();
        this.zoneGraphNodes = new ArrayList();
        this.zoneGraphEdges = new ArrayList();
        this.zoneGraph = new ZoneGraph(new CoSELayout());
    }

    public void formClusterZones() {
        for (Object edge : this.getAllEdges()) {
            ClusterEdge e = (ClusterEdge)edge;
            e.setAreNodesZoneNeighbors();
        }
        Iterator<Cluster> i$ = this.getClusterManager().getClusters().iterator();
        while (i$.hasNext()) {
            Cluster o;
            Cluster c = o = i$.next();
            Cluster newCluster = new Cluster(c);
            this.firstLevelClusters.add(newCluster);
        }
        this.findZones();
        this.addClustersToZoneGraph();
        this.addEdgesToZoneGraph();
    }

    @Override
    public void updateBounds() {
        super.updateBounds();
        ClusterLayout currentLayout = (ClusterLayout)this.getLayout();
        double coolingFactor = currentLayout.coolingFactor;
        int iterationFrequency = (int)((1.0 - coolingFactor) * 8.0) + 1;
        if (currentLayout.getTotalIterations() % iterationFrequency == 0) {
            Iterator<Cluster> i$ = this.getClusterManager().getClusters().iterator();
            while (i$.hasNext()) {
                Cluster o;
                Cluster c = o = i$.next();
                c.calculatePolygon();
            }
        }
    }

    private void addEdgesToZoneGraph() {
        for (Object o : this.zoneGraphEdgeTable) {
            ArrayList info = (ArrayList)o;
            Cluster source = (Cluster)info.get(0);
            List target = (List)info.get(1);
            CoSENode sourceNode = null;
            CoSENode targetNode = null;
            for (Object sn : this.zoneGraph.getNodes()) {
                sourceNode = (CoSENode)sn;
                if (!sourceNode.label.equals(Integer.toString(source.getClusterID()))) continue;
                break;
            }
            for (Object tn : target) {
                Cluster targetN = (Cluster)tn;
                for (Object n : this.zoneGraph.getNodes()) {
                    targetNode = (CoSENode)n;
                    if (!targetNode.label.equals(Integer.toString(targetN.getClusterID()))) continue;
                    this.zoneGraph.add(new ZoneEdge(), sourceNode, targetNode);
                }
            }
        }
    }

    private void findZones() {
        Object[] nodes;
        this.maxClusterId = this.getGreatestClusterId();
        for (Object o : nodes = this.getAllNodes()) {
            CoSENode node = (CoSENode)o;
            List clusters = node.getClusters();
            ArrayList<Object> clusterIdList = new ArrayList<Object>();
            if (clusters.size() <= 1) continue;
            for (Object c : clusters) {
                Cluster cl = (Cluster)c;
                clusterIdList.add(cl.getClusterID());
            }
            IntegerQuickSort intSort = new IntegerQuickSort(clusterIdList);
            intSort.quicksort();
            String ocString = "";
            for (Object e : clusterIdList) {
                int cid = (Integer)e;
                ocString = ocString + cid + "-";
            }
            if (this.overlappingClusterMap.containsKey(ocString)) {
                Cluster oc = (Cluster)this.overlappingClusterMap.get(ocString);
                node.resetClusters();
                node.addCluster(oc);
                continue;
            }
            this.getClusterManager().createCluster(this.generateClusterID(), null);
            Cluster newCluster = this.getClusterManager().getClusterByID(this.maxClusterId);
            this.overlappingClusterMap.put(ocString, newCluster);
            ArrayList<Object> arrayList = new ArrayList<Object>();
            arrayList.add(newCluster);
            arrayList.add(new ArrayList(node.getClusters()));
            this.zoneGraphEdgeTable.add(arrayList);
            node.resetClusters();
            node.addCluster(newCluster);
        }
    }

    private void addClustersToZoneGraph() {
        for (Cluster o : this.getClusterManager().getClusters()) {
            Cluster c = o;
            if (c.getNodes().size() <= 0) continue;
            ZoneNode newNode = new ZoneNode(this, null);
            newNode.label = Integer.toString(c.getClusterID());
            c.calculatePolygon();
            newNode.polygon = c.getPolygon();
            this.zoneGraph.add(newNode);
        }
    }

    private int generateClusterID() {
        ++this.maxClusterId;
        return this.maxClusterId;
    }

    private int getGreatestClusterId() {
        ArrayList<Integer> ids = this.getClusterManager().getClusterIDs();
        return ids.get(ids.size() - 1);
    }
}

