/*
 * Decompiled with CFR 0.152.
 */
package org.ivis.layout.cluster;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.ivis.layout.Cluster;
import org.ivis.layout.Clustered;
import org.ivis.layout.LEdge;
import org.ivis.layout.LGraph;
import org.ivis.layout.LGraphManager;
import org.ivis.layout.LNode;
import org.ivis.layout.cluster.ClusterEdge;
import org.ivis.layout.cluster.ClusterGraphManager;
import org.ivis.layout.cluster.ClusterNode;
import org.ivis.layout.cluster.ZoneEdge;
import org.ivis.layout.cluster.ZoneGraph;
import org.ivis.layout.cluster.ZoneNode;
import org.ivis.layout.cluster.ZoneTestFrame;
import org.ivis.layout.cose.CoSELayout;
import org.ivis.layout.cose.CoSENode;
import org.ivis.util.IGeometry;
import org.ivis.util.PointD;

public class ClusterLayout
extends CoSELayout {
    @Override
    protected LGraphManager newGraphManager() {
        ClusterGraphManager gm = new ClusterGraphManager(this);
        this.graphManager = gm;
        return gm;
    }

    @Override
    public LEdge newEdge(Object vEdge) {
        return new ClusterEdge(null, null, vEdge);
    }

    @Override
    public LNode newNode(Object vNode) {
        return new ClusterNode(this.graphManager, vNode);
    }

    @Override
    public void initParameters() {
        super.initParameters();
        this.gravityRangeFactor = this.gravityRangeFactor * 1.5;
        this.gravityConstant = this.gravityConstant * 1.5;
    }

    @Override
    public void calculateNodesToApplyGravitationTo() {
        LinkedList nodeList = new LinkedList();
        for (Object obj : this.graphManager.getGraphs()) {
            LGraph graph = (LGraph)obj;
            nodeList.addAll(graph.getNodes());
        }
        this.graphManager.setAllNodesToApplyGravitation(nodeList);
    }

    @Override
    public void calcRepulsionForces() {
        super.calcRepulsionForces();
        if (this.totalIterations % 10 == 0) {
            this.calcZoneGraphRepulsionForces();
        }
    }

    @Override
    public void calcSpringForces() {
        super.calcSpringForces();
        if (this.totalIterations % 10 == 0) {
            this.calcZoneGraphSpringForces();
        }
    }

    @Override
    public boolean layout() {
        if (this.graphManager.getClusterManager().getClusters().size() > 1) {
            ((ClusterGraphManager)this.graphManager).formClusterZones();
        }
        this.setIsInterClusterPropertiesOfAllEdges();
        super.layout();
        return true;
    }

    public void printPolygons() {
        Cluster c;
        Cluster o2;
        Iterator<Cluster> i$ = this.graphManager.getClusterManager().getClusters().iterator();
        while (i$.hasNext()) {
            c = o2 = i$.next();
            System.out.println("Cluster ID " + c.getClusterID());
            System.out.println("There are " + c.getNodes().size() + " nodes");
            System.out.println("Polygon Points: " + c.getPolygon());
            Iterator<Object> i$2 = c.getPolygon().iterator();
            while (i$2.hasNext()) {
                PointD p;
                PointD pt = p = (PointD)i$2.next();
                System.out.println("Pt x:" + pt.x + " , y:" + pt.y);
            }
        }
        i$ = this.graphManager.getClusterManager().getClusters().iterator();
        while (i$.hasNext()) {
            c = o2 = i$.next();
            System.out.println("Nodes are");
            for (Clustered n : c.getNodes()) {
                ClusterNode node = (ClusterNode)n;
                System.out.println(" " + node.label);
            }
            System.out.println("Pg for cluster " + c.getClusterID() + " is: " + c.getPolygon());
        }
        for (Cluster o2 : ((ClusterGraphManager)this.graphManager).zoneGraph.getNodes()) {
            ZoneNode z = (ZoneNode)((Object)o2);
            System.out.println("Zone " + z.label + " clusters are: " + z.polygon);
        }
    }

    public void polygonOverlapTest() {
        ArrayList<Cluster> clusters = this.graphManager.getClusterManager().getClusters();
        for (int i = 0; i < clusters.size() - 1; ++i) {
            ArrayList<PointD> polygonI = clusters.get(i).getPolygon();
            for (int j = i + 1; j < clusters.size(); ++j) {
                System.out.println("Checking clusters " + clusters.get(i).getClusterID() + ", " + clusters.get(j).getClusterID());
                ArrayList<PointD> polygonJ = clusters.get(j).getPolygon();
                Object[] overlap = IGeometry.convexPolygonOverlap(polygonI, polygonJ);
                if ((Double)overlap[0] != 0.0) {
                    PointD temp = IGeometry.getXYProjection((Double)overlap[0], (PointD)overlap[1]);
                    System.out.println("Overlap. x:" + temp.x + ", y:" + temp.y);
                }
                System.out.println("No overlap");
            }
        }
    }

    @Override
    protected void calcIdealEdgeLengths() {
        for (Object obj : this.graphManager.getAllEdges()) {
            ClusterEdge edge = (ClusterEdge)obj;
            edge.idealLength = this.idealEdgeLength * 1.0;
            if (!edge.isInterCluster()) continue;
            if (edge.areNodesZoneNeighbors) {
                edge.idealLength *= 1.3;
                continue;
            }
            edge.idealLength *= 3.0;
        }
    }

    public void calcZoneGraphSpringForces() {
        ZoneGraph zoneGraph = ((ClusterGraphManager)this.graphManager).zoneGraph;
        List zoneEdges = zoneGraph.getEdges();
        List zoneNodes = zoneGraph.getNodes();
        for (int i = 0; i < zoneEdges.size(); ++i) {
            ZoneEdge edge = (ZoneEdge)zoneEdges.get(i);
            assert (!this.uniformLeafNodeSizes);
            this.calcSpringForce(edge, edge.idealLength);
        }
        for (Object o : zoneNodes) {
            this.applySpringForcesToZoneMembers((ZoneNode)o);
        }
    }

    public void calcZoneGraphRepulsionForces() {
        List zones = ((ClusterGraphManager)this.graphManager).zoneGraph.getNodes();
        for (int i = 0; i < zones.size() - 1; ++i) {
            ZoneNode zoneA = (ZoneNode)zones.get(i);
            for (int j = i + 1; j < zones.size(); ++j) {
                ZoneNode zoneB = (ZoneNode)zones.get(j);
                this.calcRepulsionForce(zoneA, zoneB);
            }
            this.applyRepulsionForcesToZoneMembers(zoneA);
        }
    }

    public void applySpringForcesToZoneMembers(ZoneNode zone) {
        int clusterID = Integer.parseInt(zone.label);
        Cluster cluster = this.graphManager.getClusterManager().getClusterByID(clusterID);
        for (Clustered o : cluster.getNodes()) {
            CoSENode node = (CoSENode)o;
            node.springForceX += 1.6 * zone.springForceX;
            node.springForceY += 1.6 * zone.springForceY;
        }
    }

    public void applyRepulsionForcesToZoneMembers(ZoneNode zone) {
        int clusterID = Integer.parseInt(zone.label);
        Cluster cluster = this.graphManager.getClusterManager().getClusterByID(clusterID);
        for (Clustered o : cluster.getNodes()) {
            CoSENode node = (CoSENode)o;
            node.repulsionForceX += 1.5 * zone.repulsionForceX;
            node.repulsionForceY += 1.5 * zone.repulsionForceY;
        }
    }

    protected void moveZoneGraphNodes() {
        List zones = ((ClusterGraphManager)this.graphManager).zoneGraph.getNodes();
        for (Object o : zones) {
            ZoneNode node = (ZoneNode)o;
            node.move();
        }
    }

    public void setIsInterClusterPropertiesOfAllEdges() {
        for (Object edge : this.graphManager.getAllEdges()) {
            ClusterEdge e = (ClusterEdge)edge;
            e.setIsInterCluster();
        }
    }

    @Override
    public void moveNodes() {
        super.moveNodes();
        this.moveZoneGraphNodes();
    }

    public void printNodeInfo(String place) {
        for (Object o : this.graphManager.getAllNodes()) {
            CoSENode node = (CoSENode)o;
            if (!node.label.startsWith("T")) continue;
            System.out.print("Node label:" + node.label + " " + place);
            System.out.println(" x:" + node.getCenterX() + " y:" + node.getCenterY());
            System.out.println("Repulsion forces x:" + node.repulsionForceX + " y:" + node.repulsionForceY);
            System.out.println("");
        }
    }

    public void showZonesInAFrame() {
        ClusterGraphManager gm = (ClusterGraphManager)this.graphManager;
        ArrayList<Cluster> clusters = gm.getClusterManager().getClusters();
        ZoneGraph zoneGraph = ((ClusterGraphManager)this.graphManager).zoneGraph;
        ZoneTestFrame testFrame = new ZoneTestFrame(clusters, zoneGraph);
        testFrame.setVisible(true);
        LGraph graph = (LGraph)this.graphManager.getGraphs().get(0);
        graph.updateBounds(true);
    }

    public void testEdgeLengths() {
        Object[] edges;
        System.out.println("ZONE EDGES");
        List zoneEdges = ((ClusterGraphManager)this.graphManager).zoneGraph.getEdges();
        for (Object o : zoneEdges) {
            ZoneEdge e = (ZoneEdge)o;
            System.out.println("Edge " + e.label + " lenght:" + e.getLength());
        }
        System.out.println("CLUSTER EDGES");
        for (Object o : edges = this.getGraphManager().getAllEdges()) {
            ClusterEdge e = (ClusterEdge)o;
            System.out.println("Edge " + e.label + " lenght:" + e.getLength());
        }
    }

    public void testEdgeTypes() {
        for (Object o : this.getGraphManager().getAllEdges()) {
            ClusterEdge e = (ClusterEdge)o;
        }
    }

    public void testPostProcess() {
        Object[] nodes = this.getGraphManager().getAllNodes();
        ArrayList<Cluster> clusters = this.getGraphManager().getClusterManager().getClusters();
        for (Object o : nodes) {
            ClusterNode node = (ClusterNode)o;
            List nodeZones = node.getClusters();
            double left = node.getLeft();
            double right = node.getRight();
            double top = node.getTop();
            double bottom = node.getBottom();
            ArrayList<PointD> nodePolygon = new ArrayList<PointD>();
            nodePolygon.add(new PointD(left, top));
            nodePolygon.add(new PointD(right, top));
            nodePolygon.add(new PointD(right, bottom));
            nodePolygon.add(new PointD(left, bottom));
            for (Object e : clusters) {
                Cluster zone = (Cluster)e;
                ArrayList<PointD> zonePolygon = zone.getPolygon();
                Object[] overlap = IGeometry.convexPolygonOverlap(nodePolygon, zonePolygon);
                if ((Double)overlap[0] == 0.0) continue;
                int flag = 0;
                for (Cluster nz : nodeZones) {
                    Cluster zoneCluster = nz;
                    if (zone.equals(zoneCluster)) continue;
                    flag = zone.getClusterID();
                }
                if (flag == 0) continue;
                System.out.println(node.label + " overlaps with zone " + flag);
            }
        }
    }

    public void calcZoneGraphGravitationalForces() {
        List zones = ((ClusterGraphManager)this.graphManager).zoneGraph.getNodes();
        for (int i = 0; i < zones.size(); ++i) {
            ZoneNode zone = (ZoneNode)zones.get(i);
            PointD center = zone.center;
            int clusterID = Integer.parseInt(zone.label);
            Cluster cluster = this.graphManager.getClusterManager().getClusterByID(clusterID);
            for (Clustered o : cluster.getNodes()) {
                CoSENode node = (CoSENode)o;
                double distanceX = node.getCenterX() - center.x;
                double distanceY = node.getCenterY() - center.y;
                node.gravitationForceX = -this.gravityConstant * distanceX;
                node.gravitationForceY = -this.gravityConstant * distanceY;
            }
        }
    }

    @Override
    public void calcGravitationalForces() {
        super.calcGravitationalForces();
        if (this.totalIterations % 10 == 0) {
            this.calcZoneGraphGravitationalForces();
        }
    }
}

