/*
 * Decompiled with CFR 0.152.
 */
package org.ivis.layout.cluster;

import java.awt.Dimension;
import java.awt.Point;
import java.util.ArrayList;
import org.ivis.layout.LGraphManager;
import org.ivis.layout.LNode;
import org.ivis.layout.cose.CoSENode;
import org.ivis.util.IGeometry;
import org.ivis.util.PointD;

public class ZoneNode
extends CoSENode {
    public ArrayList<PointD> polygon;
    public PointD center;

    public ZoneNode(LGraphManager gm, Object vNode) {
        super(gm, vNode);
        this.rect = null;
    }

    public ZoneNode(LGraphManager gm, Point loc, Dimension size, Object vNode) {
        super(gm, loc, size, vNode);
        this.rect = null;
    }

    @Override
    public boolean calcOverlap(LNode nodeB, double[] overlapAmount) {
        Object[] overlap;
        ZoneNode b = (ZoneNode)nodeB;
        ArrayList<PointD> polygonA = this.polygon;
        ArrayList<PointD> polygonB = b.polygon;
        if (polygonA.size() > 3 && polygonB.size() > 3 && (Double)(overlap = IGeometry.convexPolygonOverlap(polygonA, polygonB))[0] != 0.0) {
            PointD temp = IGeometry.getXYProjection((Double)overlap[0], (PointD)overlap[1]);
            overlapAmount[0] = temp.x * 3.0;
            overlapAmount[1] = temp.y * 3.0;
            return true;
        }
        return false;
    }

    @Override
    public void calcIntersection(LNode nodeB, double[] clipPoints) {
        IGeometry.getPolygonIntersection(this.polygon, ((ZoneNode)nodeB).polygon, clipPoints);
    }

    public void calcCenter() {
        this.center = IGeometry.getPolygonCenter(this.polygon);
    }

    @Override
    public void move() {
        this.calcCenter();
        this.springForceX = 0.0;
        this.springForceY = 0.0;
        this.repulsionForceX = 0.0;
        this.repulsionForceY = 0.0;
        this.gravitationForceX = 0.0;
        this.gravitationForceY = 0.0;
        this.displacementX = 0.0;
        this.displacementY = 0.0;
    }
}

