/*
 * Decompiled with CFR 0.152.
 */
package org.ivis.layout.cluster;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Line2D;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Random;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.ivis.layout.Cluster;
import org.ivis.layout.cluster.ZoneEdge;
import org.ivis.layout.cluster.ZoneGraph;
import org.ivis.layout.cluster.ZoneNode;
import org.ivis.util.IGeometry;
import org.ivis.util.PointD;

class ZoneTestFrame
extends JFrame {
    ZoneGraph zoneGraph;
    ArrayList<Cluster> clusters;
    Color[] colors;

    public ZoneTestFrame(ArrayList<Cluster> c, ZoneGraph zoneGraph) {
        JPanel panel = new JPanel();
        this.getContentPane().add(panel);
        this.setSize(1280, 960);
        this.setResizable(true);
        this.setDefaultCloseOperation(2);
        this.zoneGraph = zoneGraph;
        this.clusters = c;
        this.colors = new Color[this.clusters.size()];
        Random rnd = new Random();
        for (int i = 0; i < this.clusters.size(); ++i) {
            this.colors[i] = new Color(rnd.nextInt(256), rnd.nextInt(256), rnd.nextInt(256));
        }
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        Graphics2D g2 = (Graphics2D)g;
        double min_x = Double.POSITIVE_INFINITY;
        double min_y = Double.POSITIVE_INFINITY;
        double max_x = Double.NEGATIVE_INFINITY;
        double max_y = Double.NEGATIVE_INFINITY;
        double drawConstant = 1.0;
        Iterator<Cluster> i$ = this.clusters.iterator();
        while (i$.hasNext()) {
            Cluster o;
            Cluster c = o = i$.next();
            ArrayList<PointD> polygon = c.getPolygon();
            for (int i = 1; i < polygon.size(); ++i) {
                PointD pt1 = polygon.get(i - 1);
                PointD pt2 = polygon.get(i);
                if (pt1.x < min_x) {
                    min_x = pt1.x;
                }
                if (pt2.x < min_x) {
                    min_x = pt2.x;
                }
                if (pt1.y < min_y) {
                    min_y = pt1.y;
                }
                if (pt2.y < min_y) {
                    min_y = pt2.y;
                }
                if (pt1.x > max_x) {
                    max_x = pt1.x;
                }
                if (pt2.x > max_x) {
                    max_x = pt2.x;
                }
                if (pt1.y > max_y) {
                    max_y = pt1.y;
                }
                if (!(pt2.y > max_y)) continue;
                max_y = pt2.y;
            }
        }
        if (max_x - min_x + 40.0 > 1280.0 || max_y - min_y + 40.0 > 960.0) {
            double propX = 1280.0 / (max_x - min_x + 40.0);
            double propY = 960.0 / (max_y - min_y + 40.0);
            drawConstant = propX > propY ? propY : propX;
        }
        g2.setStroke(new BasicStroke(3.0f));
        int count = 0;
        for (Cluster o : this.clusters) {
            g2.setColor(this.colors[count]);
            Cluster c = o;
            ArrayList<PointD> polygon = c.getPolygon();
            for (int i = 1; i < polygon.size(); ++i) {
                PointD pt1 = polygon.get(i - 1);
                PointD pt2 = polygon.get(i);
                double p1x = drawConstant * (pt1.x - min_x + 60.0);
                double p1y = drawConstant * (pt1.y - min_y + 60.0);
                double p2x = drawConstant * (pt2.x - min_x + 60.0);
                double p2y = drawConstant * (pt2.y - min_y + 60.0);
                Line2D.Double lin = new Line2D.Double(p1x, p1y, p2x, p2y);
                g2.draw(lin);
            }
            ++count;
        }
        for (Cluster o : this.zoneGraph.getEdges()) {
            ZoneEdge edge = (ZoneEdge)((Object)o);
            ZoneNode target = (ZoneNode)edge.getTarget();
            ZoneNode source = (ZoneNode)edge.getSource();
            double[] result = new double[]{0.0, 0.0, 0.0, 0.0};
            IGeometry.getPolygonIntersection(target.polygon, source.polygon, result);
            double p1x = drawConstant * (result[0] - min_x + 60.0);
            double p1y = drawConstant * (result[1] - min_y + 60.0);
            double p2x = drawConstant * (result[2] - min_x + 60.0);
            double p2y = drawConstant * (result[3] - min_y + 60.0);
            Line2D.Double line = new Line2D.Double(p1x, p1y, p2x, p2y);
            g2.setColor(new Color(0, 0, 0));
            g2.draw(line);
        }
    }
}

