/*
 * Decompiled with CFR 0.152.
 */
package org.ivis.layout.fd;

import java.util.HashSet;
import java.util.Vector;
import org.ivis.layout.LEdge;
import org.ivis.layout.LGraph;
import org.ivis.layout.LNode;
import org.ivis.layout.Layout;
import org.ivis.layout.LayoutOptionsPack;
import org.ivis.layout.fd.FDLayoutEdge;
import org.ivis.layout.fd.FDLayoutNode;
import org.ivis.util.IMath;
import org.ivis.util.RectangleD;

public abstract class FDLayout
extends Layout {
    public boolean useSmartIdealEdgeLengthCalculation = true;
    public double idealEdgeLength = 50.0;
    public double springConstant = 0.45;
    public double repulsionConstant = 4500.0;
    public double gravityConstant = 0.4;
    public double compoundGravityConstant = 1.0;
    public double gravityRangeFactor = 2.0;
    public double compoundGravityRangeFactor = 1.5;
    public double displacementThresholdPerNode = 1.5;
    public boolean useFRGridVariant = true;
    public double coolingFactor = 1.0;
    public double initialCoolingFactor = 1.0;
    public double totalDisplacement = 0.0;
    public double oldTotalDisplacement = 0.0;
    protected int maxIterations = 2500;
    protected int totalIterations;
    protected int notAnimatedIterations;
    public double totalDisplacementThreshold;
    public double maxNodeDisplacement;
    protected double repulsionRange;
    protected Vector[][] grid;

    @Override
    public void initParameters() {
        super.initParameters();
        LayoutOptionsPack.CoSE layoutOptionsPack = LayoutOptionsPack.getInstance().getCoSE();
        if (this.layoutQuality == 2) {
            this.displacementThresholdPerNode += 0.3;
            this.maxIterations = (int)((double)this.maxIterations * 0.8);
        } else if (this.layoutQuality == 0) {
            this.displacementThresholdPerNode -= 0.3;
            this.maxIterations = (int)((double)this.maxIterations * 1.2);
        }
        this.totalIterations = 0;
        this.notAnimatedIterations = 0;
        this.useFRGridVariant = layoutOptionsPack.smartRepulsionRangeCalc;
    }

    public void calcNoOfChildrenForAllNodes() {
        for (Object obj : this.graphManager.getAllNodes()) {
            LNode node = (LNode)obj;
            node.noOfChildren = node.getNoOfChildren();
        }
    }

    protected void calcIdealEdgeLengths() {
        for (Object obj : this.graphManager.getAllEdges()) {
            FDLayoutEdge edge = (FDLayoutEdge)obj;
            edge.idealLength = this.idealEdgeLength;
            if (!edge.isInterGraph()) continue;
            LNode source = edge.getSource();
            LNode target = edge.getTarget();
            int sizeOfSourceInLca = edge.getSourceInLca().getEstimatedSize();
            int sizeOfTargetInLca = edge.getTargetInLca().getEstimatedSize();
            if (this.useSmartIdealEdgeLengthCalculation) {
                edge.idealLength += (double)(sizeOfSourceInLca + sizeOfTargetInLca - 80);
            }
            int lcaDepth = edge.getLca().getInclusionTreeDepth();
            edge.idealLength += 5.0 * (double)(source.getInclusionTreeDepth() + target.getInclusionTreeDepth() - 2 * lcaDepth);
        }
    }

    public void initSpringEmbedder() {
        if (this.incremental) {
            this.coolingFactor = 0.8;
            this.initialCoolingFactor = 0.8;
            this.maxNodeDisplacement = 100.0;
        } else {
            this.coolingFactor = 1.0;
            this.initialCoolingFactor = 1.0;
            this.maxNodeDisplacement = 300.0;
        }
        this.maxIterations = Math.max(this.getAllNodes().length * 5, this.maxIterations);
        this.totalDisplacementThreshold = this.displacementThresholdPerNode * (double)this.getAllNodes().length;
        this.repulsionRange = this.calcRepulsionRange();
    }

    public void calcSpringForces() {
        Object[] lEdges = this.getAllEdges();
        for (int i = 0; i < lEdges.length; ++i) {
            FDLayoutEdge edge = (FDLayoutEdge)lEdges[i];
            this.calcSpringForce(edge, edge.idealLength);
        }
    }

    public void calcRepulsionForces() {
        Object[] lNodes = this.getAllNodes();
        if (this.useFRGridVariant) {
            FDLayoutNode nodeA;
            int i;
            if (this.totalIterations % 10 == 1) {
                this.grid = this.calcGrid(this.graphManager.getRoot());
                for (i = 0; i < lNodes.length; ++i) {
                    nodeA = (FDLayoutNode)lNodes[i];
                    this.addNodeToGrid(nodeA, this.grid, this.graphManager.getRoot().getLeft(), this.graphManager.getRoot().getTop());
                }
            }
            HashSet<FDLayoutNode> processedNodeSet = new HashSet<FDLayoutNode>();
            for (i = 0; i < lNodes.length; ++i) {
                nodeA = (FDLayoutNode)lNodes[i];
                this.calculateRepulsionForceOfANode(this.grid, nodeA, processedNodeSet);
                processedNodeSet.add(nodeA);
            }
        } else {
            for (int i = 0; i < lNodes.length; ++i) {
                FDLayoutNode nodeA = (FDLayoutNode)lNodes[i];
                for (int j = i + 1; j < lNodes.length; ++j) {
                    FDLayoutNode nodeB = (FDLayoutNode)lNodes[j];
                    if (nodeA.getOwner() != nodeB.getOwner()) continue;
                    this.calcRepulsionForce(nodeA, nodeB);
                }
            }
        }
    }

    public void calcGravitationalForces() {
        Object[] lNodes = this.getAllNodesToApplyGravitation();
        for (int i = 0; i < lNodes.length; ++i) {
            FDLayoutNode node = (FDLayoutNode)lNodes[i];
            this.calcGravitationalForce(node);
        }
    }

    public void moveNodes() {
        Object[] lNodes = this.getAllNodes();
        for (int i = 0; i < lNodes.length; ++i) {
            FDLayoutNode node = (FDLayoutNode)lNodes[i];
            node.move();
        }
    }

    public void resetForces() {
        Object[] lNodes = this.getAllNodes();
        for (int i = 0; i < lNodes.length; ++i) {
            FDLayoutNode node = (FDLayoutNode)lNodes[i];
            node.reset();
        }
    }

    protected void calcSpringForce(LEdge edge, double idealLength) {
        FDLayoutNode sourceNode = (FDLayoutNode)edge.getSource();
        FDLayoutNode targetNode = (FDLayoutNode)edge.getTarget();
        if (this.uniformLeafNodeSizes && sourceNode.getChild() == null && targetNode.getChild() == null) {
            edge.updateLengthSimple();
        } else {
            edge.updateLength();
            if (edge.isOverlapingSourceAndTarget()) {
                return;
            }
        }
        double length = edge.getLength();
        double dl = length - idealLength;
        assert (length != 0.0);
        double springForce = this.springConstant * dl;
        double springForceX = springForce * (edge.getLengthX() / length);
        double springForceY = springForce * (edge.getLengthY() / length);
        sourceNode.springForceX += springForceX;
        sourceNode.springForceY += springForceY;
        targetNode.springForceX -= springForceX;
        targetNode.springForceY -= springForceY;
    }

    protected void calcRepulsionForce(FDLayoutNode nodeA, FDLayoutNode nodeB) {
        double[] overlapAmount = new double[2];
        double[] clipPoints = new double[4];
        if (nodeA.calcOverlap(nodeB, overlapAmount)) {
            double repulsionForceX = 2.0 * overlapAmount[0];
            double repulsionForceY = 2.0 * overlapAmount[1];
            double childrenConstant = (double)(nodeA.noOfChildren * nodeB.noOfChildren) / (double)(nodeA.noOfChildren + nodeB.noOfChildren);
            nodeA.repulsionForceX -= childrenConstant * repulsionForceX;
            nodeA.repulsionForceY -= childrenConstant * repulsionForceY;
            nodeB.repulsionForceX += childrenConstant * repulsionForceX;
            nodeB.repulsionForceY += childrenConstant * repulsionForceY;
        } else {
            double distanceY;
            double distanceX;
            if (this.uniformLeafNodeSizes && nodeA.getChild() == null && nodeB.getChild() == null) {
                RectangleD rectA = nodeA.getRect();
                RectangleD rectB = nodeB.getRect();
                distanceX = rectB.getCenterX() - rectA.getCenterX();
                distanceY = rectB.getCenterY() - rectA.getCenterY();
            } else {
                nodeA.calcIntersection(nodeB, clipPoints);
                distanceX = clipPoints[2] - clipPoints[0];
                distanceY = clipPoints[3] - clipPoints[1];
            }
            if (Math.abs(distanceX) < 5.0) {
                distanceX = (double)IMath.sign(distanceX) * 5.0;
            }
            if (Math.abs(distanceY) < 5.0) {
                distanceY = (double)IMath.sign(distanceY) * 5.0;
            }
            double distanceSquared = distanceX * distanceX + distanceY * distanceY;
            double distance = Math.sqrt(distanceSquared);
            double repulsionForce = this.repulsionConstant * (double)nodeA.noOfChildren * (double)nodeB.noOfChildren / distanceSquared;
            double repulsionForceX = repulsionForce * distanceX / distance;
            double repulsionForceY = repulsionForce * distanceY / distance;
            nodeA.repulsionForceX -= repulsionForceX;
            nodeA.repulsionForceY -= repulsionForceY;
            nodeB.repulsionForceX += repulsionForceX;
            nodeB.repulsionForceY += repulsionForceY;
        }
    }

    protected void calcGravitationalForce(FDLayoutNode node) {
        assert (node.gravitationForceX == 0.0 && node.gravitationForceY == 0.0);
        LGraph ownerGraph = node.getOwner();
        double ownerCenterX = ((double)ownerGraph.getRight() + (double)ownerGraph.getLeft()) / 2.0;
        double ownerCenterY = ((double)ownerGraph.getTop() + (double)ownerGraph.getBottom()) / 2.0;
        double distanceX = node.getCenterX() - ownerCenterX;
        double distanceY = node.getCenterY() - ownerCenterY;
        double absDistanceX = Math.abs(distanceX) + node.getWidth() / 2.0;
        double absDistanceY = Math.abs(distanceY) + node.getHeight() / 2.0;
        if (node.getOwner() == this.graphManager.getRoot()) {
            int estimatedSize = (int)((double)ownerGraph.getEstimatedSize() * this.gravityRangeFactor);
            if (absDistanceX > (double)estimatedSize || absDistanceY > (double)estimatedSize) {
                node.gravitationForceX = -this.gravityConstant * distanceX;
                node.gravitationForceY = -this.gravityConstant * distanceY;
            }
        } else {
            int estimatedSize = (int)((double)ownerGraph.getEstimatedSize() * this.compoundGravityRangeFactor);
            if (absDistanceX > (double)estimatedSize || absDistanceY > (double)estimatedSize) {
                node.gravitationForceX = -this.gravityConstant * distanceX * this.compoundGravityConstant;
                node.gravitationForceY = -this.gravityConstant * distanceY * this.compoundGravityConstant;
            }
        }
    }

    protected boolean isConverged() {
        boolean oscilating = false;
        if (this.totalIterations > this.maxIterations / 3) {
            oscilating = Math.abs(this.totalDisplacement - this.oldTotalDisplacement) < 2.0;
        }
        boolean converged = this.totalDisplacement < this.totalDisplacementThreshold;
        this.oldTotalDisplacement = this.totalDisplacement;
        return converged || oscilating;
    }

    protected void animate() {
        if (this.animationDuringLayout && !this.isSubLayout) {
            if (this.notAnimatedIterations == this.animationPeriod) {
                this.update();
                this.notAnimatedIterations = 0;
            } else {
                ++this.notAnimatedIterations;
            }
        }
    }

    protected Vector[][] calcGrid(LGraph g) {
        int sizeX = 0;
        int sizeY = 0;
        sizeX = (int)Math.ceil((double)(g.getRight() - g.getLeft()) / this.repulsionRange);
        sizeY = (int)Math.ceil((double)(g.getBottom() - g.getTop()) / this.repulsionRange);
        Vector[][] grid = new Vector[sizeX][sizeY];
        for (int i = 0; i < sizeX; ++i) {
            for (int j = 0; j < sizeY; ++j) {
                grid[i][j] = new Vector();
            }
        }
        return grid;
    }

    protected void addNodeToGrid(FDLayoutNode v, Vector[][] grid, double left, double top) {
        int startX = 0;
        int finishX = 0;
        int startY = 0;
        int finishY = 0;
        startX = (int)Math.floor((v.getRect().x - left) / this.repulsionRange);
        finishX = (int)Math.floor((v.getRect().width + v.getRect().x - left) / this.repulsionRange);
        startY = (int)Math.floor((v.getRect().y - top) / this.repulsionRange);
        finishY = (int)Math.floor((v.getRect().height + v.getRect().y - top) / this.repulsionRange);
        for (int i = startX; i <= finishX; ++i) {
            for (int j = startY; j <= finishY; ++j) {
                grid[i][j].add(v);
                v.setGridCoordinates(startX, finishX, startY, finishY);
            }
        }
    }

    protected void calculateRepulsionForceOfANode(Vector[][] grid, FDLayoutNode nodeA, HashSet<FDLayoutNode> processedNodeSet) {
        int i;
        if (this.totalIterations % 10 == 1) {
            HashSet<FDLayoutNode> surrounding = new HashSet<FDLayoutNode>();
            for (i = nodeA.startX - 1; i < nodeA.finishX + 2; ++i) {
                for (int j = nodeA.startY - 1; j < nodeA.finishY + 2; ++j) {
                    if (i < 0 || j < 0 || i >= grid.length || j >= grid[0].length) continue;
                    for (Object obj : grid[i][j]) {
                        FDLayoutNode nodeB = (FDLayoutNode)obj;
                        if (nodeA.getOwner() != nodeB.getOwner() || nodeA == nodeB || processedNodeSet.contains(nodeB) || surrounding.contains(nodeB)) continue;
                        double distanceX = Math.abs(nodeA.getCenterX() - nodeB.getCenterX()) - (nodeA.getWidth() / 2.0 + nodeB.getWidth() / 2.0);
                        double distanceY = Math.abs(nodeA.getCenterY() - nodeB.getCenterY()) - (nodeA.getHeight() / 2.0 + nodeB.getHeight() / 2.0);
                        if (!(distanceX <= this.repulsionRange) || !(distanceY <= this.repulsionRange)) continue;
                        surrounding.add(nodeB);
                    }
                }
            }
            nodeA.surrounding = surrounding.toArray();
        }
        for (i = 0; i < nodeA.surrounding.length; ++i) {
            this.calcRepulsionForce(nodeA, (FDLayoutNode)nodeA.surrounding[i]);
        }
    }

    protected double calcRepulsionRange() {
        return 0.0;
    }

    public int getTotalIterations() {
        return this.totalIterations;
    }
}

