/*
 * Decompiled with CFR 0.152.
 */
package org.ivis.util;

import java.awt.Point;
import java.awt.geom.Line2D;
import java.util.ArrayList;
import org.ivis.util.PointD;
import org.ivis.util.RectangleD;

public abstract class IGeometry {
    public static final double HALF_PI = 1.5707963267948966;
    public static final double ONE_AND_HALF_PI = 4.71238898038469;
    public static final double TWO_PI = Math.PI * 2;
    public static final double THREE_PI = Math.PI * 3;
    public static final double TOLERANCE = 1.0E-5;

    public static void calcSeparationAmount(RectangleD rectA, RectangleD rectB, double[] overlapAmount, double separationBuffer) {
        assert (rectA.intersects(rectB));
        double[] directions = new double[2];
        IGeometry.decideDirectionsForOverlappingNodes(rectA, rectB, directions);
        overlapAmount[0] = Math.min(rectA.getRight(), rectB.getRight()) - Math.max(rectA.x, rectB.x);
        overlapAmount[1] = Math.min(rectA.getBottom(), rectB.getBottom()) - Math.max(rectA.y, rectB.y);
        if (rectA.getX() <= rectB.getX() && rectA.getRight() >= rectB.getRight()) {
            overlapAmount[0] = overlapAmount[0] + Math.min(rectB.getX() - rectA.getX(), rectA.getRight() - rectB.getRight());
        } else if (rectB.getX() <= rectA.getX() && rectB.getRight() >= rectA.getRight()) {
            overlapAmount[0] = overlapAmount[0] + Math.min(rectA.getX() - rectB.getX(), rectB.getRight() - rectA.getRight());
        }
        if (rectA.getY() <= rectB.getY() && rectA.getBottom() >= rectB.getBottom()) {
            overlapAmount[1] = overlapAmount[1] + Math.min(rectB.getY() - rectA.getY(), rectA.getBottom() - rectB.getBottom());
        } else if (rectB.getY() <= rectA.getY() && rectB.getBottom() >= rectA.getBottom()) {
            overlapAmount[1] = overlapAmount[1] + Math.min(rectA.getY() - rectB.getY(), rectB.getBottom() - rectA.getBottom());
        }
        double slope = Math.abs((rectB.getCenterY() - rectA.getCenterY()) / (rectB.getCenterX() - rectA.getCenterX()));
        if (rectB.getCenterY() == rectA.getCenterY() && rectB.getCenterX() == rectA.getCenterX()) {
            slope = 1.0;
        }
        double moveByY = slope * overlapAmount[0];
        double moveByX = overlapAmount[1] / slope;
        if (overlapAmount[0] < moveByX) {
            moveByX = overlapAmount[0];
        } else {
            moveByY = overlapAmount[1];
        }
        overlapAmount[0] = -1.0 * directions[0] * (moveByX / 2.0 + separationBuffer);
        overlapAmount[1] = -1.0 * directions[1] * (moveByY / 2.0 + separationBuffer);
    }

    private static void decideDirectionsForOverlappingNodes(RectangleD rectA, RectangleD rectB, double[] directions) {
        directions[0] = rectA.getCenterX() < rectB.getCenterX() ? -1.0 : 1.0;
        directions[1] = rectA.getCenterY() < rectB.getCenterY() ? -1.0 : 1.0;
    }

    public static boolean getIntersection(RectangleD rectA, RectangleD rectB, double[] result) {
        double p1x = rectA.getCenterX();
        double p1y = rectA.getCenterY();
        double p2x = rectB.getCenterX();
        double p2y = rectB.getCenterY();
        if (rectA.intersects(rectB)) {
            result[0] = p1x;
            result[1] = p1y;
            result[2] = p2x;
            result[3] = p2y;
            return true;
        }
        double topLeftAx = rectA.getX();
        double topLeftAy = rectA.getY();
        double topRightAx = rectA.getRight();
        double bottomLeftAx = rectA.getX();
        double bottomLeftAy = rectA.getBottom();
        double bottomRightAx = rectA.getRight();
        double halfWidthA = rectA.getWidthHalf();
        double halfHeightA = rectA.getHeightHalf();
        double topLeftBx = rectB.getX();
        double topLeftBy = rectB.getY();
        double topRightBx = rectB.getRight();
        double bottomLeftBx = rectB.getX();
        double bottomLeftBy = rectB.getBottom();
        double bottomRightBx = rectB.getRight();
        double halfWidthB = rectB.getWidthHalf();
        double halfHeightB = rectB.getHeightHalf();
        boolean clipPointAFound = false;
        boolean clipPointBFound = false;
        if (p1x == p2x) {
            if (p1y > p2y) {
                result[0] = p1x;
                result[1] = topLeftAy;
                result[2] = p2x;
                result[3] = bottomLeftBy;
                return false;
            }
            if (p1y < p2y) {
                result[0] = p1x;
                result[1] = bottomLeftAy;
                result[2] = p2x;
                result[3] = topLeftBy;
                return false;
            }
        } else if (p1y == p2y) {
            if (p1x > p2x) {
                result[0] = topLeftAx;
                result[1] = p1y;
                result[2] = topRightBx;
                result[3] = p2y;
                return false;
            }
            if (p1x < p2x) {
                result[0] = topRightAx;
                result[1] = p1y;
                result[2] = topLeftBx;
                result[3] = p2y;
                return false;
            }
        } else {
            int cardinalDirectionB;
            int cardinalDirectionA;
            double slopeA = rectA.height / rectA.width;
            double slopeB = rectB.height / rectB.width;
            double slopePrime = (p2y - p1y) / (p2x - p1x);
            if (-slopeA == slopePrime) {
                if (p1x > p2x) {
                    result[0] = bottomLeftAx;
                    result[1] = bottomLeftAy;
                    clipPointAFound = true;
                } else {
                    result[0] = topRightAx;
                    result[1] = topLeftAy;
                    clipPointAFound = true;
                }
            } else if (slopeA == slopePrime) {
                if (p1x > p2x) {
                    result[0] = topLeftAx;
                    result[1] = topLeftAy;
                    clipPointAFound = true;
                } else {
                    result[0] = bottomRightAx;
                    result[1] = bottomLeftAy;
                    clipPointAFound = true;
                }
            }
            if (-slopeB == slopePrime) {
                if (p2x > p1x) {
                    result[2] = bottomLeftBx;
                    result[3] = bottomLeftBy;
                    clipPointBFound = true;
                } else {
                    result[2] = topRightBx;
                    result[3] = topLeftBy;
                    clipPointBFound = true;
                }
            } else if (slopeB == slopePrime) {
                if (p2x > p1x) {
                    result[2] = topLeftBx;
                    result[3] = topLeftBy;
                    clipPointBFound = true;
                } else {
                    result[2] = bottomRightBx;
                    result[3] = bottomLeftBy;
                    clipPointBFound = true;
                }
            }
            if (clipPointAFound && clipPointBFound) {
                return false;
            }
            if (p1x > p2x) {
                if (p1y > p2y) {
                    cardinalDirectionA = IGeometry.getCardinalDirection(slopeA, slopePrime, 4);
                    cardinalDirectionB = IGeometry.getCardinalDirection(slopeB, slopePrime, 2);
                } else {
                    cardinalDirectionA = IGeometry.getCardinalDirection(-slopeA, slopePrime, 3);
                    cardinalDirectionB = IGeometry.getCardinalDirection(-slopeB, slopePrime, 1);
                }
            } else if (p1y > p2y) {
                cardinalDirectionA = IGeometry.getCardinalDirection(-slopeA, slopePrime, 1);
                cardinalDirectionB = IGeometry.getCardinalDirection(-slopeB, slopePrime, 3);
            } else {
                cardinalDirectionA = IGeometry.getCardinalDirection(slopeA, slopePrime, 2);
                cardinalDirectionB = IGeometry.getCardinalDirection(slopeB, slopePrime, 4);
            }
            if (!clipPointAFound) {
                switch (cardinalDirectionA) {
                    case 1: {
                        double tempPointAx;
                        double tempPointAy = topLeftAy;
                        result[0] = tempPointAx = p1x + -halfHeightA / slopePrime;
                        result[1] = tempPointAy;
                        break;
                    }
                    case 2: {
                        double tempPointAx = bottomRightAx;
                        double tempPointAy = p1y + halfWidthA * slopePrime;
                        result[0] = tempPointAx;
                        result[1] = tempPointAy;
                        break;
                    }
                    case 3: {
                        double tempPointAx;
                        double tempPointAy = bottomLeftAy;
                        result[0] = tempPointAx = p1x + halfHeightA / slopePrime;
                        result[1] = tempPointAy;
                        break;
                    }
                    case 4: {
                        double tempPointAx = bottomLeftAx;
                        double tempPointAy = p1y + -halfWidthA * slopePrime;
                        result[0] = tempPointAx;
                        result[1] = tempPointAy;
                    }
                }
            }
            if (!clipPointBFound) {
                switch (cardinalDirectionB) {
                    case 1: {
                        double tempPointBx;
                        double tempPointBy = topLeftBy;
                        result[2] = tempPointBx = p2x + -halfHeightB / slopePrime;
                        result[3] = tempPointBy;
                        break;
                    }
                    case 2: {
                        double tempPointBx = bottomRightBx;
                        double tempPointBy = p2y + halfWidthB * slopePrime;
                        result[2] = tempPointBx;
                        result[3] = tempPointBy;
                        break;
                    }
                    case 3: {
                        double tempPointBx;
                        double tempPointBy = bottomLeftBy;
                        result[2] = tempPointBx = p2x + halfHeightB / slopePrime;
                        result[3] = tempPointBy;
                        break;
                    }
                    case 4: {
                        double tempPointBx = bottomLeftBx;
                        double tempPointBy = p2y + -halfWidthB * slopePrime;
                        result[2] = tempPointBx;
                        result[3] = tempPointBy;
                    }
                }
            }
        }
        return false;
    }

    private static int getCardinalDirection(double slope, double slopePrime, int line) {
        if (slope > slopePrime) {
            return line;
        }
        return 1 + line % 4;
    }

    public static Point getIntersection(Point s1, Point s2, Point f1, Point f2) {
        int x1 = s1.x;
        int y1 = s1.y;
        int x2 = s2.x;
        int y2 = s2.y;
        int x3 = f1.x;
        int y3 = f1.y;
        int x4 = f2.x;
        int y4 = f2.y;
        int a1 = y2 - y1;
        int b1 = x1 - x2;
        int c1 = x2 * y1 - x1 * y2;
        int a2 = y4 - y3;
        int b2 = x3 - x4;
        int c2 = x4 * y3 - x3 * y4;
        int denom = a1 * b2 - a2 * b1;
        if (denom == 0) {
            return null;
        }
        int x = (b1 * c2 - b2 * c1) / denom;
        int y = (a2 * c1 - a1 * c2) / denom;
        return new Point(x, y);
    }

    public static double angleOfVector(double Cx, double Cy, double Nx, double Ny) {
        double C_angle;
        if (Cx != Nx) {
            C_angle = Math.atan((Ny - Cy) / (Nx - Cx));
            if (Nx < Cx) {
                C_angle += Math.PI;
            } else if (Ny < Cy) {
                C_angle += Math.PI * 2;
            }
        } else {
            C_angle = Ny < Cy ? 4.71238898038469 : 1.5707963267948966;
        }
        return C_angle;
    }

    public static double radian2degree(double rad) {
        return 180.0 * rad / Math.PI;
    }

    public static boolean doIntersect(PointD p1, PointD p2, PointD p3, PointD p4) {
        boolean result = Line2D.linesIntersect(p1.x, p1.y, p2.x, p2.y, p3.x, p3.y, p4.x, p4.y);
        return result;
    }

    public static PointD normalizeVector(PointD v) {
        double denom = v.x * v.x + v.y * v.y;
        denom = Math.sqrt(denom);
        double x = v.x / denom;
        double y = v.y / denom;
        return new PointD(x, y);
    }

    public static PointD getXYProjection(double magnitude, PointD direction) {
        double sin = direction.y / Math.sqrt(direction.x * direction.x + direction.y * direction.y);
        double cos = direction.x / Math.sqrt(direction.x * direction.x + direction.y * direction.y);
        double x = magnitude * cos;
        double y = magnitude * sin;
        return new PointD(x, y);
    }

    public static double dot(PointD p1, PointD p2) {
        return p1.x * p2.x + p1.y * p2.y;
    }

    public static double[] gatherPolygonProjectionExtents(ArrayList<PointD> p, PointD v) {
        double[] out = new double[]{IGeometry.dot(v, p.get(0)), IGeometry.dot(v, p.get(0))};
        for (int i = 1; i < p.size(); ++i) {
            double d = IGeometry.dot(v, p.get(i));
            if (d < out[0]) {
                out[0] = d;
                continue;
            }
            if (!(d > out[1])) continue;
            out[1] = d;
        }
        return out;
    }

    public static Object[] findSeparatingAxis(ArrayList<PointD> p1, ArrayList<PointD> p2) {
        double minOverlap = Double.NEGATIVE_INFINITY;
        PointD minVector = new PointD(0.0, 0.0);
        Object[] overlapInfo = new Object[2];
        int aVertCount = p1.size();
        int bVertCount = p2.size();
        int prev = aVertCount - 1;
        int cur = 0;
        while (cur < aVertCount) {
            double[] p2Bounds;
            double[] p1Bounds;
            double ex = p1.get((int)cur).x - p1.get((int)prev).x;
            double ey = p1.get((int)cur).y - p1.get((int)prev).y;
            PointD edge = new PointD(ex, ey);
            double vx = edge.y;
            double vy = -edge.x;
            PointD v = IGeometry.normalizeVector(new PointD(vx, vy));
            if (v.y < 0.0) {
                v.x = -v.x;
                v.y = -v.y;
            }
            if ((p1Bounds = IGeometry.gatherPolygonProjectionExtents(p1, v))[1] < (p2Bounds = IGeometry.gatherPolygonProjectionExtents(p2, v))[0]) {
                overlapInfo[0] = 0.0;
                overlapInfo[1] = minVector;
                return overlapInfo;
            }
            double overlap = p2Bounds[0] - p1Bounds[1];
            if (Math.abs(overlap) < Math.abs(minOverlap)) {
                minVector = v;
                minOverlap = overlap;
            }
            if (p2Bounds[1] < p1Bounds[0]) {
                overlapInfo[0] = 0.0;
                overlapInfo[1] = minVector;
                return overlapInfo;
            }
            overlap = p2Bounds[1] - p1Bounds[0];
            if (Math.abs(overlap) < Math.abs(minOverlap)) {
                minVector = v;
                minOverlap = overlap;
            }
            prev = cur++;
        }
        overlapInfo[0] = minOverlap;
        overlapInfo[1] = minVector;
        return overlapInfo;
    }

    public static Object[] convexPolygonOverlap(ArrayList<PointD> p1, ArrayList<PointD> p2) {
        Object[] overlapInfo1 = IGeometry.findSeparatingAxis(p1, p2);
        if ((Double)overlapInfo1[0] == 0.0) {
            return overlapInfo1;
        }
        Object[] overlapInfo2 = IGeometry.findSeparatingAxis(p2, p1);
        if ((Double)overlapInfo2[0] == 0.0) {
            return overlapInfo2;
        }
        if (Math.abs((Double)overlapInfo1[0]) < Math.abs((Double)overlapInfo2[0])) {
            overlapInfo1[0] = -((Double)overlapInfo1[0]).doubleValue();
            return overlapInfo1;
        }
        return overlapInfo2;
    }

    private static void testClippingPoints() {
        RectangleD rectA = new RectangleD(5.0, 6.0, 2.0, 4.0);
        RectangleD rectB = new RectangleD(0.0, 4.0, 1.0, 4.0);
        IGeometry.findAndPrintClipPoints(rectA, rectB);
        rectB = new RectangleD(1.0, 4.0, 1.0, 2.0);
        IGeometry.findAndPrintClipPoints(rectA, rectB);
        rectB = new RectangleD(1.0, 3.0, 3.0, 2.0);
        IGeometry.findAndPrintClipPoints(rectA, rectB);
        rectB = new RectangleD(2.0, 3.0, 2.0, 4.0);
        IGeometry.findAndPrintClipPoints(rectA, rectB);
        rectB = new RectangleD(3.0, 3.0, 2.0, 2.0);
        IGeometry.findAndPrintClipPoints(rectA, rectB);
        rectB = new RectangleD(3.0, 2.0, 4.0, 2.0);
        IGeometry.findAndPrintClipPoints(rectA, rectB);
        rectB = new RectangleD(6.0, 3.0, 2.0, 2.0);
        IGeometry.findAndPrintClipPoints(rectA, rectB);
        rectB = new RectangleD(9.0, 2.0, 4.0, 2.0);
        IGeometry.findAndPrintClipPoints(rectA, rectB);
        rectB = new RectangleD(9.0, 3.0, 2.0, 2.0);
        IGeometry.findAndPrintClipPoints(rectA, rectB);
        rectB = new RectangleD(8.0, 3.0, 2.0, 4.0);
        IGeometry.findAndPrintClipPoints(rectA, rectB);
        rectB = new RectangleD(11.0, 3.0, 3.0, 2.0);
        IGeometry.findAndPrintClipPoints(rectA, rectB);
        rectB = new RectangleD(11.0, 4.0, 1.0, 2.0);
        IGeometry.findAndPrintClipPoints(rectA, rectB);
        rectB = new RectangleD(10.0, 4.0, 1.0, 4.0);
        IGeometry.findAndPrintClipPoints(rectA, rectB);
        rectB = new RectangleD(10.0, 5.0, 2.0, 2.0);
        IGeometry.findAndPrintClipPoints(rectA, rectB);
        rectB = new RectangleD(9.0, 4.5, 2.0, 4.0);
        IGeometry.findAndPrintClipPoints(rectA, rectB);
        rectB = new RectangleD(10.0, 5.8, 0.4, 2.0);
        IGeometry.findAndPrintClipPoints(rectA, rectB);
        rectB = new RectangleD(11.0, 6.0, 2.0, 2.0);
        IGeometry.findAndPrintClipPoints(rectA, rectB);
        rectB = new RectangleD(10.0, 7.8, 0.4, 2.0);
        IGeometry.findAndPrintClipPoints(rectA, rectB);
        rectB = new RectangleD(9.0, 7.5, 1.0, 4.0);
        IGeometry.findAndPrintClipPoints(rectA, rectB);
        rectB = new RectangleD(10.0, 7.0, 2.0, 2.0);
        IGeometry.findAndPrintClipPoints(rectA, rectB);
        rectB = new RectangleD(10.0, 9.0, 2.0, 6.0);
        IGeometry.findAndPrintClipPoints(rectA, rectB);
        rectB = new RectangleD(11.0, 9.0, 2.0, 4.0);
        IGeometry.findAndPrintClipPoints(rectA, rectB);
        rectB = new RectangleD(12.0, 8.0, 4.0, 2.0);
        IGeometry.findAndPrintClipPoints(rectA, rectB);
        rectB = new RectangleD(7.0, 9.0, 2.0, 4.0);
        IGeometry.findAndPrintClipPoints(rectA, rectB);
        rectB = new RectangleD(8.0, 9.0, 4.0, 2.0);
        IGeometry.findAndPrintClipPoints(rectA, rectB);
        rectB = new RectangleD(10.0, 9.0, 2.0, 2.0);
        IGeometry.findAndPrintClipPoints(rectA, rectB);
        rectB = new RectangleD(6.0, 10.0, 2.0, 2.0);
        IGeometry.findAndPrintClipPoints(rectA, rectB);
        rectB = new RectangleD(3.0, 8.0, 4.0, 2.0);
        IGeometry.findAndPrintClipPoints(rectA, rectB);
        rectB = new RectangleD(3.0, 9.0, 2.0, 2.0);
        IGeometry.findAndPrintClipPoints(rectA, rectB);
        rectB = new RectangleD(2.0, 8.0, 4.0, 4.0);
        IGeometry.findAndPrintClipPoints(rectA, rectB);
        rectB = new RectangleD(2.0, 8.0, 2.0, 2.0);
        IGeometry.findAndPrintClipPoints(rectA, rectB);
        rectB = new RectangleD(1.0, 8.0, 2.0, 4.0);
        IGeometry.findAndPrintClipPoints(rectA, rectB);
        rectB = new RectangleD(1.0, 8.5, 1.0, 4.0);
        IGeometry.findAndPrintClipPoints(rectA, rectB);
        rectB = new RectangleD(3.0, 7.0, 2.0, 2.0);
        IGeometry.findAndPrintClipPoints(rectA, rectB);
        rectB = new RectangleD(1.0, 7.5, 1.0, 4.0);
        IGeometry.findAndPrintClipPoints(rectA, rectB);
        rectB = new RectangleD(3.0, 7.8, 0.4, 2.0);
        IGeometry.findAndPrintClipPoints(rectA, rectB);
        rectB = new RectangleD(1.0, 6.0, 2.0, 2.0);
        IGeometry.findAndPrintClipPoints(rectA, rectB);
        rectB = new RectangleD(3.0, 5.8, 0.4, 2.0);
        IGeometry.findAndPrintClipPoints(rectA, rectB);
        rectB = new RectangleD(1.0, 5.0, 1.0, 3.0);
        IGeometry.findAndPrintClipPoints(rectA, rectB);
        rectB = new RectangleD(1.0, 4.0, 3.0, 3.0);
        IGeometry.findAndPrintClipPoints(rectA, rectB);
        rectB = new RectangleD(4.0, 4.0, 3.0, 3.0);
        rectB = new RectangleD(5.0, 6.0, 2.0, 4.0);
    }

    private static void findAndPrintClipPoints(RectangleD rectA, RectangleD rectB) {
        System.out.println("---------------------");
        double[] clipPoints = new double[4];
        System.out.println("RectangleA  X: " + rectA.x + "  Y: " + rectA.y + "  Width: " + rectA.width + "  Height: " + rectA.height);
        System.out.println("RectangleB  X: " + rectB.x + "  Y: " + rectB.y + "  Width: " + rectB.width + "  Height: " + rectB.height);
        IGeometry.getIntersection(rectA, rectB, clipPoints);
        System.out.println("Clip Point of RectA X:" + clipPoints[0] + " Y: " + clipPoints[1]);
        System.out.println("Clip Point of RectB X:" + clipPoints[2] + " Y: " + clipPoints[3]);
    }

    public static PointD findIntersectionOfTwoLineSegments(PointD p1A, PointD p2A, PointD p1B, PointD p2B) {
        PointD intersectionPt = new PointD();
        double slopeA = (p2A.y - p1A.y) / (p2A.x - p1A.x);
        double slopeB = (p2B.y - p1B.y) / (p2B.x - p1B.x);
        double constantA = p1A.y - slopeA * p1A.x;
        double constantB = p1B.y - slopeB * p1B.x;
        if (slopeA == Double.NEGATIVE_INFINITY || slopeA == Double.POSITIVE_INFINITY) {
            intersectionPt.x = p1A.x;
            intersectionPt.y = slopeB * p1A.x + constantB;
        } else if (slopeB == Double.NEGATIVE_INFINITY || slopeB == Double.POSITIVE_INFINITY) {
            intersectionPt.x = p1B.x;
            intersectionPt.y = slopeA * p1B.x + constantA;
        } else {
            if (Double.isNaN(slopeA) || Double.isNaN(slopeB)) {
                return new PointD(-1.0, -1.0);
            }
            intersectionPt.x = (constantB - constantA) / (slopeA - slopeB);
            intersectionPt.y = slopeA * intersectionPt.x + constantA;
        }
        if (IGeometry.isPointOnLineSegment(p1A, p2A, intersectionPt) && IGeometry.isPointOnLineSegment(p1B, p2B, intersectionPt)) {
            return intersectionPt;
        }
        intersectionPt.x = -1.0;
        intersectionPt.y = -1.0;
        return intersectionPt;
    }

    public static boolean getPolygonIntersection(ArrayList<PointD> polygonA, ArrayList<PointD> polygonB, double[] result) {
        result[0] = -1.0;
        result[1] = -1.0;
        result[2] = -1.0;
        result[3] = -1.0;
        if (polygonA.size() > 3 && polygonB.size() > 3) {
            int i;
            PointD centerA = IGeometry.getPolygonCenter(polygonA);
            PointD centerB = IGeometry.getPolygonCenter(polygonB);
            PointD clipPtA = IGeometry.findIntersectionOfTwoLineSegments(centerA, centerB, polygonA.get(0), polygonA.get(polygonA.size() - 1));
            for (i = 1; i < polygonA.size() && (clipPtA.x == -1.0 || clipPtA.y == -1.0); ++i) {
                clipPtA = IGeometry.findIntersectionOfTwoLineSegments(centerA, centerB, polygonA.get(i - 1), polygonA.get(i));
            }
            PointD clipPtB = IGeometry.findIntersectionOfTwoLineSegments(centerA, centerB, polygonB.get(0), polygonB.get(polygonB.size() - 1));
            for (i = 1; i < polygonB.size() && (clipPtB.x == -1.0 || clipPtB.y == -1.0); ++i) {
                clipPtB = IGeometry.findIntersectionOfTwoLineSegments(centerA, centerB, polygonB.get(i - 1), polygonB.get(i));
            }
            result[0] = clipPtA.x;
            result[1] = clipPtA.y;
            result[2] = clipPtB.x;
            result[3] = clipPtB.y;
            if (result[0] == -1.0 && result[1] == -1.0 || result[2] == -1.0 && result[3] == -1.0) {
                result[0] = centerA.x;
                result[1] = centerA.y;
                result[2] = centerB.x;
                result[3] = centerB.y;
                return true;
            }
            return false;
        }
        System.out.println("What am i doing here?");
        return false;
    }

    public static PointD getPolygonCenter(ArrayList<PointD> polygon) {
        double[] centroid = new double[]{0.0, 0.0};
        double signedArea = 0.0;
        double x0 = 0.0;
        double y0 = 0.0;
        double x1 = 0.0;
        double y1 = 0.0;
        double a = 0.0;
        if (polygon.size() < 3) {
            System.out.println("Not a valid polygon");
        } else {
            for (int i = 0; i < polygon.size() - 1; ++i) {
                x0 = polygon.get((int)i).x;
                y0 = polygon.get((int)i).y;
                x1 = polygon.get((int)(i + 1)).x;
                y1 = polygon.get((int)(i + 1)).y;
                a = x0 * y1 - x1 * y0;
                signedArea += a;
                centroid[0] = centroid[0] + (x0 + x1) * a;
                centroid[1] = centroid[1] + (y0 + y1) * a;
            }
            x0 = polygon.get((int)(polygon.size() - 1)).x;
            y0 = polygon.get((int)(polygon.size() - 1)).y;
            x1 = polygon.get((int)0).x;
            y1 = polygon.get((int)0).y;
            a = x0 * y1 - x1 * y0;
            signedArea += a;
            centroid[0] = centroid[0] + (x0 + x1) * a;
            centroid[1] = centroid[1] + (y0 + y1) * a;
            centroid[0] = centroid[0] / (6.0 * (signedArea *= 0.5));
            centroid[1] = centroid[1] / (6.0 * signedArea);
        }
        return new PointD(centroid[0], centroid[1]);
    }

    public static boolean isPointOnLineSegment(PointD linePointA, PointD linePointB, PointD point) {
        double ab;
        double bc;
        double ac = Math.sqrt((linePointA.x - point.x) * (linePointA.x - point.x) + (linePointA.y - point.y) * (linePointA.y - point.y));
        return Math.abs(ac + (bc = Math.sqrt((linePointB.x - point.x) * (linePointB.x - point.x) + (linePointB.y - point.y) * (linePointB.y - point.y))) - (ab = Math.sqrt((linePointA.x - linePointB.x) * (linePointA.x - linePointB.x) + (linePointA.y - linePointB.y) * (linePointA.y - linePointB.y)))) < 1.0E-5;
    }

    public static void testLineSegment() {
        PointD linePointA = new PointD(2.0, 2.0);
        PointD linePointB = new PointD(2.0, 4.0);
        PointD point = new PointD(2.0, 3.0);
        System.out.println(IGeometry.isPointOnLineSegment(linePointA, linePointB, point));
        point = new PointD(2.0, 3.5);
        System.out.println(IGeometry.isPointOnLineSegment(linePointA, linePointB, point));
        point = new PointD(2.0, 1.0);
        System.out.println(IGeometry.isPointOnLineSegment(linePointA, linePointB, point));
        point = new PointD(2.0, 5.0);
        System.out.println(IGeometry.isPointOnLineSegment(linePointA, linePointB, point));
        point = new PointD(5.0, 5.0);
        System.out.println(IGeometry.isPointOnLineSegment(linePointA, linePointB, point));
        point = new PointD(5.0, 3.0);
        System.out.println(IGeometry.isPointOnLineSegment(linePointA, linePointB, point));
        point = new PointD(2.0, 4.0);
        System.out.println(IGeometry.isPointOnLineSegment(linePointA, linePointB, point));
        PointD intersect = IGeometry.findIntersectionOfTwoLineSegments(new PointD(0.0, 1.0), new PointD(4.0, 5.0), new PointD(2.0, 1.0), new PointD(2.0, 5.0));
        System.out.println(intersect.x + ", " + intersect.y);
        ArrayList<PointD> polygon = new ArrayList<PointD>();
        polygon.add(new PointD(2.0, 2.0));
        polygon.add(new PointD(2.0, 4.0));
        polygon.add(new PointD(4.0, 4.0));
        polygon.add(new PointD(4.0, 2.0));
        PointD center = IGeometry.getPolygonCenter(polygon);
        System.out.println(center.x + ", " + center.y);
        double[] result = new double[]{0.0, 0.0, 0.0, 0.0};
        ArrayList<PointD> p1 = new ArrayList<PointD>();
        ArrayList<PointD> p2 = new ArrayList<PointD>();
        ArrayList<PointD> p3 = new ArrayList<PointD>();
        p1.add(new PointD(2.0, 2.0));
        p1.add(new PointD(1.0, 3.0));
        p1.add(new PointD(2.0, 4.0));
        p1.add(new PointD(4.0, 4.0));
        p1.add(new PointD(5.0, 3.0));
        p1.add(new PointD(4.0, 2.0));
        p2.add(new PointD(3.0, 3.0));
        p2.add(new PointD(3.0, 5.0));
        p2.add(new PointD(5.0, 5.0));
        p2.add(new PointD(5.0, 3.0));
        p3.add(new PointD(6.0, 4.0));
        p3.add(new PointD(6.0, 6.0));
        p3.add(new PointD(8.0, 6.0));
        p3.add(new PointD(8.0, 4.0));
        IGeometry.getPolygonIntersection(p1, p2, result);
        System.out.println("[0]:" + result[0] + " [1]:" + result[1] + " [2]:" + result[2] + " [3]:" + result[3]);
        IGeometry.getPolygonIntersection(p1, p3, result);
        System.out.println("[0]:" + result[0] + " [1]:" + result[1] + " [2]:" + result[2] + " [3]:" + result[3]);
    }

    public static double calculateAngle(PointD targetPnt, PointD centerPnt, PointD node) {
        PointD point1 = new PointD(targetPnt.x - centerPnt.x, targetPnt.y - centerPnt.y);
        PointD point2 = new PointD(node.x - centerPnt.x, node.y - centerPnt.y);
        if (Math.abs(point1.x) < 0.0) {
            point1.x = 1.0E-4;
        }
        if (Math.abs(point1.y) < 0.0) {
            point1.y = 1.0E-4;
        }
        double angleValue = (point1.x * point2.x + point1.y * point2.y) / (Math.sqrt(point1.x * point1.x + point1.y * point1.y) * Math.sqrt(point2.x * point2.x + point2.y * point2.y));
        return Math.abs(Math.toDegrees(Math.acos(angleValue)));
    }

    public static void main(String[] args) {
        IGeometry.testLineSegment();
    }
}

