/*
 * Decompiled with CFR 0.152.
 */
package org.patika.mada.algorithm;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.patika.mada.graph.Edge;
import org.patika.mada.graph.GraphObject;
import org.patika.mada.graph.Node;

public class BFS {
    private Map<GraphObject, Integer> dist;
    private Map<GraphObject, Integer> colors;
    private Set<Node> sourceSet;
    private Set<Node> stopSet;
    private boolean isFwd;
    private int limit;
    public static final int WHITE = 0;
    public static final int GRAY = 1;
    public static final int BLACK = 2;

    public BFS(Set<Node> sourceSet, Set<Node> stopSet, boolean direction, int limit) {
        this.sourceSet = sourceSet;
        this.stopSet = stopSet;
        this.isFwd = direction;
        this.limit = limit;
    }

    public Map<GraphObject, Integer> run() {
        this.dist = new HashMap<GraphObject, Integer>();
        this.colors = new HashMap<GraphObject, Integer>();
        LinkedList<Node> queue = new LinkedList<Node>();
        for (Node source : this.sourceSet) {
            this.setLabel(source, 0);
            this.setColor(source, 1);
        }
        if (this.limit > 0) {
            queue.addAll(this.sourceSet);
        }
        while (!queue.isEmpty()) {
            Node current = (Node)queue.remove(0);
            for (Edge edge : this.isFwd ? current.getDownstream() : current.getUpstream()) {
                Node neigh;
                if (this.isFwd || !current.isBreadthNode() || edge.isEquivalenceEdge()) {
                    this.setLabel(edge, this.getLabel(current));
                } else {
                    this.setLabel(edge, this.getLabel(current) + 1);
                }
                if (this.getColor(neigh = this.isFwd ? edge.getTargetNode() : edge.getSourceNode()) != 0) continue;
                if (!neigh.isBreadthNode() || !this.isFwd || edge.isEquivalenceEdge()) {
                    this.setLabel(neigh, this.getLabel(edge));
                } else {
                    this.setLabel(neigh, this.getLabel(current) + 1);
                }
                if (!(this.stopSet != null && this.stopSet.contains(neigh) || neigh.isBreadthNode() && this.getLabel(neigh) >= this.limit)) {
                    this.setColor(neigh, 1);
                    if (neigh.isBreadthNode()) {
                        queue.addLast(neigh);
                        continue;
                    }
                    queue.addFirst(neigh);
                    continue;
                }
                this.setColor(neigh, 2);
            }
            this.setColor(current, 2);
        }
        return this.dist;
    }

    private int getColor(Node node) {
        if (!this.colors.containsKey(node)) {
            return 0;
        }
        return this.colors.get(node);
    }

    private void setColor(Node node, int color) {
        this.colors.put(node, color);
    }

    public int getLabel(GraphObject go) {
        if (!this.dist.containsKey(go)) {
            return Integer.MAX_VALUE - this.limit * 2;
        }
        return this.dist.get(go);
    }

    private void setLabel(GraphObject go, int label) {
        this.dist.put(go, label);
    }
}

