/*
 * Decompiled with CFR 0.152.
 */
package org.patika.mada.algorithm;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.patika.mada.algorithm.BFS;
import org.patika.mada.graph.GraphObject;
import org.patika.mada.graph.Node;

public class LocalCommonStreamQuery {
    private Collection<Set<Node>> sourceSet;
    private boolean isFwd;
    private int limit;
    Map<GraphObject, Integer> reachedCount = new HashMap<GraphObject, Integer>();
    private Set<Node> queryResult;

    public LocalCommonStreamQuery(Set<Node> sourceNodeSet, boolean isFwd, int limit) {
        this.sourceSet = new LinkedHashSet<Set<Node>>();
        for (Node node : sourceNodeSet) {
            HashSet<Node> sourceNode = new HashSet<Node>();
            sourceNode.add(node);
            this.sourceSet.add(sourceNode);
        }
        this.isFwd = isFwd;
        this.limit = limit;
    }

    public LocalCommonStreamQuery(Collection<Set<Node>> sourceStateSet, boolean isFwd, int limit) {
        this.sourceSet = sourceStateSet;
        this.isFwd = isFwd;
        this.limit = limit;
    }

    public Set<Node> run() {
        HashMap candidate = new HashMap();
        HashSet<GraphObject> result = new HashSet<GraphObject>();
        for (Set<Node> source : this.sourceSet) {
            BFS bfs = new BFS(source, null, this.isFwd, this.limit);
            HashMap<GraphObject, Integer> BFSResult = new HashMap<GraphObject, Integer>();
            BFSResult.putAll(bfs.run());
            for (GraphObject go : BFSResult.keySet()) {
                this.setLabel(go, this.getLabel(go) + 1);
            }
            candidate.putAll(BFSResult);
        }
        for (GraphObject go : candidate.keySet()) {
            if (this.getLabel(go) != this.sourceSet.size()) continue;
            result.add(go);
        }
        this.queryResult = new HashSet<Node>();
        for (GraphObject go : result) {
            if (!(go instanceof Node)) continue;
            this.queryResult.add((Node)go);
        }
        return this.queryResult;
    }

    private int getLabel(GraphObject go) {
        if (!this.reachedCount.containsKey(go)) {
            return 0;
        }
        return this.reachedCount.get(go);
    }

    private void setLabel(GraphObject go, int label) {
        this.reachedCount.put(go, label);
    }
}

