/*
 * Decompiled with CFR 0.152.
 */
package org.patika.mada.algorithm;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.patika.mada.algorithm.BFS;
import org.patika.mada.graph.GraphObject;
import org.patika.mada.graph.Node;

public class LocalNeighborhoodQuery {
    private Set<Node> sourceNodes;
    private boolean isUpstream;
    private boolean isDownstream;
    private int limit;
    private Map<GraphObject, Integer> mapBackward;
    private Map<GraphObject, Integer> mapForward;
    private Set<GraphObject> queryResult = new HashSet<GraphObject>();

    public LocalNeighborhoodQuery(Set<Node> sourceNodes, boolean isUpstream, boolean isDownstream, int limit) {
        this.sourceNodes = sourceNodes;
        this.isUpstream = isUpstream;
        this.isDownstream = isDownstream;
        this.limit = limit;
    }

    public Set<GraphObject> run() {
        BFS bfsBackward = null;
        BFS bfsForward = null;
        if (this.isUpstream) {
            bfsBackward = new BFS(this.sourceNodes, null, false, this.limit);
            this.mapBackward = bfsBackward.run();
            this.queryResult.addAll(this.mapBackward.keySet());
        }
        if (this.isDownstream) {
            bfsForward = new BFS(this.sourceNodes, null, true, this.limit);
            this.mapForward = bfsForward.run();
            this.queryResult.addAll(this.mapForward.keySet());
        }
        return this.queryResult;
    }
}

