/*
 * Decompiled with CFR 0.152.
 */
package org.patika.mada.algorithm;

import java.util.HashSet;
import java.util.Set;
import org.patika.mada.graph.Edge;
import org.patika.mada.graph.GraphObject;
import org.patika.mada.graph.Node;

public class PathsBetweenSIFWithLinkers {
    private Set<Node> sourceSeed;
    Set<GraphObject> goi;

    public PathsBetweenSIFWithLinkers(Set<Node> seed) {
        this.sourceSeed = seed;
    }

    public Set<GraphObject> run() {
        this.goi = new HashSet<GraphObject>();
        HashSet<Node> goi = new HashSet<Node>(this.sourceSeed);
        HashSet<GraphObject> consider = new HashSet<GraphObject>();
        for (Node node : this.sourceSeed) {
            consider.addAll(this.getNeighbors(node));
        }
        consider.addAll(this.sourceSeed);
        for (GraphObject go : consider) {
            if (!(go instanceof Node)) continue;
            Node node = (Node)go;
            Set<GraphObject> neigh = this.getNeighbors(node);
            neigh.retainAll(this.sourceSeed);
            if (neigh.size() <= 1) continue;
            goi.add((Node)go);
        }
        for (GraphObject go : consider) {
            Edge edge;
            if (!(go instanceof Edge) || !goi.contains((edge = (Edge)go).getSourceNode()) || !goi.contains(edge.getTargetNode())) continue;
            this.goi.add(edge);
            this.goi.add(edge.getSourceNode());
            this.goi.add(edge.getTargetNode());
        }
        return this.goi;
    }

    public Set<GraphObject> getNeighbors(Node node) {
        HashSet<GraphObject> n = new HashSet<GraphObject>();
        for (Edge edge : node.getUpstream()) {
            n.add(edge);
            n.add(edge.getSourceNode());
        }
        for (Edge edge : node.getDownstream()) {
            n.add(edge);
            n.add(edge.getTargetNode());
        }
        return n;
    }
}

