/*
 * Decompiled with CFR 0.152.
 */
package org.patika.mada.algorithm;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.patika.mada.algorithm.PathsBetweenSIF;
import org.patika.mada.graph.Edge;
import org.patika.mada.graph.GraphObject;
import org.patika.mada.graph.Node;

public class PathsBetweenSIFWithMinimalLinkers {
    private Set<Node> sourceSeed;
    Set<GraphObject> goi;

    public PathsBetweenSIFWithMinimalLinkers(Set<Node> seed) {
        this.sourceSeed = seed;
    }

    public Set<GraphObject> run() {
        PathsBetweenSIF pb = new PathsBetweenSIF(this.sourceSeed, false, 1);
        Set<GraphObject> pbResult = pb.run();
        Set<Set<Node>> components = this.generateConnectedComponents(pbResult);
        for (Node node : this.getDetached(this.sourceSeed, components)) {
            components.add(Collections.singleton(node));
        }
        Map<Node, Set<Node>> nodeToComp = this.mapFromComponentSet(components);
        HashSet<Node> goi = new HashSet<Node>(this.sourceSeed);
        HashSet<GraphObject> consider = new HashSet<GraphObject>();
        for (Set<Node> component : components) {
            consider.addAll(this.getNeighbors(component));
        }
        consider.addAll(this.sourceSeed);
        for (GraphObject go : consider) {
            Set<GraphObject> neigh;
            if (!(go instanceof Node) || this.findNumberOfConnectedComponents(neigh = this.getNeighbors((Node)go), nodeToComp) <= 1) continue;
            goi.add((Node)go);
        }
        this.goi = new HashSet<GraphObject>();
        for (GraphObject go : consider) {
            Edge edge;
            if (!(go instanceof Edge) || !goi.contains((edge = (Edge)go).getSourceNode()) || !goi.contains(edge.getTargetNode())) continue;
            this.goi.add(edge);
            this.goi.add(edge.getSourceNode());
            this.goi.add(edge.getTargetNode());
        }
        return this.goi;
    }

    private Map<Node, Set<Node>> mapFromComponentSet(Set<Set<Node>> components) {
        HashMap<Node, Set<Node>> nodeToComp = new HashMap<Node, Set<Node>>();
        for (Set<Node> component : components) {
            for (Node node : component) {
                if (nodeToComp.containsKey(node)) {
                    throw new RuntimeException("Components have to be disjoint. This is violated here.");
                }
                nodeToComp.put(node, component);
            }
        }
        return nodeToComp;
    }

    public int findNumberOfConnectedComponents(Set<GraphObject> objects, Map<Node, Set<Node>> nodeToComponent) {
        HashSet<Set<Node>> found = new HashSet<Set<Node>>();
        for (GraphObject o : objects) {
            if (!nodeToComponent.containsKey(o)) continue;
            found.add(nodeToComponent.get(o));
        }
        return found.size();
    }

    public Set<GraphObject> getNeighbors(Set<Node> nodes) {
        HashSet<GraphObject> neigh = new HashSet<GraphObject>();
        for (Node node : nodes) {
            neigh.addAll(this.getNeighbors(node));
        }
        return neigh;
    }

    public Set<GraphObject> getNeighbors(Node node) {
        HashSet<GraphObject> n = new HashSet<GraphObject>();
        for (Edge edge : node.getUpstream()) {
            n.add(edge);
            n.add(edge.getSourceNode());
        }
        for (Edge edge : node.getDownstream()) {
            n.add(edge);
            n.add(edge.getTargetNode());
        }
        return n;
    }

    private Set<Set<Node>> generateConnectedComponents(Set<GraphObject> objects) {
        HashSet<Set<Node>> components = new HashSet<Set<Node>>();
        for (GraphObject o : objects) {
            if (!(o instanceof Edge)) continue;
            Edge e = (Edge)o;
            Set<Node> set1 = this.getRelatedSet(e.getSourceNode(), components);
            Set<Node> set2 = this.getRelatedSet(e.getTargetNode(), components);
            if (set1 == null) {
                if (set2 == null) {
                    MySet<Node> set = new MySet<Node>(new HashSet());
                    set.add(e.getSourceNode());
                    set.add(e.getTargetNode());
                    components.add(set);
                    for (Set set3 : components) {
                        assert (components.contains(set3));
                    }
                    continue;
                }
                set2.add(e.getSourceNode());
                for (Set set : components) {
                    assert (components.contains(set));
                }
                continue;
            }
            if (set2 == null) {
                set1.add(e.getTargetNode());
                for (Set set : components) {
                    assert (components.contains(set));
                }
                continue;
            }
            if (set1 == set2) continue;
            set1.addAll(set2);
            components.remove(set2);
            for (Set set : components) {
                assert (components.contains(set));
            }
        }
        return components;
    }

    private Set<Node> getRelatedSet(Node node, Set<Set<Node>> sets) {
        Set<Node> result = null;
        for (Set<Node> set : sets) {
            if (!set.contains(node)) continue;
            if (result != null) {
                throw new RuntimeException("Multiple sets contains same node. Should not happen.");
            }
            result = set;
        }
        return result;
    }

    private Set<Node> getDetached(Set<Node> sources, Set<Set<Node>> components) {
        HashSet<Node> detached = new HashSet<Node>(sources);
        HashSet<Node> connected = new HashSet<Node>();
        for (Set<Node> component : components) {
            connected.addAll(component);
        }
        detached.removeAll(connected);
        return detached;
    }

    class MySet<E>
    implements Set<E> {
        Set<E> set;

        public MySet(Set<E> set) {
            this.set = set;
        }

        @Override
        public int size() {
            return this.set.size();
        }

        @Override
        public boolean isEmpty() {
            return this.set.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return this.set.contains(o);
        }

        @Override
        public Iterator<E> iterator() {
            return this.set.iterator();
        }

        @Override
        public Object[] toArray() {
            return this.set.toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return this.set.toArray(a);
        }

        @Override
        public boolean add(E e) {
            return this.set.add(e);
        }

        @Override
        public boolean remove(Object o) {
            return this.set.remove(o);
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return this.set.containsAll(c);
        }

        @Override
        public boolean addAll(Collection<? extends E> c) {
            return this.set.addAll(c);
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            return this.set.retainAll(c);
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            return this.set.removeAll(c);
        }

        @Override
        public void clear() {
            this.set.clear();
        }
    }
}

