/*
 * Decompiled with CFR 0.152.
 */
package org.patika.mada.algorithm;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gvt.model.biopaxl2.Complex;
import org.gvt.model.biopaxl2.ComplexMember;
import org.patika.mada.graph.Edge;
import org.patika.mada.graph.Graph;
import org.patika.mada.graph.Node;
import org.patika.mada.util.CausativePath;

public class SearchCauses {
    private Graph graph;
    private Set<? extends Node> targets;
    private int t;
    private int k;
    private int limit;
    private Map<Node, Map<Integer, List<CausativePath>>> result;
    private static final String EDGE = "EDGE";
    private static final String ON_PATH = "ON_PATH";
    private static final String MAX_PATH_LENGTH = "MAX_PATH_LENGTH";
    private static final int TOWARDS_CHILDREN = 0;
    private static final int TOWARDS_PARENTS = 1;
    private static final int TOWARDS_BOTHWAYS = 2;

    public SearchCauses(Graph graph, Set<? extends Node> targets, int limit, int t, int k) {
        this.graph = graph;
        this.targets = targets;
        this.limit = limit;
        this.t = t;
        this.k = k;
    }

    public Map<Node, Map<Integer, List<CausativePath>>> run() {
        this.result = new HashMap<Node, Map<Integer, List<CausativePath>>>();
        for (Node node : this.targets != null ? this.targets : this.graph.getNodes()) {
            if (!node.hasSignificantExperimentalChange("Expression Data")) continue;
            this.searchForTarget(node);
        }
        this.pruneResult();
        this.clearLabels();
        return this.result;
    }

    private void searchForTarget(Node target) {
        CurrentPath<Node> path = new CurrentPath<Node>();
        target.putLabel(MAX_PATH_LENGTH, this.limit);
        Set<Node> destSet = this.getDestinationSet(target, target);
        if (destSet != null && !destSet.isEmpty()) {
            this.traverseUpstream(target, target, path, 1, destSet, new HashSet<Node>());
        }
    }

    private void traverseUpstream(Node node, Node target, CurrentPath<Node> path, int sign, Set<Node> destSet, Set<Node> forbidden) {
        int maxLength = (Integer)target.getLabel(MAX_PATH_LENGTH);
        assert (path.getSize() <= maxLength) : "Length limit is violated. path size: " + path.getSize() + " maxlength: " + maxLength;
        if (path.getSize() == maxLength) {
            return;
        }
        for (Edge edge : node.getUpstream()) {
            Set<Node> newDestSet;
            if (!edge.isCausative()) continue;
            int edgeSign = edge.getSign();
            Node neigh = edge.getSourceNode();
            if (neigh == target || neigh.hasLabel(ON_PATH) || forbidden.contains(neigh) || (newDestSet = this.filterDestinationSources(neigh, target, destSet)).isEmpty() && !destSet.contains(neigh)) continue;
            boolean distIncr = neigh.isBreadthNode() && edge.isBreadthEdge();
            Set<Node> tabu = this.keepDifference(forbidden, neigh.getTabuNodes());
            forbidden.addAll(tabu);
            neigh.putLabel(EDGE, edge);
            neigh.putLabel(ON_PATH, true);
            path.addFirst(neigh, distIncr);
            this.checkAndProceed(neigh, target, path, sign * edgeSign, newDestSet, forbidden, 2);
            path.removeFirst(distIncr);
            neigh.removeLabel(ON_PATH);
            neigh.removeLabel(EDGE);
            forbidden.removeAll(tabu);
        }
    }

    private void traverseRelatives(Node node, Node target, CurrentPath<Node> path, int sign, Set<Node> destSet, Set<Node> forbidden, int direction) {
        for (Node node2 : direction == 0 ? node.getChildren() : node.getParents()) {
            Set<Node> newDestSet;
            if (node2 == target || node2.hasLabel(ON_PATH) || (newDestSet = this.filterDestinationSources(node2, target, destSet)).isEmpty()) continue;
            node2.putLabel(ON_PATH, true);
            path.addFirst(node2, false);
            this.checkAndProceed(node2, target, path, sign, newDestSet, forbidden, direction);
            path.removeFirst(false);
            node2.removeLabel(ON_PATH);
        }
    }

    private void checkAndProceed(Node node, Node target, CurrentPath<Node> path, int sign, Set<Node> destSet, Set<Node> forbidden, int relativeDirection) {
        if (node.hasSignificantExperimentalChange("Expression Data")) {
            if (this.isCompatible(node, target, sign)) {
                this.recordPath(node, target, path);
            }
            return;
        }
        this.traverseUpstream(node, target, path, sign, destSet, forbidden);
        if (relativeDirection == 0 || relativeDirection == 2) {
            this.traverseRelatives(node, target, path, sign, destSet, forbidden, 0);
        }
        if (relativeDirection == 1 || relativeDirection == 2) {
            this.traverseRelatives(node, target, path, sign, destSet, forbidden, 1);
        }
    }

    private boolean isCompatible(Node from, Node to, int sign) {
        boolean identityProblemExists = from.sameEntity(to);
        if (!identityProblemExists) {
            if (from instanceof ComplexMember) {
                identityProblemExists = this.sameEntityWithAMember((Complex)from.getParents().iterator().next(), to);
            }
            if (!identityProblemExists && to instanceof ComplexMember) {
                identityProblemExists = this.sameEntityWithAMember((Complex)to.getParents().iterator().next(), from);
            }
        }
        return !identityProblemExists && from.getExperimentDataSign("Expression Data") * to.getExperimentDataSign("Expression Data") == sign;
    }

    private boolean sameEntityWithAMember(Complex c, Node node) {
        for (Object o : c.getChildren()) {
            Node child = (Node)o;
            if (!child.sameEntity(node)) continue;
            return true;
        }
        return false;
    }

    private void recordPath(Node source, Node target, CurrentPath<Node> path) {
        Map<Integer, List<CausativePath>> pathMap;
        int length = path.getSize();
        if (length > this.getShortestDistance(source, target) + this.k) {
            System.out.println("Found and ignored a non-(shortest+k) path this should happen rarely.");
            return;
        }
        int max = (Integer)target.getLabel(MAX_PATH_LENGTH);
        assert (length + this.t <= max) : "Found a path longer than restricted lengh.";
        if (length + this.t < max) {
            target.putLabel(MAX_PATH_LENGTH, length + this.t);
        }
        CausativePath compPath = new CausativePath();
        for (Node node : path) {
            compPath.addNode(node);
            if (!node.hasLabel(EDGE)) continue;
            compPath.addEdge((Edge)node.getLabel(EDGE));
        }
        compPath.addNode(target);
        assert (compPath.getLength() == length);
        if (!this.result.containsKey(target)) {
            this.result.put(target, new HashMap());
        }
        if (!(pathMap = this.result.get(target)).containsKey(length)) {
            pathMap.put(length, new ArrayList());
        }
        List<CausativePath> paths = pathMap.get(length);
        paths.add(compPath);
    }

    private int getShortestDistance(Node from, Node to) {
        Map distTo = (Map)from.getLabel("DIST_TO");
        int s = Integer.MAX_VALUE;
        if (distTo.containsKey(to)) {
            s = (Integer)distTo.get(to);
        }
        return s;
    }

    private Set<Node> getDestinationSet(Node node, Node target) {
        Map destMap = (Map)node.getLabel("TO_FROM_PATH_MAP");
        if (destMap == null) {
            return null;
        }
        return (Set)destMap.get(target);
    }

    private Set<Node> filterDestinationSources(Node node, Node target, Set<Node> destSet) {
        Set<Node> nodeDest = this.getDestinationSet(node, target);
        HashSet<Node> newSet = new HashSet<Node>();
        if (nodeDest != null) {
            for (Node n : destSet) {
                if (!nodeDest.contains(n)) continue;
                newSet.add(n);
            }
        }
        return newSet;
    }

    private Set<Node> keepDifference(Set<Node> set, Set<Node> diff) {
        if (!diff.isEmpty()) {
            Iterator<Node> iter = diff.iterator();
            while (iter.hasNext()) {
                Node node = iter.next();
                if (!set.contains(node)) continue;
                iter.remove();
            }
        }
        return diff;
    }

    private void pruneResult() {
        for (Node target : this.result.keySet()) {
            Map<Integer, List<CausativePath>> pathMap = this.result.get(target);
            for (int i = (Integer)target.getLabel(MAX_PATH_LENGTH) + 1; i <= this.limit; ++i) {
                pathMap.remove(i);
            }
        }
    }

    private void clearLabels() {
        this.graph.removeLabels(Arrays.asList(EDGE, ON_PATH, MAX_PATH_LENGTH, "DIST_FROM", "DIST_TO", "TO_FROM_PATH_MAP"));
    }

    private class CurrentPath<E>
    extends LinkedList<E> {
        private int size = 0;

        private CurrentPath() {
        }

        public boolean add(E e, boolean increaseSize) {
            if (increaseSize) {
                ++this.size;
            }
            return super.add(e);
        }

        public boolean remove(E e, boolean decreaseSize) {
            if (decreaseSize) {
                --this.size;
            }
            return super.remove(e);
        }

        public void addFirst(E e, boolean increaseSize) {
            if (increaseSize) {
                ++this.size;
            }
            super.addFirst(e);
        }

        public E removeFirst(boolean decreaseSize) {
            if (decreaseSize) {
                --this.size;
            }
            return super.removeFirst();
        }

        public int getSize() {
            return this.size;
        }
    }
}

