/*
 * Decompiled with CFR 0.152.
 */
package org.patika.mada.algorithm;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.patika.mada.graph.Edge;
import org.patika.mada.graph.Graph;
import org.patika.mada.graph.Node;
import org.patika.mada.util.Path;

public class SearchPathsBetween {
    private Graph graph;
    private Collection<Node> interest;
    private int limit;
    private Map<Node, Map<Integer, List<Path>>> result;
    private static final String EDGE = "EDGE";
    private static final String ON_PATH = "ON_PATH";
    private static final int TOWARDS_CHILDREN = 0;
    private static final int TOWARDS_PARENTS = 1;
    private static final int TOWARDS_BOTHWAYS = 2;

    public SearchPathsBetween(Graph graph, Collection<Node> interest, int limit) {
        this.graph = graph;
        this.interest = interest;
        this.limit = limit;
    }

    public Map<Node, Map<Integer, List<Path>>> run() {
        this.result = new HashMap<Node, Map<Integer, List<Path>>>();
        for (Node target : this.interest) {
            this.searchForTarget(target);
        }
        this.clearLabels();
        return this.result;
    }

    private void searchForTarget(Node target) {
        CurrentPath<Node> path = new CurrentPath<Node>();
        this.traverseUpstream(target, target, path);
        this.traverseRelatives(target, target, path, 0);
        this.traverseRelatives(target, target, path, 1);
    }

    private void traverseUpstream(Node node, Node target, CurrentPath<Node> path) {
        assert (path.getSize() <= this.limit) : "Length limit is violated. path size: " + path.getSize() + " limit: " + this.limit;
        if (path.getSize() == this.limit) {
            return;
        }
        for (Edge edge : node.getUpstream()) {
            Node neigh;
            if (!edge.isDirected() || (neigh = edge.getSourceNode()) == target || neigh.hasLabel(ON_PATH)) continue;
            neigh.putLabel(EDGE, edge);
            neigh.putLabel(ON_PATH, true);
            path.addFirst(neigh, neigh.isBreadthNode());
            this.checkAndProceed(neigh, target, path, 2);
            path.removeFirst(neigh.isBreadthNode());
            neigh.removeLabel(ON_PATH);
            neigh.removeLabel(EDGE);
        }
    }

    private void traverseRelatives(Node node, Node target, CurrentPath<Node> path, int direction) {
        for (Node node2 : direction == 0 ? node.getChildren() : node.getParents()) {
            if (node2 == target || node2.hasLabel(ON_PATH)) continue;
            node2.putLabel(ON_PATH, true);
            path.addFirst(node2, false);
            this.checkAndProceed(node2, target, path, direction);
            path.removeFirst(false);
            node2.removeLabel(ON_PATH);
        }
    }

    private void checkAndProceed(Node node, Node target, CurrentPath<Node> path, int relativeDirection) {
        if (this.interest.contains(node)) {
            this.recordPath(target, path);
        } else {
            this.traverseUpstream(node, target, path);
            if (relativeDirection == 0 || relativeDirection == 2) {
                this.traverseRelatives(node, target, path, 0);
            }
            if (relativeDirection == 1 || relativeDirection == 2) {
                this.traverseRelatives(node, target, path, 1);
            }
        }
    }

    private void recordPath(Node target, CurrentPath<Node> currPath) {
        Map<Integer, List<Path>> pathMap;
        int length = currPath.getSize();
        assert (length <= this.limit) : "Found a path longer than limit.";
        Path path = new Path();
        for (Node node : currPath) {
            path.addNode(node);
            if (!node.hasLabel(EDGE)) continue;
            path.addEdge((Edge)node.getLabel(EDGE));
        }
        path.addNode(target);
        if (!this.result.containsKey(target)) {
            this.result.put(target, new HashMap());
        }
        if (!(pathMap = this.result.get(target)).containsKey(length)) {
            pathMap.put(length, new ArrayList());
        }
        List<Path> paths = pathMap.get(length);
        paths.add(path);
    }

    private void clearLabels() {
        this.graph.removeLabels(Arrays.asList(EDGE, ON_PATH));
    }

    private class CurrentPath<E>
    extends LinkedList<E> {
        private int size = 0;

        private CurrentPath() {
        }

        public boolean add(E e, boolean increaseSize) {
            if (increaseSize) {
                ++this.size;
            }
            return super.add(e);
        }

        public boolean remove(E e, boolean decreaseSize) {
            if (decreaseSize) {
                --this.size;
            }
            return super.remove(e);
        }

        public void addFirst(E e, boolean increaseSize) {
            if (increaseSize) {
                ++this.size;
            }
            super.addFirst(e);
        }

        public E removeFirst(boolean decreaseSize) {
            if (decreaseSize) {
                --this.size;
            }
            return super.removeFirst();
        }

        public int getSize() {
            return this.size;
        }
    }
}

