/*
 * Decompiled with CFR 0.152.
 */
package org.patika.mada.gui;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.JOptionPane;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.MarshalException;
import javax.xml.bind.Marshaller;
import org.eclipse.jface.dialogs.MessageDialog;
import org.gvt.util.Conf;
import org.patika.mada.dataXML.ChisioExperimentData;
import org.patika.mada.gui.ExperimentDataConvertionWizard;
import org.patika.mada.gui.ReferenceTable;

public class ExperimentDataAutomaticConvertionWizard
extends ExperimentDataConvertionWizard {
    private File seriesMatrixFile;
    private File platformFile;
    private String selectedSeries;
    private List<String> columnsSeries = new ArrayList<String>();
    private List<String> columnsPlatform = new ArrayList<String>();
    private ReferenceTable mapTable;

    public ExperimentDataAutomaticConvertionWizard(List<String> supportedReferenceTypes, File seriesMatrixFile, File platformFile, String selectedSeries) {
        super(supportedReferenceTypes);
        this.seriesMatrixFile = seriesMatrixFile;
        this.platformFile = platformFile;
        this.selectedSeries = selectedSeries;
        this.dataType = "Expression Data";
    }

    public void run() {
        this.readPlatformFile();
        this.readSeriesFile();
        this.finish();
    }

    private void readPlatformFile() {
        String line = "";
        this.columnsPlatform.clear();
        try {
            FileReader fr = new FileReader(this.platformFile);
            BufferedReader br = new BufferedReader(fr);
            while ((line = br.readLine()) != null && ExperimentDataAutomaticConvertionWizard.startsWithSpecialChar(line)) {
            }
            if (line != null) {
                StringTokenizer tokenizer = new StringTokenizer(line, "\t");
                while (tokenizer.hasMoreTokens()) {
                    this.columnsPlatform.add(tokenizer.nextToken());
                }
            }
            this.mapTable = new ReferenceTable(this.columnsPlatform, this.getPredictedMatches(this.columnsPlatform));
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
    }

    public void readSeriesFile() {
        String line = "";
        String experimentSetInfo = "";
        this.columnsSeries.clear();
        try {
            FileReader fr = new FileReader(this.seriesMatrixFile);
            BufferedReader br = new BufferedReader(fr);
            do {
                line = br.readLine();
                experimentSetInfo = experimentSetInfo + line + "\n";
            } while (line != null && ExperimentDataAutomaticConvertionWizard.startsWithSpecialChar(line));
            this.setExperimentSetInfo(experimentSetInfo);
            if (line != null) {
                StringTokenizer tokenizer = new StringTokenizer(line, "\t");
                while (tokenizer.hasMoreTokens()) {
                    this.columnsSeries.add(tokenizer.nextToken());
                }
                this.setSampleInfo(this.extractSampleInfos(experimentSetInfo, this.columnsSeries.size() - 1));
            }
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
    }

    @Override
    public void finish() {
        try {
            this.rmd = this.objFac.createRootExperimentData();
            this.fillInReferences(this.platformFile, this.mapTable.getMappedReferences(), this.columnsPlatform.size());
            this.fillInDataValues();
            this.clearUselessRows();
            if (this.rmd.getRow().isEmpty()) {
                MessageDialog.openWarning(null, "No data!", "There is no external reference matching between graph and data.\nPlease make sure your BioPAX model contains proper external references that matches the references in expression data annotation.");
                return;
            }
            this.writeExperimentData(this.rmd);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "There occured an error during file parsing, \n please check your files and parameters!  ", "Parsing Error", 0);
            e.printStackTrace();
        }
    }

    @Override
    public void fillInDataValues() {
        try {
            this.rmd.setExperimentType(this.getDataType());
            this.rmd.setExperimentSetInfo(this.experimentSetInfo);
            this.createExperimentsFromSingleDataFile(this.seriesMatrixFile, this.columnsPlatform.indexOf(this.mapTable.getNameOfKeyColumn()), this.getIndexOfExperimentStartColumn(this.columnsSeries), this.columnsSeries.size() - 1);
        }
        catch (Exception e) {
            System.out.println("Error during patika micro file creation");
        }
    }

    public String[] extractSampleInfos(String datasetInfo, int sampleSize) {
        String[] sampleInfo = new String[sampleSize];
        for (int i = 0; i < sampleSize; ++i) {
            sampleInfo[i] = "";
        }
        String[] line = datasetInfo.split("\n");
        for (int i = 0; i < line.length; ++i) {
            String[] token = line[i].split("\t");
            if (token.length != sampleSize + 1 || this.allTheSame(token)) continue;
            for (int j = 0; j < sampleSize; ++j) {
                int n = j;
                sampleInfo[n] = sampleInfo[n] + "\n" + token[j + 1];
            }
        }
        return sampleInfo;
    }

    protected boolean allTheSame(String[] info) {
        for (int i = 2; i < info.length; ++i) {
            if (info[1].equals(info[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public void writeExperimentData(ChisioExperimentData pmd) {
        try {
            File fileToWrite = new File(Conf.getExperimentsDir() + this.selectedSeries, this.selectedSeries + ".ced");
            JAXBContext jc = JAXBContext.newInstance("org.patika.mada.dataXML");
            Marshaller m = jc.createMarshaller();
            this.resultFileName = fileToWrite.getPath();
            BufferedWriter writer = new BufferedWriter(new FileWriter(fileToWrite));
            m.setProperty("jaxb.formatted.output", Boolean.TRUE);
            m.marshal((Object)pmd, writer);
            writer.close();
        }
        catch (MarshalException ue) {
            ue.printStackTrace();
        }
        catch (JAXBException je) {
            je.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    private int getIndexOfExperimentStartColumn(List<String> columns) {
        int index = 0;
        for (int i = 0; i < columns.size(); ++i) {
            if (!columns.get(i).startsWith("\"GSM")) continue;
            index = i;
            break;
        }
        return index;
    }
}

