/*
 * Decompiled with CFR 0.152.
 */
package org.patika.mada.gui;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.filechooser.FileFilter;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.MarshalException;
import javax.xml.bind.Marshaller;
import org.gvt.util.Conf;
import org.patika.mada.dataXML.ChisioExperimentData;
import org.patika.mada.dataXML.Experiment;
import org.patika.mada.dataXML.ObjectFactory;
import org.patika.mada.dataXML.Reference;
import org.patika.mada.dataXML.Row;
import org.patika.mada.dataXML.ValueTuple;
import org.patika.mada.gui.ExperimentInfoCollectionPage;
import org.patika.mada.gui.KeyValueSpecificationPage;
import org.patika.mada.gui.MultipleDataFileLoadPage;
import org.patika.mada.gui.NonePlatformMappingPage;
import org.patika.mada.gui.PatikaWizard;
import org.patika.mada.gui.PatikaWizardPage;
import org.patika.mada.gui.PlatformMappingPage;
import org.patika.mada.gui.ReferenceTable;
import org.patika.mada.gui.SingleDataFileLoadPage;

public class ExperimentDataConvertionWizard
extends PatikaWizard
implements TableModelListener {
    private boolean isDataInSingleFile;
    private boolean hasPlatformFile;
    protected String dataType;
    protected ChisioExperimentData rmd;
    ObjectFactory objFac;
    String experimentSetInfo;
    String[] sampleInfo;
    List<String> supportedReferenceTypes;
    static Map<List<String>, String> knownReferenceSetsMap;
    public static File recentDir;
    public static int LINE_COUNTER;
    protected String resultFileName;
    private Map<String, Row> index2Row;
    protected Map<String, String> match;
    public static String KEY_COLUMN;
    public static int TYPE_ID;
    public static final List<String> COMMON_GB_ACCESSION_COLUMN_NAMES;
    public static final List<String> COMMON_GENE_SYMBOL_COLUMN_NAMES;
    public static final List<String> COMMON_GENE_ID_COLUMN_NAMES;
    public static final List<String> COMMON_UNIGENE_COLUMN_NAMES;
    public static final List<String> COMMON_OMIM_COLUMN_NAMES;
    public static final List<String> COMMON_REF_SEQ_PROT_ID_COLUMN_NAMES;
    public static final List<String> COMMON_REF_SEQ_TRANSCRIPT_ID_COLUMN_NAMES;
    public static final List<String> COMMON_ENSEMBLE_COLUMN_NAMES;
    public static final List<String> COMMON_SWISSPROT_COLUMN_NAMES;
    public static final List<String> COMMON_CPATH_COLUMN_NAMES;
    public static final List<String> COMMON_KEY_COLUMN_NAMES;

    public ExperimentDataConvertionWizard(List<String> supportedReferenceTypes) {
        this.supportedReferenceTypes = supportedReferenceTypes;
        this.objFac = new ObjectFactory();
    }

    public ExperimentDataConvertionWizard(List<String> supportedReferenceTypes, Point p) {
        super("Experiment Data Converter Wizard", null);
        this.supportedReferenceTypes = supportedReferenceTypes;
        this.setLocation(p);
        this.setResizable(false);
        this.objFac = new ObjectFactory();
    }

    @Override
    protected void initPages(Object o) {
        this.pageCount = 2;
        this.pages = new PatikaWizardPage[this.pageCount];
        this.pages[0] = new ExperimentInfoCollectionPage(this);
        this.pages[1] = new SingleDataFileLoadPage(this);
        this.currentPage = 0;
        this.switchPage(0, false);
    }

    protected void goToStart() {
        this.switchPage(0, false);
        this.setEnabled(true);
    }

    @Override
    protected void initializeGUI() {
        this.setSize(500, 330);
        this.setLayout(this.mainLayout);
        this.controllerPanel.setAlignmentY(0.5f);
        this.controllerPanel.setBorder(BorderFactory.createEtchedBorder());
        this.backButton.setText("< Back");
        this.nextButton.setText("Next >");
        this.cancelButton.setText("Close");
        this.finishButton.setText("Finish");
        this.controllerPanel.add((Component)this.cancelButton, "South");
        this.controllerPanel.add((Component)this.backButton, null);
        this.controllerPanel.add((Component)this.nextButton, null);
        this.controllerPanel.add((Component)this.finishButton, null);
        this.add((Component)this.controllerPanel, "South");
    }

    protected void setPages() {
        if (this.hasPlatformFile()) {
            if (this.isDataInSingleFile()) {
                this.pageCount = 4;
                PatikaWizardPage[] temp = new PatikaWizardPage[this.pageCount];
                temp[0] = this.pages[0];
                this.pages = temp;
                this.pages[1] = new PlatformMappingPage(this);
                this.pages[2] = new SingleDataFileLoadPage(this);
                this.pages[3] = new KeyValueSpecificationPage(this);
            } else {
                this.pageCount = 4;
                PatikaWizardPage[] temp = new PatikaWizardPage[this.pageCount];
                temp[0] = this.pages[0];
                this.pages = temp;
                this.pages[1] = new PlatformMappingPage(this);
                this.pages[2] = new MultipleDataFileLoadPage(this);
                this.pages[3] = new KeyValueSpecificationPage(this);
            }
        } else if (this.isDataInSingleFile()) {
            this.pageCount = 3;
            PatikaWizardPage[] temp = new PatikaWizardPage[this.pageCount];
            temp[0] = this.pages[0];
            this.pages = temp;
            this.pages[1] = new SingleDataFileLoadPage(this);
            this.pages[2] = new NonePlatformMappingPage(this);
        } else {
            this.pageCount = 3;
            PatikaWizardPage[] temp = new PatikaWizardPage[this.pageCount];
            temp[0] = this.pages[0];
            this.pages = temp;
            this.pages[1] = new MultipleDataFileLoadPage(this);
            this.pages[2] = new NonePlatformMappingPage(this);
        }
        this.repaint();
    }

    public boolean isDataInSingleFile() {
        return this.isDataInSingleFile;
    }

    public void setDataInSingleFile(boolean dataInSingleFile) {
        this.isDataInSingleFile = dataInSingleFile;
    }

    public boolean hasPlatformFile() {
        return this.hasPlatformFile;
    }

    public void setHasPlatformFile(boolean hasPlatformFile) {
        this.hasPlatformFile = hasPlatformFile;
    }

    public String getDataType() {
        return this.dataType;
    }

    public void setDataType(String dataType) {
        this.dataType = dataType;
    }

    public String getExperimentSetInfo() {
        return this.experimentSetInfo;
    }

    public void setExperimentSetInfo(String experimentSetInfo) {
        this.experimentSetInfo = experimentSetInfo;
    }

    public String[] getSampleInfo() {
        return this.sampleInfo;
    }

    public void setSampleInfo(String[] sampleInfo) {
        this.sampleInfo = sampleInfo;
    }

    public List<String> getSupportedReferencesTypes() {
        return this.supportedReferenceTypes;
    }

    public String getResultFileName() {
        return this.resultFileName;
    }

    @Override
    protected void nextButton_actionPerformed(ActionEvent event) {
        if (this.currentPage == 0) {
            this.pages[0].update();
            this.setPages();
        }
        this.switchPage(this.currentPage + 1, false);
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        if (e.getSource() instanceof ReferenceTable.ReferenceTableModel) {
            if (this.hasPlatformFile()) {
                ReferenceTable rt = ((PlatformMappingPage)this.pages[1]).getMapTable();
                if (rt.canNext(true)) {
                    this.nextButton.setEnabled(true);
                } else {
                    this.nextButton.setEnabled(false);
                }
            } else if (this.pages[2].canFinish()) {
                this.finishButton.setEnabled(true);
            } else {
                this.finishButton.setEnabled(false);
            }
        }
    }

    @Override
    public void finish() {
        this.setEnabled(false);
        try {
            this.rmd = this.objFac.createRootExperimentData();
            if (this.hasPlatformFile()) {
                PlatformMappingPage pmp = (PlatformMappingPage)this.pages[1];
                this.fillInReferences(pmp.getPlatformFile(), pmp.getMappedReferences(), pmp.getColumns().size());
            } else {
                NonePlatformMappingPage npmp = (NonePlatformMappingPage)this.pages[2];
                this.fillInReferences(npmp.getFileToParse(), npmp.getMappedReferences(), npmp.getColumns().size());
            }
            this.fillInDataValues();
            this.clearUselessRows();
            this.writeExperimentData(this.rmd);
            this.dispose();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "There occured an error during file parsing, \n please check your files and parameters!  ", "Parsing Error", 0);
            e.printStackTrace();
            this.goToStart();
        }
    }

    public void fillInDataValues() {
        try {
            this.rmd.setExperimentType(this.getDataType());
            this.rmd.setExperimentSetInfo(this.experimentSetInfo);
            if (this.hasPlatformFile()) {
                KeyValueSpecificationPage kvsp = (KeyValueSpecificationPage)this.pages[3];
                if (this.isDataInSingleFile()) {
                    SingleDataFileLoadPage sdflp = (SingleDataFileLoadPage)this.pages[2];
                    this.createExperimentsFromSingleDataFile(sdflp.getLoadedFile(), kvsp.getIndexOfKeyInDataFile(), kvsp.getIndexOfExperimentStartColumn(), kvsp.getIndexOfExperimentEndColumn());
                } else {
                    MultipleDataFileLoadPage mdflp = (MultipleDataFileLoadPage)this.pages[2];
                    this.createExperimentsFromMultipleFiles(mdflp.getLoadedFiles(), kvsp.getIndexOfKeyInDataFile(), kvsp.getIndexOfExperimentValueColumn());
                }
            } else {
                NonePlatformMappingPage npmp = (NonePlatformMappingPage)this.pages[2];
                if (this.isDataInSingleFile()) {
                    SingleDataFileLoadPage sdflp = (SingleDataFileLoadPage)this.pages[1];
                    this.createExperimentsFromSingleDataFile(sdflp.getLoadedFile(), npmp.getIndexOfKey(), npmp.getIndexOfExperimentValueStartColumn(), npmp.getIndexOfExperimentEndColumn());
                } else {
                    MultipleDataFileLoadPage mdflp = (MultipleDataFileLoadPage)this.pages[1];
                    this.createExperimentsFromMultipleFiles(mdflp.getLoadedFiles(), npmp.getIndexOfKey(), npmp.getIndexOfExperimentValueStartColumn());
                }
            }
        }
        catch (Exception e) {
            System.out.println("Error during patika micro file creation");
            this.goToStart();
        }
        this.completed = true;
    }

    public void createExperimentsFromSingleDataFile(File dataFile, int indexOfKeyColumn, int indexOfExperimentStartColumn, int indexOfExperimentEndColumn) {
        try {
            int experimetnCount = indexOfExperimentEndColumn - indexOfExperimentStartColumn + 1;
            for (int i = 0; i < experimetnCount; ++i) {
                this.rmd.getExperiment().add(this.objFac.createExperiment());
            }
            BufferedReader br = new BufferedReader(new FileReader(dataFile));
            String line = "";
            while ((line = br.readLine()) != null && ExperimentDataConvertionWizard.startsWithSpecialChar(line)) {
            }
            if (line != null) {
                String[] tokens = this.getTokenArray(line);
                for (int i = 0; i < experimetnCount; ++i) {
                    Experiment exp = (Experiment)this.rmd.getExperiment().get(i);
                    exp.setExperimentName(tokens[i + indexOfExperimentStartColumn]);
                    if (this.sampleInfo == null || this.sampleInfo[i] == null || this.sampleInfo[i].isEmpty()) {
                        exp.setExperimentInfo("No experiment info available. Please check dataset info.");
                    } else {
                        exp.setExperimentInfo(this.sampleInfo[i]);
                    }
                    exp.setNo(i);
                }
                while ((line = br.readLine()) != null && ExperimentDataConvertionWizard.startsWithSpecialChar(line)) {
                }
                if (line != null) {
                    do {
                        if (ExperimentDataConvertionWizard.startsWithSpecialChar(line)) continue;
                        tokens = this.getTokenArray(line);
                        try {
                            String keyValue = tokens[indexOfKeyColumn];
                            if (keyValue.startsWith("\"")) {
                                keyValue = keyValue.substring(1, keyValue.length() - 1);
                            }
                            if (keyValue == null || !this.index2Row.containsKey(keyValue)) continue;
                            Row row = this.index2Row.get(keyValue);
                            assert (row != null);
                            for (int i = 0; i < experimetnCount; ++i) {
                                String experimentValue = tokens[i + indexOfExperimentStartColumn];
                                if (experimentValue == null || experimentValue.equals("null")) continue;
                                try {
                                    double expValue = Double.parseDouble(experimentValue);
                                    ValueTuple tuple = this.objFac.createValueTuple();
                                    tuple.setNo(i);
                                    tuple.setValue(expValue);
                                    row.getValue().add(tuple);
                                    continue;
                                }
                                catch (NumberFormatException e) {
                                    // empty catch block
                                }
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    } while ((line = br.readLine()) != null);
                }
            }
            br.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void createExperimentsFromMultipleFiles(ArrayList dataFiles, int indexOfKeyColumn, int indexOfValueColum) {
        int fileno = 0;
        for (Object dataFile : dataFiles) {
            block17: {
                int not_mapped_key_in_data = 0;
                int non_numerical_vallue = 0;
                int null_key = 0;
                int null_experiment_value = 0;
                int added = 0;
                int lineCounter = 0;
                try {
                    File currentFile = (File)dataFile;
                    BufferedReader br = new BufferedReader(new FileReader(currentFile));
                    Experiment exp = this.objFac.createExperiment();
                    this.rmd.getExperiment().add(exp);
                    exp.setExperimentName(currentFile.getName());
                    exp.setNo(fileno);
                    String line = "";
                    String expInfo = "";
                    do {
                        expInfo = expInfo + line + "\n";
                        line = br.readLine();
                        ++lineCounter;
                    } while (line != null && ExperimentDataConvertionWizard.startsWithSpecialChar(line));
                    exp.setExperimentInfo(expInfo);
                    if (line == null) break block17;
                    do {
                        ++lineCounter;
                    } while ((line = br.readLine()) != null && ExperimentDataConvertionWizard.startsWithSpecialChar(line));
                    if (line != null) {
                        do {
                            if (!ExperimentDataConvertionWizard.startsWithSpecialChar(line)) {
                                try {
                                    String[] tokens = this.getTokenArray(line);
                                    String keyValue = tokens[indexOfKeyColumn];
                                    String experimentValue = tokens[indexOfValueColum];
                                    if (experimentValue != null && keyValue != null && this.index2Row.containsKey(keyValue)) {
                                        ValueTuple tuple = this.objFac.createValueTuple();
                                        double expValue = Double.parseDouble(experimentValue);
                                        tuple.setNo(fileno);
                                        tuple.setValue(expValue);
                                        Row row = this.index2Row.get(keyValue);
                                        row.getValue().add(tuple);
                                        ++added;
                                    } else if (experimentValue == null) {
                                        ++null_experiment_value;
                                    } else if (keyValue == null) {
                                        ++null_key;
                                    } else {
                                        ++not_mapped_key_in_data;
                                    }
                                }
                                catch (ArrayIndexOutOfBoundsException tokens) {
                                }
                                catch (NumberFormatException e) {
                                    ++non_numerical_vallue;
                                }
                            }
                            line = br.readLine();
                            ++lineCounter;
                        } while (line != null);
                    }
                    br.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            ++fileno;
        }
    }

    public void fillInReferences(File file, HashMap<String, String> referenceMap, int numberOfColumns) {
        String line = "";
        int index = 0;
        LINE_COUNTER = 0;
        this.index2Row = new HashMap<String, Row>();
        Object[][] referenceIndexes = new Object[referenceMap.size()][3];
        try {
            BufferedReader br = new BufferedReader(new FileReader(file));
            do {
                line = br.readLine();
                ++LINE_COUNTER;
            } while (line != null && ExperimentDataConvertionWizard.startsWithSpecialChar(line));
            if (line != null) {
                for (String patikaReference : referenceMap.keySet()) {
                    referenceIndexes[index][0] = patikaReference;
                    referenceIndexes[index][1] = referenceMap.get(patikaReference);
                    referenceIndexes[index][2] = this.getColumnIndex(line, (String)referenceIndexes[index][1]);
                    ++index;
                }
                do {
                    line = br.readLine();
                    ++LINE_COUNTER;
                } while (line != null && ExperimentDataConvertionWizard.startsWithSpecialChar(line));
                if (line != null) {
                    do {
                        Row row;
                        if (!ExperimentDataConvertionWizard.startsWithSpecialChar(line) && (row = this.getRow(referenceIndexes, line, numberOfColumns)) != null) {
                            this.rmd.getRow().add(row);
                        }
                        line = br.readLine();
                        ++LINE_COUNTER;
                    } while (line != null);
                }
            }
            br.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private Row getRow(Object[][] referenceIndexes, String dataLine, int numberOfExpectedColumns) {
        Row row = null;
        String[] tokens = this.getTokenArray(dataLine);
        if (numberOfExpectedColumns != tokens.length) {
            return row;
        }
        try {
            row = this.objFac.createRow();
            for (Object[] referenceIndex : referenceIndexes) {
                String referenceValue = tokens[(Integer)referenceIndex[2]];
                if (referenceValue == null) continue;
                StringTokenizer tokenizer = new StringTokenizer(referenceValue, "/");
                while (tokenizer.hasMoreTokens()) {
                    String token = tokenizer.nextToken().trim();
                    if (token.length() <= 0) continue;
                    if (referenceIndex[0].equals(KEY_COLUMN)) {
                        this.index2Row.put(token, row);
                        continue;
                    }
                    Reference ref = this.objFac.createReference();
                    ref.setDb((String)referenceIndex[0]);
                    ref.setValue(token);
                    row.getRef().add(ref);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return row;
    }

    protected void clearUselessRows() {
        for (Row row : new ArrayList(this.rmd.getRow())) {
            if (!row.getRef().isEmpty() && !row.getValue().isEmpty()) continue;
            this.rmd.getRow().remove(row);
        }
    }

    public void writeExperimentData(ChisioExperimentData pmd) {
        try {
            JFileChooser chooser = new JFileChooser();
            boolean isOverWrite = false;
            boolean willWrite = true;
            chooser.setFileFilter(new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return pathname.isDirectory() || pathname.getAbsolutePath().endsWith(".ced");
                }

                @Override
                public String getDescription() {
                    return "CBE Experiment Data (*.ced)";
                }
            });
            chooser.setCurrentDirectory(new File(Conf.getExperimentsDir()));
            int returnValue = chooser.showSaveDialog(this);
            if (returnValue == 0) {
                File fileToWrite = chooser.getSelectedFile();
                if (Conf.isWritable(fileToWrite.getParent())) {
                    if (fileToWrite.exists()) {
                        int returnValue2 = JOptionPane.showConfirmDialog(this, "Confirm overwrite?");
                        if (returnValue2 == 1 || returnValue2 == 2) {
                            willWrite = false;
                        } else {
                            isOverWrite = true;
                        }
                    }
                    if (willWrite) {
                        JAXBContext jc = JAXBContext.newInstance("org.patika.mada.dataXML");
                        Marshaller m = jc.createMarshaller();
                        if (!isOverWrite) {
                            fileToWrite = fileToWrite.getAbsolutePath().toLowerCase().endsWith(".ced") ? new File(fileToWrite.getAbsolutePath()) : new File(fileToWrite.getAbsolutePath() + ".ced");
                        }
                        this.resultFileName = fileToWrite.getPath();
                        BufferedWriter writer = new BufferedWriter(new FileWriter(fileToWrite));
                        m.setProperty("jaxb.formatted.output", Boolean.TRUE);
                        m.marshal((Object)pmd, writer);
                        writer.close();
                    }
                } else {
                    JOptionPane.showMessageDialog(null, "You do not have permission to save in this location. \nPlease save in another folder.", "No Permission", 0);
                }
            }
        }
        catch (MarshalException ue) {
            ue.printStackTrace();
        }
        catch (JAXBException je) {
            je.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public static boolean startsWithSpecialChar(String str) {
        boolean result = false;
        if (str != null && str.length() > 0) {
            char first = str.charAt(0);
            if (!(first >= '0' && first <= '9' || first >= 'A' && first <= 'Z' || first >= 'a' && first <= 'z' || first == '\t' || first == '\"')) {
                result = true;
            }
        } else if (str.equals("")) {
            result = true;
        }
        return result;
    }

    public int getColumnIndex(String line, String columnName) {
        String[] tokens;
        int index = 0;
        for (String token : tokens = this.getTokenArray(line)) {
            if (token.equals(columnName)) break;
            ++index;
        }
        return index;
    }

    private String[] getTokenArray(String line) {
        ArrayList<String> tokens = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(line, "\t", true);
        boolean justSawTab = false;
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (token.equals("\t")) {
                if (justSawTab) {
                    tokens.add(null);
                    continue;
                }
                justSawTab = true;
                continue;
            }
            justSawTab = false;
            tokens.add(token);
        }
        return tokens.toArray(new String[tokens.size()]);
    }

    protected Map<String, String> getPredictedMatches(List<String> dataCols) {
        this.match = new HashMap<String, String>();
        Map<List<String>, String> referenceList = ExperimentDataConvertionWizard.getKnownReferenceSetsMap();
        HashMap<String, List<String>> knownRefsSetsMap = new HashMap<String, List<String>>();
        for (List<String> key : referenceList.keySet()) {
            this.putInRefListMap(knownRefsSetsMap, key);
        }
        for (String col : dataCols) {
            List list = (List)knownRefsSetsMap.get(col);
            if (list == null || !referenceList.containsKey(list)) continue;
            this.match.put(col, referenceList.get(list));
        }
        return this.match;
    }

    public static Map<List<String>, String> getKnownReferenceSetsMap() {
        if (knownReferenceSetsMap != null) {
            return knownReferenceSetsMap;
        }
        knownReferenceSetsMap = new HashMap<List<String>, String>();
        HashMap userRefList = new HashMap();
        try {
            InputStream resourceAsStream = ExperimentDataConvertionWizard.class.getClassLoader().getResourceAsStream("org/gvt/util/references.txt");
            InputStreamReader fileReader = new InputStreamReader(resourceAsStream);
            BufferedReader reader = new BufferedReader(fileReader);
            String line = reader.readLine();
            while (!(line = reader.readLine()).equals("")) {
                StringTokenizer tokenizer = new StringTokenizer(line, "\t");
                String refName = tokenizer.nextToken();
                ArrayList<String> refValues = new ArrayList<String>();
                while (tokenizer.hasMoreTokens()) {
                    String string = tokenizer.nextToken();
                    refValues.add(string);
                }
                knownReferenceSetsMap.put(refValues, refName);
            }
            String userLine = reader.readLine();
            while ((userLine = reader.readLine()) != null && !userLine.equals("")) {
                StringTokenizer tokenizer = new StringTokenizer(userLine, "\t");
                String userRefName = tokenizer.nextToken();
                ArrayList<String> arrayList = new ArrayList<String>();
                while (tokenizer.hasMoreTokens()) {
                    String token = tokenizer.nextToken();
                    arrayList.add(token);
                }
                userRefList.put(arrayList, userRefName);
            }
            reader.close();
            ArrayList<List<String>> removeList = new ArrayList<List<String>>();
            if (!userRefList.isEmpty()) {
                for (Map.Entry entry : userRefList.entrySet()) {
                    for (Map.Entry<List<String>, String> entry2 : knownReferenceSetsMap.entrySet()) {
                        if (!entry2.getValue().equals(entry.getValue())) continue;
                        removeList.add(entry2.getKey());
                    }
                }
            }
            for (List list : removeList) {
                knownReferenceSetsMap.remove(list);
            }
            knownReferenceSetsMap.putAll(userRefList);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return knownReferenceSetsMap;
    }

    private void putInRefListMap(Map<String, List<String>> map, List<String> list) {
        for (String name : list) {
            map.put(name, list);
        }
    }

    static {
        recentDir = new File(Conf.getExperimentsDir());
        LINE_COUNTER = 0;
        KEY_COLUMN = "Key Column";
        TYPE_ID = 1;
        COMMON_GB_ACCESSION_COLUMN_NAMES = Arrays.asList("GenBank Accession", "GB_ACC", "GenBank", "GB_LIST");
        COMMON_GENE_SYMBOL_COLUMN_NAMES = Arrays.asList("Gene Symbol", "Gene symbol", "GENE_SYMBOL", "HGNC SYMBOL", "Symbol", "SYMBOL", "symbol", "GeneSymbol");
        COMMON_GENE_ID_COLUMN_NAMES = Arrays.asList("Locuslink", "Entrez Gene", "Locuslink ID", "Locuslink_ID", "EntrezGeneID", "ENTREZ_GENE_ID");
        COMMON_UNIGENE_COLUMN_NAMES = Arrays.asList("UNIGENE", "Unigene", "Unigene_ID", "Database DB:unigene");
        COMMON_OMIM_COLUMN_NAMES = Arrays.asList("OMIM", "MIM");
        COMMON_REF_SEQ_PROT_ID_COLUMN_NAMES = Arrays.asList("Refseq prot", "REF_SEQ");
        COMMON_REF_SEQ_TRANSCRIPT_ID_COLUMN_NAMES = Arrays.asList("Refseq trans", "RefSeq Transcript ID");
        COMMON_ENSEMBLE_COLUMN_NAMES = Arrays.asList("Ensembl Gene ID", "Ensemble", "Database DB:ensembl");
        COMMON_SWISSPROT_COLUMN_NAMES = Arrays.asList("Swissprot", "SP_LIST", "UniProt", "UNIPROT");
        COMMON_CPATH_COLUMN_NAMES = Arrays.asList("CPATH");
        COMMON_KEY_COLUMN_NAMES = Arrays.asList("ID", "Key", "Key to data file(s)");
    }
}

