/*
 * Decompiled with CFR 0.152.
 */
package org.patika.mada.gui;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.gvt.ChisioMain;
import org.gvt.action.ColorWithExperimentAction;
import org.gvt.model.BioPAXGraph;
import org.patika.mada.gui.ExperimentDataVisualizationDialog;
import org.patika.mada.util.ExperimentDataManager;

public class ExperimentDataManagementDialog
extends Dialog
implements SelectionListener {
    protected Shell shell;
    ChisioMain main;
    ExperimentDataManager dataManager;
    Boolean[] checks1;
    Boolean[] checks2;
    Table table;
    TableViewer viewer;
    Group experimentGroup;
    Text datasetInfoArea;
    Text infoArea;
    Button singleButton;
    Button compareButton;
    Button valuesButton;
    Button saveButton;
    Button updateButton;
    List<Integer> selection1;
    List<Integer> selection2;
    RowItem[] items;
    boolean mode;
    public static final boolean SINGLE = false;
    public static final boolean COMPARE = true;
    private static final String NO_SELECTED_EXP_DATA_MSSG = "Select experiment to view info.";

    public ExperimentDataManagementDialog(ChisioMain main, ExperimentDataManager dataManager) {
        super(main.getShell(), 0);
        this.dataManager = dataManager;
        this.main = main;
        this.createContents();
    }

    public void open() {
        this.createContents();
        this.shell.pack();
        this.shell.layout();
        this.shell.open();
        Display display = this.getParent().getDisplay();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }

    protected void createContents() {
        this.shell = new Shell(this.getParent(), 67696);
        this.shell.setText(this.dataManager.getType());
        ImageDescriptor id = ImageDescriptor.createFromFile(ChisioMain.class, "icon/cbe-icon.png");
        this.shell.setImage(id.createImage());
        this.shell.setLayout(new GridLayout(2, false));
        Group datasetInfoPanel = new Group(this.shell, 0);
        datasetInfoPanel.setText("Experiment Dataset Info");
        datasetInfoPanel.setLayout(new FillLayout());
        GridData data = new GridData();
        data.horizontalSpan = 2;
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.widthHint = 400;
        data.heightHint = 100;
        datasetInfoPanel.setLayoutData(data);
        this.datasetInfoArea = new Text(datasetInfoPanel, 770);
        if (this.dataManager.isDatasetInfoAvailable()) {
            this.datasetInfoArea.setText(this.dataManager.getDatasetInfo());
        } else {
            this.datasetInfoArea.setText("Dataset info not available.");
            this.datasetInfoArea.setEnabled(false);
        }
        this.datasetInfoArea.setEditable(false);
        this.experimentGroup = new Group(this.shell, 0);
        this.experimentGroup.setLayout(new FillLayout());
        this.experimentGroup.setText("Loaded Experiments");
        data = new GridData(1808);
        data.heightHint = 500;
        this.experimentGroup.setLayoutData(data);
        Group infoPanel = new Group(this.shell, 0);
        infoPanel.setText("Experiment Info");
        infoPanel.setLayout(new FillLayout());
        data = new GridData(1808);
        data.grabExcessVerticalSpace = true;
        data.widthHint = 100;
        data.heightHint = 100;
        infoPanel.setLayoutData(data);
        this.infoArea = new Text(infoPanel, 770);
        if (this.dataManager.isExpInfoAvailable()) {
            this.infoArea.setText(NO_SELECTED_EXP_DATA_MSSG);
        } else {
            this.infoArea.setText("Experiment Info not available");
        }
        this.infoArea.setEditable(false);
        Composite valueTypePanel = new Composite(this.shell, 0);
        valueTypePanel.setLayoutData(new GridData(768));
        valueTypePanel.setLayout(new FillLayout(512));
        this.singleButton = new Button(valueTypePanel, 16);
        this.singleButton.setText("Visualize one");
        this.compareButton = new Button(valueTypePanel, 16);
        this.compareButton.setText("Compare two");
        this.singleButton.addSelectionListener(this);
        this.compareButton.addSelectionListener(this);
        this.compareButton.setEnabled(this.dataManager.getExperimentSize() > 1);
        Composite buttonsGroup = new Composite(this.shell, 0);
        RowLayout rowLayout = new RowLayout();
        rowLayout.justify = true;
        buttonsGroup.setLayout(rowLayout);
        this.valuesButton = new Button(buttonsGroup, 8);
        this.valuesButton.setText("Values...");
        this.saveButton = new Button(buttonsGroup, 8);
        this.saveButton.setText("Save");
        this.saveButton.setToolTipText("Save Grouping");
        this.updateButton = new Button(buttonsGroup, 8);
        this.updateButton.setText("Update");
        this.updateButton.addSelectionListener(this);
        this.valuesButton.addSelectionListener(this);
        this.saveButton.addSelectionListener(this);
        this.saveButton.setEnabled(false);
        this.mode = !this.dataManager.getSecondExpIndices().isEmpty();
        this.checks1 = new Boolean[this.dataManager.getExperimentSize()];
        this.checks2 = new Boolean[this.dataManager.getExperimentSize()];
        for (int i = 0; i < this.checks1.length; ++i) {
            this.checks1[i] = false;
            this.checks2[i] = false;
        }
        this.selection1 = new ArrayList<Integer>();
        this.selection2 = new ArrayList<Integer>();
        if (!this.dataManager.getFirstExpIndices().isEmpty()) {
            for (int i : this.dataManager.getFirstExpIndices()) {
                this.checks1[i] = true;
                this.selection1.add(i);
            }
            this.singleButton.setSelection(true);
        }
        if (!this.dataManager.getSecondExpIndices().isEmpty()) {
            this.singleButton.setSelection(false);
            this.compareButton.setSelection(true);
            for (int i : this.dataManager.getSecondExpIndices()) {
                this.checks2[i] = true;
                this.selection2.add(i);
            }
        }
        this.createTable(this.experimentGroup);
        if (this.dataManager.getExperimentSize() == 0) {
            this.valuesButton.setEnabled(false);
        }
    }

    @Override
    public void widgetDefaultSelected(SelectionEvent event) {
        this.widgetSelected(event);
    }

    @Override
    public void widgetSelected(SelectionEvent e) {
        Object source = e.getSource();
        if (source == this.updateButton) {
            if (this.updateGrouping()) {
                List<BioPAXGraph> graphs = this.main.getAllPathwayGraphs();
                for (BioPAXGraph graph : graphs) {
                    this.dataManager.clearExperimentData(graph);
                    this.dataManager.associateExperimentData(graph);
                    if (graph.getLastAppliedColoring() == null) continue;
                    graph.setLastAppliedColoring(null);
                    new ColorWithExperimentAction(this.main, graph, this.dataManager.getType()).run();
                }
                BioPAXGraph currentGraph = this.main.getPathwayGraph();
                if (currentGraph != null && currentGraph.getLastAppliedColoring() == null) {
                    new ColorWithExperimentAction(this.main, currentGraph, this.dataManager.getType()).run();
                }
                this.shell.dispose();
            }
        } else if (source == this.valuesButton) {
            ExperimentDataVisualizationDialog valuesDialog = new ExperimentDataVisualizationDialog(this.main, this.dataManager);
            valuesDialog.open();
        } else if (source == this.saveButton) {
            if (this.updateGrouping()) {
                this.dataManager.saveData();
                this.saveButton.setEnabled(false);
            }
        } else if (source == this.singleButton) {
            if (this.singleButton.getSelection()) {
                this.mode = false;
                this.saveButton.setEnabled(true);
                this.recreateTable();
            }
        } else if (source == this.compareButton) {
            if (this.compareButton.getSelection()) {
                this.mode = true;
                this.saveButton.setEnabled(true);
                this.recreateTable();
            }
        } else if (source == this.table) {
            TableItem[] selectedItems = this.table.getSelection();
            if (selectedItems.length > 0) {
                int expNo = ((RowItem)selectedItems[0].getData()).expNum;
                this.infoArea.setText(this.dataManager.getExperimentInfo(expNo));
            } else {
                this.infoArea.setText(NO_SELECTED_EXP_DATA_MSSG);
            }
        }
    }

    private boolean updateGrouping() {
        if (this.singleButton.getSelection()) {
            this.selection2.clear();
        }
        if (this.selectionsOK()) {
            this.dataManager.setDataToBeUsed(this.selection1, this.selection2);
            return true;
        }
        return false;
    }

    private boolean selectionsOK() {
        if (this.selection1.isEmpty()) {
            MessageDialog.openError(this.shell, "Missing Selection!", "You should select at least one experiment " + (!this.mode ? "to use!" : "in group 1 (Gr1)!"));
            return false;
        }
        if (this.mode && this.selection2.isEmpty()) {
            MessageDialog.openError(this.shell, "Missing Selection!", "You should select at least one experiment in group 2 (Gr2)!");
            return false;
        }
        return true;
    }

    private void createTable(Composite c) {
        this.table = new Table(c, 101124);
        this.table.setLinesVisible(true);
        this.table.setHeaderVisible(true);
        String[] columnNames = this.createColumns();
        this.createViewer(columnNames);
        this.table.addSelectionListener(this);
    }

    private void createViewer(String[] columnNames) {
        this.viewer = new TableViewer(this.table);
        this.viewer.setUseHashlookup(true);
        this.viewer.setColumnProperties(columnNames);
        CellEditor[] editors = new CellEditor[columnNames.length];
        TextCellEditor textEditor = new TextCellEditor(this.table);
        ((Text)textEditor.getControl()).setTextLimit(60);
        editors[0] = textEditor;
        editors[1] = new CheckboxCellEditor(this.table);
        if (this.mode) {
            editors[2] = new CheckboxCellEditor(this.table);
        }
        this.viewer.setCellEditors(editors);
        this.viewer.setCellModifier(new CellModifier());
        this.viewer.setContentProvider(new ContentProvider());
        this.viewer.setLabelProvider(new LabelProvider());
        this.items = new RowItem[this.dataManager.getExperimentSize()];
        for (int i = 0; i < this.items.length; ++i) {
            this.items[i] = new RowItem(i);
        }
        this.viewer.setInput(this.items);
    }

    private String[] createColumns() {
        boolean compare = this.mode;
        String[] columnNames = this.getColumnNames();
        TableColumn column = new TableColumn(this.table, 16384, 0);
        column.setText(columnNames[0]);
        column.setWidth(100);
        column = new TableColumn(this.table, 0x1000000, 1);
        column.setText(columnNames[1]);
        column.setWidth(30);
        if (compare) {
            column = new TableColumn(this.table, 0x1000000, 2);
            column.setText(columnNames[2]);
            column.setWidth(30);
        }
        return columnNames;
    }

    private void recreateTable() {
        this.table.dispose();
        this.createTable(this.experimentGroup);
        this.shell.setSize(this.shell.getSize().x, this.shell.getSize().y + 1);
        this.shell.setSize(this.shell.getSize().x, this.shell.getSize().y - 1);
        this.shell.pack();
    }

    private void colorColumns() {
        for (TableItem item : this.table.getItems()) {
            if (item.hashCode() % 2 != 0) continue;
            item.setForeground(new Color(null, 255, 0, 0));
        }
    }

    private String[] getColumnNames() {
        String[] columnNames = new String[this.compareButton.getSelection() ? 3 : 2];
        columnNames[0] = "Experiment";
        String string = columnNames[1] = this.mode ? "Gr1" : "Use";
        if (this.mode) {
            columnNames[2] = "Gr2";
        }
        return columnNames;
    }

    int getColumnNo(String s) {
        if (s.equals("Experiment")) {
            return 0;
        }
        if (s.equals("Use") || s.equals("Gr1")) {
            return 1;
        }
        if (s.equals("Gr2")) {
            return 2;
        }
        throw new RuntimeException("Invalid column name: " + s);
    }

    private class RowItem {
        private int expNum;

        private RowItem(int expNum) {
            this.expNum = expNum;
        }

        String getExperimentName() {
            return ExperimentDataManagementDialog.this.dataManager.getExperimentName(this.expNum);
        }

        boolean inGroup1() {
            return ExperimentDataManagementDialog.this.selection1.contains(this.expNum);
        }

        boolean inGroup2() {
            return ExperimentDataManagementDialog.this.selection2.contains(this.expNum);
        }

        void updateGroup1Inclusion(boolean include) {
            if (include) {
                if (!ExperimentDataManagementDialog.this.selection1.contains(this.expNum)) {
                    ExperimentDataManagementDialog.this.selection1.add(this.expNum);
                    ExperimentDataManagementDialog.this.selection2.remove(new Integer(this.expNum));
                }
            } else {
                ExperimentDataManagementDialog.this.selection1.remove(new Integer(this.expNum));
            }
        }

        void updateGroup2Inclusion(boolean include) {
            if (include) {
                if (!ExperimentDataManagementDialog.this.selection2.contains(this.expNum)) {
                    ExperimentDataManagementDialog.this.selection2.add(this.expNum);
                    ExperimentDataManagementDialog.this.selection1.remove(new Integer(this.expNum));
                }
            } else {
                ExperimentDataManagementDialog.this.selection2.remove(new Integer(this.expNum));
            }
        }

        Object getValue(int columnNo) {
            switch (columnNo) {
                case 0: {
                    return this.getExperimentName();
                }
                case 1: {
                    return this.inGroup1();
                }
                case 2: {
                    return this.inGroup2();
                }
            }
            throw new RuntimeException("Invalid column no: " + columnNo);
        }

        Object getValue(String columnName) {
            int no = ExperimentDataManagementDialog.this.getColumnNo(columnName);
            return this.getValue(no);
        }

        void setValue(int columnNo, Object newValue) {
            boolean v = (Boolean)newValue;
            switch (columnNo) {
                case 1: {
                    this.updateGroup1Inclusion(v);
                    break;
                }
                case 2: {
                    this.updateGroup2Inclusion(v);
                    break;
                }
                default: {
                    throw new RuntimeException("Invalid column no: " + columnNo);
                }
            }
            ExperimentDataManagementDialog.this.saveButton.setEnabled(true);
            ExperimentDataManagementDialog.this.viewer.update(this, null);
        }

        void setValue(String columnName, Object newValue) {
            int no = ExperimentDataManagementDialog.this.getColumnNo(columnName);
            this.setValue(no, newValue);
        }
    }

    private class LabelProvider
    implements ITableLabelProvider {
        private LabelProvider() {
        }

        @Override
        public void addListener(ILabelProviderListener iLabelProviderListener) {
        }

        @Override
        public void dispose() {
        }

        @Override
        public boolean isLabelProperty(Object o, String s) {
            return false;
        }

        @Override
        public void removeListener(ILabelProviderListener iLabelProviderListener) {
        }

        @Override
        public Image getColumnImage(Object o, int i) {
            return null;
        }

        @Override
        public String getColumnText(Object o, int i) {
            RowItem item = (RowItem)o;
            if (i == 0) {
                return item.getValue(i).toString();
            }
            boolean checked = (Boolean)item.getValue(i);
            return checked ? "X" : "";
        }
    }

    private class ContentProvider
    implements IStructuredContentProvider {
        private ContentProvider() {
        }

        @Override
        public void dispose() {
        }

        @Override
        public void inputChanged(Viewer viewer, Object o, Object o1) {
        }

        @Override
        public Object[] getElements(Object o) {
            return ExperimentDataManagementDialog.this.items;
        }
    }

    private class CellModifier
    implements ICellModifier {
        private CellModifier() {
        }

        @Override
        public boolean canModify(Object o, String s) {
            return ExperimentDataManagementDialog.this.getColumnNo(s) > 0;
        }

        @Override
        public Object getValue(Object o, String s) {
            RowItem item = (RowItem)o;
            return item.getValue(s);
        }

        @Override
        public void modify(Object o, String s, Object o1) {
            TableItem item = (TableItem)o;
            RowItem row = (RowItem)item.getData();
            row.setValue(s, o1);
            ExperimentDataManagementDialog.this.viewer.update(item, null);
        }
    }
}

