/*
 * Decompiled with CFR 0.152.
 */
package org.patika.mada.gui;

import java.io.File;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;

public class FileTable
extends JTable {
    DefaultCellEditor ce;

    FileTable(File file) {
        this.setModel(new FileTableModel(file));
        this.setAutoscrolls(true);
        this.setDragEnabled(false);
        TableColumn noColumn = this.getColumnModel().getColumn(0);
        noColumn.setPreferredWidth(45);
        noColumn.setMaxWidth(45);
        noColumn.setMinWidth(45);
        TableColumn removeColumn = this.getColumnModel().getColumn(2);
        removeColumn.setPreferredWidth(60);
        removeColumn.setMaxWidth(60);
        removeColumn.setMinWidth(60);
        TableColumn patikaColumn = this.getColumnModel().getColumn(1);
        JCheckBox cb = new JCheckBox();
        patikaColumn.setCellEditor(new DefaultCellEditor(cb));
        DefaultTableCellRenderer renderer = new DefaultTableCellRenderer();
        renderer.setToolTipText("Click to select");
        patikaColumn.setCellRenderer(renderer);
    }

    public boolean canNext() {
        return this.getModel().getRowCount() >= 1;
    }

    public void addRow(File newFile) {
        ((FileTableModel)this.getModel()).addRow(newFile);
        this.validate();
    }

    public void removeRow(int rowNum) {
        ((FileTableModel)this.getModel()).deleteRow(rowNum);
        this.validate();
    }

    public class FileTableModel
    extends AbstractTableModel {
        Vector files = new Vector();
        Vector checkBoxes = new Vector();
        Vector fileNo = new Vector();

        FileTableModel(File file) {
            this.fileNo.add(new Integer(1));
            this.files.add(file);
            this.checkBoxes.add(new Boolean("false"));
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public int getRowCount() {
            return this.fileNo.size();
        }

        @Override
        public String getColumnName(int col) {
            if (col == 0) {
                return "No";
            }
            if (col == 1) {
                return "File Name";
            }
            if (col == 2) {
                return "Remove";
            }
            return "";
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (col == 0) {
                return this.fileNo.get(row);
            }
            if (col == 1) {
                return ((File)this.files.get(row)).getName();
            }
            if (col == 2) {
                return this.checkBoxes.get(row);
            }
            return null;
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return col > 1;
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            if (col == 0) {
                this.fileNo.set(row, value);
            } else if (col == 1) {
                this.files.set(row, value);
            } else if (col == 2) {
                this.checkBoxes.set(row, value);
            }
            this.fireTableCellUpdated(row, col);
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        public void addRow(File newFile) {
            this.fileNo.add(new Integer(this.fileNo.size() + 1));
            this.files.add(newFile);
            this.checkBoxes.add(new Boolean("false"));
            this.fireTableDataChanged();
        }

        public void deleteRow(int rowNum) {
            this.fileNo.remove(rowNum);
            this.files.remove(rowNum);
            this.checkBoxes.remove(rowNum);
        }
    }
}

