/*
 * Decompiled with CFR 0.152.
 */
package org.patika.mada.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import org.patika.mada.gui.ExperimentDataConvertionWizard;
import org.patika.mada.gui.MultipleDataFileLoadPage;
import org.patika.mada.gui.PatikaWizardPage;
import org.patika.mada.gui.SingleDataFileLoadPage;

public class KeyValueSpecificationPage
extends PatikaWizardPage
implements ActionListener {
    private ExperimentDataConvertionWizard mdcw;
    private Vector columns;
    private TitledBorder mainTitledBorder;
    private JPanel keyMappingPanel;
    private JLabel keyLabel;
    JComboBox keyComboBox;
    private JPanel valueColumnPanel;
    private JLabel valueStartLabel;
    private JLabel valueEndLabel;
    JComboBox columnsStartComboBox;
    private JComboBox columnsEndComboBox;

    public KeyValueSpecificationPage(ExperimentDataConvertionWizard mdcw) {
        super(mdcw);
        this.mdcw = mdcw;
        this.columns = new Vector();
        this.setSize(new Dimension(489, 260));
        this.setLayout(new FlowLayout());
        this.mainTitledBorder = new TitledBorder(BorderFactory.createEtchedBorder(new Color(52, 52, 52), new Color(25, 25, 25)), " Key - value association ");
        this.setBorder(this.mainTitledBorder);
    }

    public void init() {
        this.removeAll();
        this.valueColumnPanel = new JPanel();
        this.valueColumnPanel.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(new Color(52, 52, 52), new Color(25, 25, 25)), " Experiment value column(s) specification "));
        if (this.mdcw.isDataInSingleFile()) {
            this.valueStartLabel = new JLabel("Experiment values start at column");
            this.valueEndLabel = new JLabel("Experiment values  end  at column ");
            this.columns = ((SingleDataFileLoadPage)this.mdcw.pages[2]).getColumns();
            this.columns = this.mdcw.hasPlatformFile() ? ((SingleDataFileLoadPage)this.mdcw.pages[2]).getColumns() : ((SingleDataFileLoadPage)this.mdcw.pages[1]).getColumns();
        } else {
            this.valueColumnPanel.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(new Color(52, 52, 52), new Color(25, 25, 25)), " Value column specification "));
            this.valueStartLabel = new JLabel("Column to use as value ");
            this.columns = this.mdcw.hasPlatformFile() ? ((MultipleDataFileLoadPage)this.mdcw.pages[2]).getColumns((File)((MultipleDataFileLoadPage)this.mdcw.pages[2]).getLoadedFiles().get(0)) : ((MultipleDataFileLoadPage)this.mdcw.pages[2]).getColumns((File)((MultipleDataFileLoadPage)this.mdcw.pages[2]).getLoadedFiles().get(0));
        }
        this.columnsStartComboBox = new JComboBox(this.columns);
        this.columnsStartComboBox.addActionListener(this);
        this.columnsEndComboBox = new JComboBox(this.columns);
        this.columnsEndComboBox.addActionListener(this);
        this.columnsStartComboBox.addActionListener(this);
        this.recognizeValueColumn();
        if (!this.mdcw.isDataInSingleFile()) {
            this.valueColumnPanel.setPreferredSize(new Dimension(470, 55));
            this.valueColumnPanel.setLayout(new GridLayout(1, 2, 15, 15));
            this.valueColumnPanel.add(this.valueStartLabel);
            this.valueColumnPanel.add(this.columnsStartComboBox);
        } else {
            this.valueColumnPanel.setPreferredSize(new Dimension(470, 100));
            this.valueColumnPanel.setLayout(new GridLayout(2, 2, 15, 15));
            this.valueColumnPanel.add(this.valueStartLabel);
            this.valueColumnPanel.add(this.columnsStartComboBox);
            this.valueColumnPanel.add(this.valueEndLabel);
            this.valueColumnPanel.add(this.columnsEndComboBox);
        }
        this.keyMappingPanel = new JPanel();
        this.keyMappingPanel.setPreferredSize(new Dimension(470, 55));
        this.keyMappingPanel.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(new Color(52, 52, 52), new Color(25, 25, 25)), " Key Specification "));
        this.keyLabel = new JLabel("Key in annotation file corresponds to");
        this.keyComboBox = new JComboBox(this.columns);
        this.keyComboBox.addActionListener(this);
        this.keyMappingPanel.setLayout(new GridLayout(1, 2));
        this.keyMappingPanel.add(this.keyLabel);
        this.keyMappingPanel.add(this.keyComboBox);
        if (!this.mdcw.isDataInSingleFile()) {
            this.add(new JLabel("                                           "));
            this.add(new JLabel("                                           "));
        }
        this.add(this.keyMappingPanel);
        this.add(new JLabel("                                           "));
        this.add(new JLabel("                                           "));
        this.add(this.valueColumnPanel);
    }

    private void recognizeValueColumn() {
        for (int i = 0; i < this.columns.size(); ++i) {
            String column = (String)this.columns.get(i);
            Pattern pattern = Pattern.compile(".*VALUE.*");
            Matcher matcher = pattern.matcher(column);
            if (!matcher.matches()) continue;
            if (this.columnsEndComboBox != null) {
                this.columnsEndComboBox.setSelectedIndex(i);
            }
            this.columnsStartComboBox.setSelectedIndex(i);
            break;
        }
    }

    @Override
    void reset() {
    }

    @Override
    void update() {
    }

    @Override
    public boolean canNext() {
        return false;
    }

    @Override
    public boolean canFinish() {
        if (this.columnsStartComboBox == null || this.keyComboBox == null) {
            return false;
        }
        if (this.mdcw.isDataInSingleFile() && this.columnsStartComboBox.getSelectedIndex() > this.columnsEndComboBox.getSelectedIndex()) {
            return false;
        }
        return (String)this.columnsStartComboBox.getSelectedItem() == null || (String)this.keyComboBox.getSelectedItem() == null || !((String)this.columnsStartComboBox.getSelectedItem()).equals((String)this.keyComboBox.getSelectedItem());
    }

    public String getKeyInDataFile() {
        return (String)this.keyComboBox.getSelectedItem();
    }

    public String getExperimentStartColumn() {
        return (String)this.columnsStartComboBox.getSelectedItem();
    }

    public int getIndexOfExperimentStartColumn() {
        return this.columns.indexOf(this.columnsStartComboBox.getSelectedItem());
    }

    public int getIndexOfExperimentEndColumn() {
        return this.columns.indexOf(this.columnsEndComboBox.getSelectedItem());
    }

    public String getExperimentValueColumn() {
        return (String)this.columnsStartComboBox.getSelectedItem();
    }

    public int getIndexOfExperimentValueColumn() {
        return this.columns.indexOf(this.columnsStartComboBox.getSelectedItem());
    }

    public int getIndexOfKeyInDataFile() {
        return this.columns.indexOf(this.keyComboBox.getSelectedItem());
    }

    public Vector getColumns() {
        return this.columns;
    }

    public String[] getExperimentNames() {
        String[] experimentNames = null;
        if (this.mdcw.isDataInSingleFile()) {
            experimentNames = new String[this.columns.size() - this.getIndexOfExperimentStartColumn()];
            for (int i = 0; i < experimentNames.length; ++i) {
                experimentNames[i] = (String)this.columns.get(this.getIndexOfExperimentStartColumn() + i);
            }
        }
        return experimentNames;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.mdcw.isDataInSingleFile() && e.getSource() == this.columnsStartComboBox) {
            if (this.columnsStartComboBox.getSelectedIndex() > this.columnsEndComboBox.getSelectedIndex()) {
                this.columnsEndComboBox.setSelectedIndex(this.columnsStartComboBox.getSelectedIndex());
            }
        } else if (this.mdcw.isDataInSingleFile() && e.getSource() == this.columnsEndComboBox && this.columnsStartComboBox.getSelectedIndex() > this.columnsEndComboBox.getSelectedIndex()) {
            this.columnsStartComboBox.setSelectedIndex(this.columnsEndComboBox.getSelectedIndex());
        }
        this.mdcw.checkButtons();
    }
}

