/*
 * Decompiled with CFR 0.152.
 */
package org.patika.mada.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;
import org.patika.mada.gui.ExperimentDataConvertionWizard;
import org.patika.mada.gui.MultipleDataFileLoadPage;
import org.patika.mada.gui.PatikaWizardPage;
import org.patika.mada.gui.ReferenceTable;
import org.patika.mada.gui.SingleDataFileLoadPage;

public class NonePlatformMappingPage
extends PatikaWizardPage
implements ActionListener {
    ExperimentDataConvertionWizard mdcw;
    List<String> columns;
    private JPanel valueChoosingPanel;
    private JLabel valuePanelEndLabel;
    private JComboBox columnsStartComboBox;
    private JComboBox columnsEndComboBox;
    private JPanel mappingPanel;
    private ReferenceTable mapTable;
    JScrollPane scrollPane;

    public NonePlatformMappingPage(ExperimentDataConvertionWizard mdcw) {
        super(mdcw);
        this.mdcw = mdcw;
        this.columns = new ArrayList<String>();
        this.setSize(new Dimension(489, 260));
        this.setLayout(new FlowLayout());
        TitledBorder mainTitledBorder = new TitledBorder(BorderFactory.createEtchedBorder(new Color(52, 52, 52), new Color(25, 25, 25)), " Identifier mapping ");
        this.setBorder(mainTitledBorder);
        this.valueChoosingPanel = new JPanel();
        this.valueChoosingPanel.setLayout(new FlowLayout());
        this.valueChoosingPanel.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(new Color(52, 52, 52), new Color(25, 25, 25)), " Value column specification "));
        this.mappingPanel = new JPanel();
        this.mappingPanel.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(new Color(52, 52, 52), new Color(25, 25, 25)), " Mapping table "));
        this.mappingPanel.setLayout(new BorderLayout());
        this.setLayout(new BorderLayout(10, 10));
        this.add((Component)this.valueChoosingPanel, "North");
        this.add((Component)this.mappingPanel, "Center");
    }

    public void init() {
        JLabel valuePanelStartLabel;
        if (this.mdcw.isDataInSingleFile()) {
            this.columns = new ArrayList<String>(((SingleDataFileLoadPage)this.mdcw.pages[1]).getColumns());
            valuePanelStartLabel = new JLabel("Experiment values start at column ");
            this.valuePanelEndLabel = new JLabel("Experiment values  end  at column ");
            this.columnsEndComboBox = new JComboBox<String>(new Vector<String>(this.columns));
            this.columnsEndComboBox.addActionListener(this);
        } else {
            this.columns = ((MultipleDataFileLoadPage)this.mdcw.pages[1]).getColumnList();
            valuePanelStartLabel = new JLabel("Column to use as experiment value ");
        }
        String[] referenceInCombo = this.getReferenceArray();
        this.mapTable = new ReferenceTable(this.mdcw, this.columns, referenceInCombo, this.mdcw.getPredictedMatches(this.columns));
        this.mapTable.getModel().addTableModelListener(this.mdcw);
        this.scrollPane = new JScrollPane(this.mapTable);
        this.mappingPanel.removeAll();
        this.mappingPanel.add(this.scrollPane);
        this.columnsStartComboBox = new JComboBox<String>(new Vector<String>(this.columns));
        this.columnsStartComboBox.addActionListener(this);
        this.recognizeValueColumn();
        this.valueChoosingPanel.removeAll();
        if (!this.mdcw.isDataInSingleFile()) {
            this.valueChoosingPanel.setPreferredSize(new Dimension(470, 55));
            this.valueChoosingPanel.setLayout(new BorderLayout(10, 30));
            this.valueChoosingPanel.add((Component)valuePanelStartLabel, "West");
            this.valueChoosingPanel.add((Component)this.columnsStartComboBox, "East");
        }
        if (this.mdcw.isDataInSingleFile()) {
            this.valueChoosingPanel.setPreferredSize(new Dimension(470, 85));
            this.valueChoosingPanel.setLayout(new GridLayout(2, 2, 5, 5));
            this.valueChoosingPanel.add(valuePanelStartLabel);
            this.valueChoosingPanel.add(this.columnsStartComboBox);
            this.valueChoosingPanel.add(this.valuePanelEndLabel);
            this.valueChoosingPanel.add(this.columnsEndComboBox);
        }
        this.validate();
    }

    private void recognizeValueColumn() {
        for (int i = 0; i < this.columns.size(); ++i) {
            String column = this.columns.get(i);
            Pattern pattern = Pattern.compile(".*VALUE.*");
            Matcher matcher = pattern.matcher(column);
            if (!matcher.matches()) continue;
            if (this.columnsEndComboBox != null) {
                this.columnsEndComboBox.setSelectedIndex(i);
            }
            this.columnsStartComboBox.setSelectedIndex(i);
            break;
        }
    }

    @Override
    void reset() {
    }

    @Override
    void update() {
    }

    @Override
    public boolean canNext() {
        return false;
    }

    @Override
    public boolean canFinish() {
        if (this.mapTable == null) {
            return false;
        }
        if (this.mdcw.isDataInSingleFile() && this.columnsStartComboBox.getSelectedIndex() > this.columnsEndComboBox.getSelectedIndex()) {
            return false;
        }
        return this.mapTable.canNext(this.mdcw.hasPlatformFile());
    }

    public ReferenceTable getMapTable() {
        return this.mapTable;
    }

    public HashMap<String, String> getMappedReferences() {
        return this.mapTable.getMappedReferences();
    }

    public void setMapTable(ReferenceTable mapTable) {
        this.mapTable = mapTable;
    }

    public File getFileToParse() {
        if (this.mdcw.isDataInSingleFile()) {
            return ((SingleDataFileLoadPage)this.mdcw.pages[1]).getLoadedFile();
        }
        return (File)((MultipleDataFileLoadPage)this.mdcw.pages[1]).getLoadedFiles().get(0);
    }

    public String getExperimentValueColumn() {
        return (String)this.columnsStartComboBox.getSelectedItem();
    }

    public int getIndexOfExperimentValueStartColumn() {
        return this.columns.indexOf(this.columnsStartComboBox.getSelectedItem().toString());
    }

    public int getIndexOfExperimentEndColumn() {
        return this.columns.indexOf(this.columnsEndComboBox.getSelectedItem().toString());
    }

    public List<String> getColumns() {
        return this.columns;
    }

    public String getNameOfKeyColumn() {
        return this.mapTable.getNameOfKeyColumn();
    }

    public int getIndexOfKey() {
        return this.columns.indexOf(this.getNameOfKeyColumn());
    }

    public String[] getExperimentNames() {
        String[] experimentNames = null;
        if (this.mdcw.isDataInSingleFile()) {
            experimentNames = new String[this.columns.size() - this.getIndexOfExperimentValueStartColumn()];
            for (int i = 0; i < experimentNames.length; ++i) {
                experimentNames[i] = this.columns.get(this.getIndexOfExperimentValueStartColumn() + i);
            }
        }
        return experimentNames;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.mdcw.isDataInSingleFile()) {
            if (e.getSource() == this.columnsStartComboBox) {
                if (this.columnsStartComboBox.getSelectedIndex() > this.columnsEndComboBox.getSelectedIndex()) {
                    this.columnsEndComboBox.setSelectedIndex(this.columnsStartComboBox.getSelectedIndex());
                }
            } else if (e.getSource() == this.columnsEndComboBox && this.columnsStartComboBox.getSelectedIndex() > this.columnsEndComboBox.getSelectedIndex()) {
                this.columnsStartComboBox.setSelectedIndex(this.columnsEndComboBox.getSelectedIndex());
            }
        }
    }

    private String[] getReferenceArray() {
        Collection<String> reftypes = ExperimentDataConvertionWizard.getKnownReferenceSetsMap().values();
        String[] ref = new String[reftypes.size() + 2];
        ref[0] = "None";
        ref[1] = "Key";
        int i = 2;
        for (String s : reftypes) {
            ref[i++] = s;
        }
        return ref;
    }
}

