/*
 * Decompiled with CFR 0.152.
 */
package org.patika.mada.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.util.LinkedList;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import org.patika.mada.gui.PatikaWizardPage;

public abstract class PatikaWizard
extends JDialog {
    protected int pageCount;
    PatikaWizardPage[] pages;
    protected int currentPage = 0;
    JButton finishButton = new JButton();
    JButton cancelButton = new JButton();
    JButton nextButton = new JButton();
    JButton backButton = new JButton();
    JCheckBox propagate = new JCheckBox();
    JPanel buttonsPanel = new JPanel();
    JPanel controllerPanel = new JPanel();
    BorderLayout mainLayout = new BorderLayout();
    protected boolean completed;
    private ActionListener patikaWizardAction;
    LinkedList predefinedMembers;

    public PatikaWizard() {
        this(null, (Object)null, null);
    }

    public PatikaWizard(String title, Object target) {
        this(title, target, null);
    }

    public PatikaWizard(String title, Object target, LinkedList predefinedMembers) {
        this.setTitle(title);
        if (System.getProperty("os.name") == null || !System.getProperty("os.name").toLowerCase().contains("os")) {
            this.setModal(true);
        }
        this.predefinedMembers = predefinedMembers;
        this.setDefaultCloseOperation(1);
        this.patikaWizardAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                PatikaWizard.this.checkButtons();
                Object object = event.getSource();
                if (object == PatikaWizard.this.finishButton) {
                    try {
                        PatikaWizard.this.finishButton_actionPerformed(event);
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                } else if (object == PatikaWizard.this.nextButton) {
                    try {
                        PatikaWizard.this.nextButton_actionPerformed(event);
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                } else if (object == PatikaWizard.this.backButton) {
                    try {
                        PatikaWizard.this.backButton_actionPerformed(event);
                    }
                    catch (Throwable throwable) {}
                } else if (object == PatikaWizard.this.cancelButton) {
                    try {
                        PatikaWizard.this.cancelButton_actionPerformed(event);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
        };
        this.cancelButton.addActionListener(this.patikaWizardAction);
        this.backButton.addActionListener(this.patikaWizardAction);
        this.nextButton.addActionListener(this.patikaWizardAction);
        this.finishButton.addActionListener(this.patikaWizardAction);
        this.initializeGUI();
        this.initPages(target);
    }

    public boolean isPropagateSelected() {
        return this.propagate.isSelected();
    }

    protected void initializeGUI() {
        this.setSize(500, 330);
        this.getContentPane().setLayout(this.mainLayout);
        this.controllerPanel.setAlignmentY(0.5f);
        this.controllerPanel.setBorder(BorderFactory.createEtchedBorder());
        this.backButton.setText("< Back");
        this.nextButton.setText("Next >");
        this.cancelButton.setText("Cancel");
        this.finishButton.setText("Finish");
        this.propagate.setText("Propagate to all views");
        this.controllerPanel.add((Component)this.propagate, null);
        this.controllerPanel.add((Component)this.cancelButton, null);
        this.controllerPanel.add((Component)this.backButton, null);
        this.controllerPanel.add((Component)this.nextButton, null);
        this.controllerPanel.add((Component)this.finishButton, null);
        this.getContentPane().add((Component)this.controllerPanel, "South");
        this.setLocationRelativeTo(null);
    }

    protected void resetPages() {
        for (int i = 0; i < this.pageCount; ++i) {
            this.pages[i].reset();
        }
    }

    protected void switchPage(int index, boolean reset) {
        assert (index > 0 || index <= this.pageCount) : "Page index out of bounds";
        this.pages[this.currentPage].setVisible(false);
        if (reset) {
            this.pages[this.currentPage].reset();
        }
        this.currentPage = index;
        this.getContentPane().add((Component)this.pages[this.currentPage], "Center");
        this.pages[this.currentPage].setVisible(true);
        this.checkButtons();
        this.getContentPane().repaint();
    }

    protected void checkButtons() {
        if (this.currentPage == this.pages.length - 1 || !this.pages[this.currentPage].canNext()) {
            this.nextButton.setEnabled(false);
        } else {
            this.nextButton.setEnabled(true);
        }
        if (this.currentPage == 0) {
            this.backButton.setEnabled(false);
        } else {
            this.backButton.setEnabled(true);
        }
        if (this.canFinish()) {
            this.finishButton.setEnabled(true);
        } else {
            this.finishButton.setEnabled(false);
        }
    }

    protected boolean canFinish() {
        boolean completed = true;
        for (int i = 0; i < this.pageCount; ++i) {
            if (this.pages[i].canFinish()) continue;
            completed = false;
            break;
        }
        return completed;
    }

    protected ActionListener getActionListener() {
        return this.patikaWizardAction;
    }

    public boolean isCompleted() {
        return this.completed;
    }

    public void setCompleted(boolean completed) {
        this.completed = completed;
    }

    protected abstract void initPages(Object var1);

    private void cancelButton_actionPerformed(ActionEvent event) {
        this.dispose();
    }

    private void backButton_actionPerformed(ActionEvent event) {
        this.switchPage(this.currentPage - 1, true);
    }

    protected void nextButton_actionPerformed(ActionEvent event) {
        this.switchPage(this.currentPage + 1, false);
    }

    public void finishButton_keyTyped(KeyEvent event) {
        if (event.getKeyChar() == '\n') {
            this.finish();
        }
    }

    void finishButton_actionPerformed(ActionEvent event) {
        this.finish();
    }

    protected void finish() {
        for (int i = 0; i < this.pages.length; ++i) {
            this.pages[i].update();
        }
        this.completed = true;
        this.dispose();
    }
}

