/*
 * Decompiled with CFR 0.152.
 */
package org.patika.mada.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import org.patika.mada.gui.ExperimentDataConvertionWizard;
import org.patika.mada.gui.PatikaWizardPage;
import org.patika.mada.gui.ReferenceTable;

public class PlatformMappingPage
extends PatikaWizardPage
implements ActionListener {
    ExperimentDataConvertionWizard mdcw;
    private File platformFile;
    private List<String> columns;
    private JTextField fileNameArea;
    private JPanel mappingPanel;
    private ReferenceTable mapTable;
    JScrollPane scrollPane;

    public PlatformMappingPage(ExperimentDataConvertionWizard mdcw) {
        super(mdcw);
        this.mdcw = mdcw;
        this.columns = new ArrayList<String>();
        this.setSize(new Dimension(489, 260));
        this.setLayout(new FlowLayout());
        TitledBorder mainTitledBorder = new TitledBorder(BorderFactory.createEtchedBorder(new Color(52, 52, 52), new Color(25, 25, 25)), " Identifier mapping ");
        this.setBorder(mainTitledBorder);
        JPanel platformFilePanel = new JPanel();
        platformFilePanel.setLayout(new FlowLayout());
        platformFilePanel.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(new Color(52, 52, 52), new Color(25, 25, 25)), " Select the tab-limited reference information file "));
        JLabel platformLabel1 = new JLabel("Reference information file: ");
        this.fileNameArea = new JTextField("             ");
        this.fileNameArea.setEditable(false);
        JButton browseButton = new JButton(" Browse ");
        browseButton.addActionListener(this);
        platformFilePanel.setLayout(new GridLayout(1, 3, 10, 10));
        platformFilePanel.add(platformLabel1);
        platformFilePanel.add(this.fileNameArea);
        platformFilePanel.add(browseButton);
        this.mappingPanel = new JPanel();
        this.mappingPanel.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(new Color(52, 52, 52), new Color(25, 25, 25)), " Map a column as key to data file(s) and at least one external reference"));
        this.mappingPanel.setLayout(new BorderLayout());
        this.setLayout(new BorderLayout(10, 10));
        this.add((Component)platformFilePanel, "North");
        this.add((Component)this.mappingPanel, "Center");
    }

    @Override
    void reset() {
    }

    @Override
    void update() {
    }

    @Override
    public boolean canNext() {
        return this.mapTable != null && this.mapTable.canNext(this.mdcw.hasPlatformFile());
    }

    @Override
    public boolean canFinish() {
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String line = "";
        JFileChooser chooser = new JFileChooser();
        String experimentSetInfo = "";
        if (ExperimentDataConvertionWizard.recentDir != null) {
            chooser.setCurrentDirectory(ExperimentDataConvertionWizard.recentDir);
        }
        chooser.setDialogTitle("Open the Reference File");
        int returnVal = chooser.showOpenDialog(this.mdcw);
        if (returnVal == 0) {
            this.platformFile = chooser.getSelectedFile();
            ExperimentDataConvertionWizard.recentDir = this.platformFile.getParentFile();
            this.columns.clear();
            if (!this.platformFile.exists()) {
                JOptionPane.showMessageDialog(this.mdcw, this.platformFile.getName() + " does not exists! ", null, 0);
            } else if (!this.isFileValid(this.platformFile)) {
                JOptionPane.showMessageDialog(this.mdcw, this.platformFile.getName() + " is not recognized by ChiBE because \n it contains non-ASCII characters.", "Illegal Reference File", 0);
            } else {
                this.fileNameArea.setText(this.platformFile.getName());
                try {
                    FileReader fr = new FileReader(this.platformFile);
                    BufferedReader br = new BufferedReader(fr);
                    while ((line = br.readLine()) != null && ExperimentDataConvertionWizard.startsWithSpecialChar(line)) {
                    }
                    this.mdcw.setExperimentSetInfo(experimentSetInfo);
                    if (line != null) {
                        StringTokenizer tokenizer = new StringTokenizer(line, "\t");
                        while (tokenizer.hasMoreTokens()) {
                            this.columns.add(tokenizer.nextToken());
                        }
                    }
                    if (this.columns.size() < 2) {
                        JOptionPane.showMessageDialog(this.mdcw, "Could not recognize file format, reference file must contain at least 1 identifier and 1 external reference columns! ", null, 0);
                    } else {
                        if (this.mapTable != null) {
                            this.mappingPanel.removeAll();
                        }
                        String[] referenceInCombo = this.getReferenceArray();
                        this.mapTable = new ReferenceTable(this.mdcw, this.columns, referenceInCombo, this.mdcw.getPredictedMatches(this.columns));
                        this.mapTable.getModel().addTableModelListener(this.mdcw);
                        this.scrollPane = new JScrollPane(this.mapTable);
                        this.scrollPane.setPreferredSize(this.mapTable.getSize());
                        this.mappingPanel.add(this.scrollPane);
                        if (this.mapTable.canNext(this.mdcw.hasPlatformFile())) {
                            this.mdcw.nextButton.setEnabled(true);
                        }
                        this.mappingPanel.validate();
                        this.validate();
                    }
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
        }
    }

    private String[] getReferenceArray() {
        Collection<String> reftypes = ExperimentDataConvertionWizard.getKnownReferenceSetsMap().values();
        String[] ref = new String[reftypes.size() + 1];
        ref[0] = "None";
        int i = 1;
        for (String s : reftypes) {
            ref[i++] = s;
        }
        return ref;
    }

    public ReferenceTable getMapTable() {
        return this.mapTable;
    }

    public List<String> getColumns() {
        return this.columns;
    }

    public File getPlatformFile() {
        return this.platformFile;
    }

    public HashMap<String, String> getMappedReferences() {
        return this.mapTable.getMappedReferences();
    }

    public String getNameOfKeyColumn() {
        return this.mapTable.getNameOfKeyColumn();
    }

    private boolean isFileValid(File f) {
        String line;
        BufferedReader br;
        try {
            br = new BufferedReader(new FileReader(f));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return false;
        }
        do {
            try {
                line = br.readLine();
                for (int i = 0; line != null && i < line.length(); ++i) {
                    if (line.charAt(i) <= '\u007f') continue;
                    throw new IOException();
                }
            }
            catch (IOException e) {
                System.out.println("reference file not valid");
                return false;
            }
        } while (line != null);
        return true;
    }
}

