/*
 * Decompiled with CFR 0.152.
 */
package org.patika.mada.gui;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import org.patika.mada.gui.ExperimentDataConvertionWizard;

public class ReferenceTable
extends JTable {
    DefaultCellEditor ce;
    private ExperimentDataConvertionWizard mdcw;
    private Map<String, String> predictedMatching;
    private boolean fromWizard;

    ReferenceTable(ExperimentDataConvertionWizard mdcw, List<String> columns, String[] referenceList, Map<String, String> predictedMatching) {
        this.mdcw = mdcw;
        this.predictedMatching = predictedMatching;
        this.fromWizard = true;
        this.setModel(new ReferenceTableModel(mdcw, columns));
        TableColumn patikaColumn = this.getColumnModel().getColumn(1);
        JComboBox<String> cb = new JComboBox<String>(referenceList);
        patikaColumn.setCellEditor(new DefaultCellEditor(cb));
        DefaultTableCellRenderer renderer = new DefaultTableCellRenderer();
        renderer.setToolTipText("Click for combo box");
        patikaColumn.setCellRenderer(renderer);
    }

    ReferenceTable(List<String> columns, Map<String, String> predictedMatching) {
        this.predictedMatching = predictedMatching;
        this.fromWizard = false;
        this.setModel(new ReferenceTableModel(this.mdcw, columns));
    }

    public boolean canNext(boolean hasPlatformFile) {
        boolean isKeyToDataFileSet = false;
        boolean isAnyReferenceSet = false;
        for (int i = 0; i < this.getRowCount(); ++i) {
            String columnValue = (String)this.getModel().getValueAt(i, 1);
            if (columnValue.equals("Key to data file(s)")) {
                isKeyToDataFileSet = true;
                continue;
            }
            if (columnValue.equals("None")) continue;
            isAnyReferenceSet = true;
        }
        if (hasPlatformFile) {
            return isKeyToDataFileSet & isAnyReferenceSet;
        }
        return isAnyReferenceSet;
    }

    public void updateTable(List<String> columns) {
        this.setModel(new ReferenceTableModel(this.mdcw, columns));
        this.repaint();
    }

    public HashMap<String, String> getMappedReferences() {
        HashMap<String, String> hm = new HashMap<String, String>();
        for (int i = 0; i < this.getRowCount(); ++i) {
            if (this.getValueAt(i, 1).equals("None") || this.getValueAt(i, 1).equals("Key to data file(s)")) continue;
            hm.put(this.getValueAt(i, 1).toString(), this.getValueAt(i, 0).toString());
        }
        if (this.getNameOfKeyColumn().equals("")) {
            hm.put(ExperimentDataConvertionWizard.KEY_COLUMN, hm.values().toArray()[0].toString());
        } else {
            hm.put(ExperimentDataConvertionWizard.KEY_COLUMN, this.getNameOfKeyColumn());
        }
        return hm;
    }

    public String getNameOfKeyColumn() {
        String key = "";
        for (int i = 0; i < this.getRowCount() - 1; ++i) {
            if (!this.getValueAt(i, 1).equals("Key to data file(s)")) continue;
            key = (String)this.getValueAt(i, 0);
        }
        if (key.equals("")) {
            key = (String)this.getValueAt(0, 0);
        }
        return key;
    }

    public class ReferenceTableModel
    extends AbstractTableModel {
        private ExperimentDataConvertionWizard mdcw;
        String[] columnNames = new String[]{"Column", "Maps to"};
        String[][] data = new String[0][];

        ReferenceTableModel(ExperimentDataConvertionWizard mdcw, List<String> userColumns) {
            this.mdcw = mdcw;
            this.data = new String[userColumns.size()][2];
            Iterator<String> iter = userColumns.iterator();
            int i = 0;
            while (iter.hasNext()) {
                this.data[i][0] = iter.next();
                this.data[i][1] = "None";
                ++i;
            }
            this.mapSupportedReferences();
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            boolean isLegal = true;
            for (int i = 0; i < this.getRowCount(); ++i) {
                if (value.equals("None") || i == row || !this.data[i][1].equals(value)) continue;
                JOptionPane.showMessageDialog(null, value + " is already mapped! ", "Ilegal Mapping", 2);
                isLegal = false;
                break;
            }
            if (isLegal) {
                this.data[row][col] = value.toString();
                this.fireTableCellUpdated(row, col);
            }
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public int getRowCount() {
            return this.data.length;
        }

        @Override
        public String getColumnName(int col) {
            return this.columnNames[col];
        }

        @Override
        public Object getValueAt(int row, int col) {
            return this.data[row][col];
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return col != 0;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        private void mapSupportedReferences() {
            String massage = "ChiBE performed the below reference mapping:\n\n";
            int numberOfMappedColumns = 0;
            for (int i = 0; i < this.data.length; ++i) {
                String columnInFile = this.data[i][0];
                String ref = (String)ReferenceTable.this.predictedMatching.get(columnInFile);
                if (ref == null) continue;
                this.setValueAt(ref, i, 1);
                massage = massage + columnInFile + "   ->   " + ref + "\n";
                ++numberOfMappedColumns;
            }
            massage = massage + "\nIf you wish you may change this mapping! ";
            if (numberOfMappedColumns > 0 && ReferenceTable.this.fromWizard) {
                JOptionPane.showMessageDialog(this.mdcw, massage, null, 1);
            }
        }
    }
}

