/*
 * Decompiled with CFR 0.152.
 */
package org.patika.mada.util;

import java.util.Iterator;
import org.eclipse.swt.graphics.Color;
import org.gvt.model.biopaxl2.Complex;
import org.patika.mada.graph.Edge;
import org.patika.mada.graph.GraphObject;
import org.patika.mada.graph.Node;
import org.patika.mada.util.Path;
import org.patika.mada.util.Representable;

public class CausativePath
extends Path {
    private static final Color SIGNIFICANT_TEXT_COLOR = new Color(null, 255, 255, 255);
    private static final Color SIGNIFICANT_UPREGULATION_COLOR = new Color(null, 200, 20, 20);
    private static final Color SIGNIFICANT_DOWNREGULATION_COLOR = new Color(null, 20, 20, 200);
    private static final Color INFERRED_TEXT_COLOR = new Color(null, 0, 0, 0);
    private static final Color INFERRED_UPREGULATION_COLOR = new Color(null, 255, 200, 200);
    private static final Color INFERRED_DOWNREGULATION_COLOR = new Color(null, 200, 200, 255);
    public static final String INFERENCE_DATA_KEY = "INFERENCE_DATA_KEY";

    public void associateInferenceData() {
        Iterator goIter = this.getObjects().iterator();
        Node start = (Node)goIter.next();
        assert (start.hasSignificantExperimentalChange("Expression Data"));
        int sign = start.getExperimentData("Expression Data").getSign();
        start.putLabel(INFERENCE_DATA_KEY, new InferenceData(true, sign > 0));
        while (goIter.hasNext()) {
            GraphObject go = (GraphObject)goIter.next();
            if (go instanceof Node) {
                Node node = (Node)go;
                boolean significant = node.hasSignificantExperimentalChange("Expression Data");
                node.putLabel(INFERENCE_DATA_KEY, new InferenceData(significant, sign > 0));
                if (!(node instanceof Complex)) continue;
                for (Node node2 : node.getChildren()) {
                    if (this.contains(node2)) continue;
                    node2.putLabel(INFERENCE_DATA_KEY, new InferenceData(significant, sign > 0));
                }
                continue;
            }
            Edge edge = (Edge)go;
            sign *= edge.getSign();
        }
    }

    public void removeInferenceData() {
        for (Node node : this.getNodes()) {
            node.removeLabel(INFERENCE_DATA_KEY);
            if (!(node instanceof Complex)) continue;
            for (Node node2 : node.getChildren()) {
                if (this.contains(node2)) continue;
                node2.removeLabel(INFERENCE_DATA_KEY);
            }
        }
    }

    private class InferenceData
    implements Representable {
        private boolean significant;
        private boolean upregulated;

        private InferenceData(boolean significant, boolean upregulated) {
            this.significant = significant;
            this.upregulated = upregulated;
        }

        @Override
        public boolean alterNodeColor() {
            return true;
        }

        @Override
        public boolean alterToolTipText() {
            return false;
        }

        @Override
        public boolean alterTextColor() {
            return true;
        }

        @Override
        public Color getNodeColor() {
            return this.significant ? (this.upregulated ? SIGNIFICANT_UPREGULATION_COLOR : SIGNIFICANT_DOWNREGULATION_COLOR) : (this.upregulated ? INFERRED_UPREGULATION_COLOR : INFERRED_DOWNREGULATION_COLOR);
        }

        @Override
        public String getToolTipText() {
            return null;
        }

        @Override
        public Color getTextColor() {
            return this.significant ? SIGNIFICANT_TEXT_COLOR : INFERRED_TEXT_COLOR;
        }
    }
}

