/*
 * Decompiled with CFR 0.152.
 */
package org.patika.mada.util;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import org.patika.mada.dataXML.ChisioExperimentData;
import org.patika.mada.dataXML.Experiment;
import org.patika.mada.dataXML.Grouping;
import org.patika.mada.dataXML.ObjectFactory;
import org.patika.mada.dataXML.Reference;
import org.patika.mada.dataXML.Row;
import org.patika.mada.dataXML.ValueTuple;
import org.patika.mada.graph.Graph;
import org.patika.mada.graph.Node;
import org.patika.mada.gui.ExperimentDataConvertionWizard;
import org.patika.mada.util.AlterationData;
import org.patika.mada.util.CBioPortalAlterationData;
import org.patika.mada.util.CopyNumberData;
import org.patika.mada.util.ExperimentData;
import org.patika.mada.util.ExpressionData;
import org.patika.mada.util.MassSpecData;
import org.patika.mada.util.MutationData;
import org.patika.mada.util.XRef;

public class ExperimentDataManager {
    private ChisioExperimentData ced;
    private String type;
    private String fileLocation;
    private List<Map<XRef, List<Double>>> experimentMapsList;
    private List<String> experimentInfoList;
    private List<String> experimentNameList;
    private List<Double> maxValueList;
    private List<Double> minValueList;
    private String datasetInfo;
    private List<Integer> firstExpIndices;
    private List<Integer> secondExpIndices;
    private int averaging;
    public static final int MEAN = 0;
    public static final int MEDIAN = 1;
    public static final int MAX = 2;

    public ExperimentDataManager(String type) {
        this.type = type;
        this.firstExpIndices = new ArrayList<Integer>();
        this.secondExpIndices = new ArrayList<Integer>();
        this.averaging = 2;
    }

    public ExperimentDataManager(ChisioExperimentData data, String fileLocation) {
        this(data.getExperimentType());
        this.setData(data);
        this.fileLocation = fileLocation;
    }

    public String getType() {
        return this.type;
    }

    public void setData(ChisioExperimentData data) {
        int i;
        boolean hasExpInfo;
        this.firstExpIndices.clear();
        this.secondExpIndices.clear();
        this.ced = data;
        int expSize = data.getExperiment().size();
        HashMap<Integer, Integer> expNoToIndex = new HashMap<Integer, Integer>();
        this.maxValueList = new ArrayList<Double>(expSize);
        this.minValueList = new ArrayList<Double>(expSize);
        for (int i2 = 0; i2 < expSize; ++i2) {
            this.maxValueList.add(-1.7976931348623157E308);
            this.minValueList.add((Double)Double.MAX_VALUE);
        }
        Iterator expIter = data.getExperiment().iterator();
        boolean bl = hasExpInfo = ((Experiment)data.getExperiment().get(0)).getExperimentInfo() != null;
        if (hasExpInfo) {
            this.experimentInfoList = new ArrayList<String>(expSize);
        }
        this.experimentNameList = new ArrayList<String>(expSize);
        for (i = 0; i < expSize; ++i) {
            Experiment exp = (Experiment)expIter.next();
            assert (!expNoToIndex.containsKey(exp.getNo())) : "Multiple experiments with same No: " + exp.getNo();
            expNoToIndex.put(exp.getNo(), i);
            if (hasExpInfo) {
                this.experimentInfoList.add(exp.getExperimentInfo());
            }
            this.experimentNameList.add(exp.getExperimentName());
        }
        this.datasetInfo = data.getExperimentSetInfo();
        this.experimentMapsList = new ArrayList<Map<XRef, List<Double>>>(expSize);
        for (i = 0; i < expSize; ++i) {
            this.experimentMapsList.add(new HashMap());
        }
        for (Object o1 : data.getRow()) {
            Row row = (Row)o1;
            for (Object o2 : row.getValue()) {
                ValueTuple val = (ValueTuple)o2;
                double value = val.getValue();
                int expIndex = (Integer)expNoToIndex.get(val.getNo());
                Map<XRef, List<Double>> map = this.experimentMapsList.get(expIndex);
                for (Object o3 : row.getRef()) {
                    XRef ref = new XRef((Reference)o3);
                    if (!map.containsKey(ref)) {
                        map.put(ref, new ArrayList());
                    }
                    map.get(ref).add(value);
                    if (this.maxValueList.get(expIndex) < value) {
                        this.maxValueList.set(expIndex, value);
                    }
                    if (!(this.minValueList.get(expIndex) > value)) continue;
                    this.minValueList.set(expIndex, value);
                }
            }
        }
        Grouping g = this.ced.getGrouping();
        ArrayList<Integer> firstInd = new ArrayList<Integer>();
        ArrayList<Integer> seconInd = new ArrayList<Integer>();
        if (g != null) {
            Iterator iterator = new ArrayList(g.getGroup1()).iterator();
            while (iterator.hasNext()) {
                int n = (Integer)iterator.next();
                firstInd.add((Integer)expNoToIndex.get(n));
            }
            iterator = new ArrayList(g.getGroup2()).iterator();
            while (iterator.hasNext()) {
                int n = (Integer)iterator.next();
                seconInd.add((Integer)expNoToIndex.get(n));
            }
        }
        if (!this.experimentMapsList.isEmpty() && firstInd.isEmpty()) {
            firstInd.add(0);
            if (this.experimentMapsList.size() > 1) {
                seconInd.add(1);
            }
        }
        this.setDataToBeUsed(firstInd, seconInd);
    }

    public boolean isDataAvailable() {
        return this.experimentMapsList != null;
    }

    public ChisioExperimentData getCed() {
        return this.ced;
    }

    public void discardMicroarrayData() {
        this.ced = null;
        this.experimentMapsList = null;
        this.experimentInfoList = null;
        this.experimentNameList = null;
        this.firstExpIndices.clear();
        this.secondExpIndices.clear();
        System.gc();
    }

    public void setDataToBeUsed(List<Integer> index) {
        this.setDataToBeUsed(index, null);
    }

    public void setDataToBeUsed(List<Integer> index1, List<Integer> index2) {
        this.firstExpIndices.clear();
        this.secondExpIndices.clear();
        this.firstExpIndices.addAll(index1);
        if (index2 != null) {
            for (int i : this.secondExpIndices) {
                assert (!this.firstExpIndices.contains(i)) : "Experiment indices overlaps! index: " + i;
            }
            this.secondExpIndices.addAll(index2);
        }
        if (this.type.equals("Expression Data")) {
            ExpressionData.maxValue = this.getMaxValue();
            ExpressionData.minValue = this.getMinValue();
        } else if (this.type.equals("Mass Spectrometry Data")) {
            MassSpecData.maxValue = this.getMaxValue();
            MassSpecData.minValue = this.getMinValue();
        } else if (this.type.equals("Copy Number Variation Data")) {
            CopyNumberData.maxValue = this.getMaxValue();
            CopyNumberData.minValue = this.getMinValue();
        } else if (this.type.equals("Mutation Data")) {
            // empty if block
        }
        Grouping g = this.ced.getGrouping();
        if (g == null) {
            try {
                g = new ObjectFactory().createGrouping();
                this.ced.setGrouping(g);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        List g1 = g.getGroup1();
        g1.clear();
        for (int i : this.firstExpIndices) {
            g1.add(((Experiment)this.ced.getExperiment().get(i)).getNo());
        }
        List g2 = g.getGroup2();
        g2.clear();
        for (int i : this.secondExpIndices) {
            g2.add(((Experiment)this.ced.getExperiment().get(i)).getNo());
        }
    }

    public List<Integer> getFirstExpIndices() {
        return this.firstExpIndices;
    }

    public List<Integer> getSecondExpIndices() {
        return this.secondExpIndices;
    }

    public boolean isExpInfoAvailable() {
        return this.experimentMapsList != null;
    }

    public boolean isDatasetInfoAvailable() {
        return this.datasetInfo != null;
    }

    public String getDatasetInfo() {
        return this.datasetInfo;
    }

    public String getExperimentInfo(int index) {
        return this.experimentInfoList.get(index);
    }

    public String getExperimentName(int index) {
        return this.experimentNameList.get(index);
    }

    public int getAveraging() {
        return this.averaging;
    }

    public void setAveraging(int averaging) {
        assert (averaging == 2 || averaging == 0 || averaging == 1) : "unknown averaging method : " + averaging;
        this.averaging = averaging;
    }

    public boolean isInCompareMode() {
        return !this.getSecondExpIndices().isEmpty();
    }

    public double getMaxValue() {
        if (!this.firstExpIndices.isEmpty()) {
            double firstMax = -1.7976931348623157E308;
            for (int i : this.firstExpIndices) {
                double first = this.maxValueList.get(i);
                if (!(first > firstMax)) continue;
                firstMax = first;
            }
            if (this.secondExpIndices.isEmpty()) {
                return firstMax;
            }
            double secondMax = -1.7976931348623157E308;
            for (int i : this.secondExpIndices) {
                double second = this.maxValueList.get(i);
                if (!(second > secondMax)) continue;
                secondMax = second;
            }
            return Math.max(firstMax, secondMax);
        }
        return 0.0;
    }

    public double getMinValue() {
        if (!this.firstExpIndices.isEmpty()) {
            double firstMin = Double.MAX_VALUE;
            for (int i : this.firstExpIndices) {
                double first = this.minValueList.get(i);
                if (!(first < firstMin)) continue;
                firstMin = first;
            }
            if (this.secondExpIndices.isEmpty()) {
                return firstMin;
            }
            double secondMin = Double.MAX_VALUE;
            for (int i : this.secondExpIndices) {
                double second = this.minValueList.get(i);
                if (!(second < secondMin)) continue;
                secondMin = second;
            }
            return Math.min(firstMin, secondMin);
        }
        return 0.0;
    }

    public int getExperimentSize() {
        if (this.isDataAvailable()) {
            return this.experimentMapsList.size();
        }
        return 0;
    }

    public ExperimentData getExperimentData(XRef ref) {
        if (this.firstExpIndices.isEmpty()) {
            return null;
        }
        Double v1 = this.getValue(this.firstExpIndices, ref);
        if (v1 != null) {
            if (this.secondExpIndices.isEmpty()) {
                return this.createExperimentData(v1);
            }
            Double v2 = this.getValue(this.secondExpIndices, ref);
            if (v2 != null) {
                return this.createExperimentData(v1, v2);
            }
        }
        return null;
    }

    public void associateExperimentData(Collection<? extends Graph> graphs) {
        for (Graph graph : graphs) {
            this.associateExperimentData(graph);
        }
    }

    public void associateExperimentData(Graph graph) {
        for (Node node : graph.getNodes()) {
            this.associateExperimentData(node);
        }
    }

    public void associateExperimentData(List<Node> nodes) {
        for (Node node : nodes) {
            this.associateExperimentData(node);
        }
    }

    public void associateExperimentData(Node node) {
        HashSet<ExperimentData> datas = new HashSet<ExperimentData>();
        this.addMappedData(datas, node.getReferences());
        this.addMappedData(datas, node.getSecondaryReferences());
        if (!datas.isEmpty()) {
            ExperimentData data = this.averageData(datas);
            node.setExperimentData(data);
        }
    }

    private void addMappedData(Set<ExperimentData> datas, List<XRef> refs) {
        for (XRef ref : refs) {
            ExperimentData data = this.getExperimentData(ref);
            if (data == null) continue;
            datas.add(data);
        }
    }

    private ExperimentData averageData(Set<ExperimentData> dataList) {
        ArrayList<Double> v1s = new ArrayList<Double>();
        ArrayList<Double> v2s = new ArrayList<Double>();
        for (ExperimentData data : dataList) {
            v1s.add(data.getValue1());
            if (!data.isDouble()) continue;
            v2s.add(data.getValue2());
        }
        assert (v2s.isEmpty() || v2s.size() == v1s.size()) : "Disaster! Mixed single and double experiments";
        if (v2s.isEmpty()) {
            return this.createExperimentData(this.average(v1s));
        }
        return this.createExperimentData(this.average(v1s), this.average(v2s));
    }

    public void clearExperimentData(Graph graph) {
        assert (graph != null);
        for (Node node : graph.getNodes()) {
            if (!node.hasLabel(this.type)) continue;
            node.removeLabel(this.type);
        }
    }

    private Double getValue(List<Integer> expIndices, XRef ref) {
        Map<List<String>, String> referenceList = ExperimentDataConvertionWizard.getKnownReferenceSetsMap();
        if (expIndices.size() == 1) {
            return this.getValue(expIndices.get(0), ref, referenceList);
        }
        ArrayList<Double> vals = new ArrayList<Double>();
        for (int i : expIndices) {
            Double v = this.getValue(i, ref, referenceList);
            if (v == null) continue;
            vals.add(v);
        }
        if (vals.isEmpty()) {
            return null;
        }
        return this.average(vals);
    }

    private double average(Collection<Double> vals) {
        switch (this.averaging) {
            case 2: {
                return this.max(vals);
            }
            case 0: {
                return this.mean(vals);
            }
            case 1: {
                return this.median(vals);
            }
        }
        throw new RuntimeException("Invalid averaging method: " + this.averaging);
    }

    private Double getValue(int expIndex, XRef ref, Map<List<String>, String> referenceList) {
        Map<XRef, List<Double>> map = this.experimentMapsList.get(expIndex);
        String newDb = null;
        for (List<String> strings : referenceList.keySet()) {
            if (!strings.contains(ref.getDb())) continue;
            newDb = referenceList.get(strings);
        }
        if (newDb != null) {
            XRef newRef = new XRef(newDb, ref.getRef());
            if (map.containsKey(newRef)) {
                switch (this.averaging) {
                    case 2: {
                        return this.max((Collection<Double>)map.get(newRef));
                    }
                    case 0: {
                        return this.mean((Collection<Double>)map.get(newRef));
                    }
                    case 1: {
                        return this.median((Collection<Double>)map.get(newRef));
                    }
                }
                throw new RuntimeException("Invalid averaging method: " + this.averaging);
            }
            return null;
        }
        return null;
    }

    public Set<XRef> getReferenceSet() {
        if (this.firstExpIndices.isEmpty()) {
            return null;
        }
        HashSet<XRef> set = new HashSet<XRef>();
        for (int i : this.firstExpIndices) {
            set.addAll(this.experimentMapsList.get(i).keySet());
        }
        return set;
    }

    private double max(Collection<Double> col) {
        double m = 0.0;
        for (double d : col) {
            if (!(Math.abs(d) > Math.abs(m))) continue;
            m = d;
        }
        return m;
    }

    private double mean(Collection<Double> col) {
        double sum = 0.0;
        for (double d : col) {
            sum += d;
        }
        return sum / (double)col.size();
    }

    private double median(Collection<Double> col) {
        assert (!col.isEmpty());
        TreeSet<Double> set = new TreeSet<Double>(col);
        Object[] arr = set.toArray();
        if (col.size() % 2 == 0) {
            return ((Double)arr[col.size() / 2] + (Double)arr[col.size() / 2 - 1]) / 2.0;
        }
        return (Double)arr[col.size() / 2];
    }

    private ExperimentData createExperimentData(double v) {
        if (this.type.equals("Expression Data")) {
            return new ExpressionData(v);
        }
        if (this.type.equals("Mass Spectrometry Data")) {
            return new MassSpecData(v);
        }
        if (this.type.equals("Copy Number Variation Data")) {
            return new CopyNumberData(v);
        }
        if (this.type.equals("Mutation Data")) {
            return new MutationData(v);
        }
        if (this.type.equals("Alteration Data")) {
            return new AlterationData(v);
        }
        if (this.type.equals("cBio Portal Alteration Data")) {
            return new CBioPortalAlterationData(v);
        }
        throw new RuntimeException("Invalid data type: " + this.type);
    }

    private ExperimentData createExperimentData(double v1, double v2) {
        if (this.type.equals("Expression Data")) {
            return new ExpressionData(v1, v2);
        }
        if (this.type.equals("Mass Spectrometry Data")) {
            return new MassSpecData(v1, v2);
        }
        if (this.type.equals("Copy Number Variation Data")) {
            return new CopyNumberData(v1, v2);
        }
        if (this.type.equals("Mutation Data")) {
            return new MutationData(v1, v2);
        }
        if (this.type.equals("Alteration Data")) {
            return new AlterationData(v1, v2);
        }
        if (this.type.equals("cBio Portal Alteration Data")) {
            return new CBioPortalAlterationData(v1, v2);
        }
        throw new RuntimeException("Invalid data type: " + this.type);
    }

    public void saveData() {
        if (this.ced == null || this.fileLocation == null) {
            return;
        }
        try {
            JAXBContext jc = JAXBContext.newInstance("org.patika.mada.dataXML");
            Marshaller m = jc.createMarshaller();
            m.setProperty("jaxb.formatted.output", Boolean.TRUE);
            BufferedWriter writer = new BufferedWriter(new FileWriter(this.fileLocation));
            m.marshal((Object)this.ced, writer);
            writer.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

