/*
 * Decompiled with CFR 0.152.
 */
package org.patika.mada.util;

import java.util.LinkedList;
import org.gvt.model.BioPAXGraph;
import org.patika.mada.graph.Edge;
import org.patika.mada.graph.GraphObject;
import org.patika.mada.graph.Node;

public class Path {
    private LinkedList<Node> nodes = new LinkedList();
    private LinkedList<Edge> edges = new LinkedList();
    private LinkedList<GraphObject> objects = new LinkedList();
    private int sign = 1;
    private int length = 0;
    private boolean alertForLengthUpdate;

    public LinkedList<Node> getNodes() {
        return this.nodes;
    }

    public LinkedList<Edge> getEdges() {
        return this.edges;
    }

    public LinkedList<GraphObject> getObjects() {
        return this.objects;
    }

    public int getSign() {
        return this.sign;
    }

    public boolean contains(GraphObject obj) {
        return this.objects.contains(obj);
    }

    public void addNode(Node node) {
        assert (this.edges.isEmpty() || this.edges.getLast().getTargetNode() == node || this.nodes.getLast().getParents().contains(node) || this.nodes.getLast().getChildren().contains(node));
        this.nodes.add(node);
        this.objects.add(node);
        if (this.alertForLengthUpdate) {
            if (node.isBreadthNode()) {
                ++this.length;
            }
            this.alertForLengthUpdate = false;
        }
    }

    public void addEdge(Edge edge) {
        assert (edge.getSourceNode() == this.nodes.getLast());
        this.edges.add(edge);
        this.objects.add(edge);
        this.sign *= edge.getSign();
        this.alertForLengthUpdate = true;
    }

    public int getLength() {
        return this.length;
    }

    public void highlight(boolean on) {
        for (Node node : this.nodes) {
            node.setHighlight(on);
        }
        for (Edge edge : this.edges) {
            edge.setHighlight(on);
        }
    }

    public void replaceElements(BioPAXGraph graph) {
        LinkedList<Node> tempNodeList = new LinkedList<Node>();
        for (Node node : this.nodes) {
            Node n = (Node)graph.getCorrespMember(node);
            assert (n != null);
            tempNodeList.add(n);
        }
        this.nodes = tempNodeList;
        LinkedList<Edge> tempEdgeList = new LinkedList<Edge>();
        for (Edge edge : this.edges) {
            Edge e = (Edge)graph.getCorrespMember(edge);
            assert (e != null);
            tempEdgeList.add(e);
        }
        this.edges = tempEdgeList;
        LinkedList<GraphObject> linkedList = new LinkedList<GraphObject>();
        for (GraphObject object : this.objects) {
            GraphObject o = graph.getCorrespMember(object);
            assert (o != null);
            linkedList.add(o);
        }
        this.objects = linkedList;
    }

    public String toString() {
        return this.nodes.get(0).getName() + " --" + this.getLength() + "-" + (this.sign > 0 ? "> " : "| ") + this.nodes.get(this.nodes.size() - 1).getName();
    }
}

