/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.cors;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.http.HttpMethod;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class CorsConfiguration {
    public static final String ALL = "*";
    private static final List<HttpMethod> DEFAULT_METHODS;
    private List<String> allowedOrigins;
    private List<String> allowedMethods;
    private List<HttpMethod> resolvedMethods = DEFAULT_METHODS;
    private List<String> allowedHeaders;
    private List<String> exposedHeaders;
    private Boolean allowCredentials;
    private Long maxAge;

    public CorsConfiguration() {
    }

    public CorsConfiguration(CorsConfiguration other) {
        this.allowedOrigins = other.allowedOrigins;
        this.allowedMethods = other.allowedMethods;
        this.resolvedMethods = other.resolvedMethods;
        this.allowedHeaders = other.allowedHeaders;
        this.exposedHeaders = other.exposedHeaders;
        this.allowCredentials = other.allowCredentials;
        this.maxAge = other.maxAge;
    }

    public CorsConfiguration combine(CorsConfiguration other) {
        Long maxAge;
        if (other == null) {
            return this;
        }
        CorsConfiguration config = new CorsConfiguration(this);
        config.setAllowedOrigins(this.combine(this.getAllowedOrigins(), other.getAllowedOrigins()));
        config.setAllowedMethods(this.combine(this.getAllowedMethods(), other.getAllowedMethods()));
        config.setAllowedHeaders(this.combine(this.getAllowedHeaders(), other.getAllowedHeaders()));
        config.setExposedHeaders(this.combine(this.getExposedHeaders(), other.getExposedHeaders()));
        Boolean allowCredentials = other.getAllowCredentials();
        if (allowCredentials != null) {
            config.setAllowCredentials(allowCredentials);
        }
        if ((maxAge = other.getMaxAge()) != null) {
            config.setMaxAge(maxAge);
        }
        return config;
    }

    private List<String> combine(List<String> source, List<String> other) {
        if (other == null || other.contains(ALL)) {
            return source;
        }
        if (source == null || source.contains(ALL)) {
            return other;
        }
        ArrayList<String> combined = new ArrayList<String>(source);
        combined.addAll(other);
        return combined;
    }

    public void setAllowedOrigins(List<String> allowedOrigins) {
        this.allowedOrigins = allowedOrigins != null ? new ArrayList<String>(allowedOrigins) : null;
    }

    public List<String> getAllowedOrigins() {
        return this.allowedOrigins;
    }

    public void addAllowedOrigin(String origin) {
        if (this.allowedOrigins == null) {
            this.allowedOrigins = new ArrayList<String>(4);
        }
        this.allowedOrigins.add(origin);
    }

    public void setAllowedMethods(List<String> allowedMethods) {
        ArrayList<String> arrayList = this.allowedMethods = allowedMethods != null ? new ArrayList<String>(allowedMethods) : null;
        if (!CollectionUtils.isEmpty(allowedMethods)) {
            this.resolvedMethods = new ArrayList<HttpMethod>(allowedMethods.size());
            for (String method : allowedMethods) {
                if (ALL.equals(method)) {
                    this.resolvedMethods = null;
                    break;
                }
                this.resolvedMethods.add(HttpMethod.resolve(method));
            }
        } else {
            this.resolvedMethods = DEFAULT_METHODS;
        }
    }

    public List<String> getAllowedMethods() {
        return this.allowedMethods;
    }

    public void addAllowedMethod(HttpMethod method) {
        if (method != null) {
            this.addAllowedMethod(method.name());
        }
    }

    public void addAllowedMethod(String method) {
        if (StringUtils.hasText(method)) {
            if (this.allowedMethods == null) {
                this.allowedMethods = new ArrayList<String>(4);
                this.resolvedMethods = new ArrayList<HttpMethod>(4);
            }
            this.allowedMethods.add(method);
            if (ALL.equals(method)) {
                this.resolvedMethods = null;
            } else if (this.resolvedMethods != null) {
                this.resolvedMethods.add(HttpMethod.resolve(method));
            }
        }
    }

    public void setAllowedHeaders(List<String> allowedHeaders) {
        this.allowedHeaders = allowedHeaders != null ? new ArrayList<String>(allowedHeaders) : null;
    }

    public List<String> getAllowedHeaders() {
        return this.allowedHeaders;
    }

    public void addAllowedHeader(String allowedHeader) {
        if (this.allowedHeaders == null) {
            this.allowedHeaders = new ArrayList<String>(4);
        }
        this.allowedHeaders.add(allowedHeader);
    }

    public void setExposedHeaders(List<String> exposedHeaders) {
        if (exposedHeaders != null && exposedHeaders.contains(ALL)) {
            throw new IllegalArgumentException("'*' is not a valid exposed header value");
        }
        this.exposedHeaders = exposedHeaders != null ? new ArrayList<String>(exposedHeaders) : null;
    }

    public List<String> getExposedHeaders() {
        return this.exposedHeaders;
    }

    public void addExposedHeader(String exposedHeader) {
        if (ALL.equals(exposedHeader)) {
            throw new IllegalArgumentException("'*' is not a valid exposed header value");
        }
        if (this.exposedHeaders == null) {
            this.exposedHeaders = new ArrayList<String>(4);
        }
        this.exposedHeaders.add(exposedHeader);
    }

    public void setAllowCredentials(Boolean allowCredentials) {
        this.allowCredentials = allowCredentials;
    }

    public Boolean getAllowCredentials() {
        return this.allowCredentials;
    }

    public void setMaxAge(Long maxAge) {
        this.maxAge = maxAge;
    }

    public Long getMaxAge() {
        return this.maxAge;
    }

    public String checkOrigin(String requestOrigin) {
        if (!StringUtils.hasText(requestOrigin)) {
            return null;
        }
        if (ObjectUtils.isEmpty(this.allowedOrigins)) {
            return null;
        }
        if (this.allowedOrigins.contains(ALL)) {
            if (this.allowCredentials != Boolean.TRUE) {
                return ALL;
            }
            return requestOrigin;
        }
        for (String allowedOrigin : this.allowedOrigins) {
            if (!requestOrigin.equalsIgnoreCase(allowedOrigin)) continue;
            return requestOrigin;
        }
        return null;
    }

    public List<HttpMethod> checkHttpMethod(HttpMethod requestMethod) {
        if (requestMethod == null) {
            return null;
        }
        if (this.resolvedMethods == null) {
            return Collections.singletonList(requestMethod);
        }
        return this.resolvedMethods.contains((Object)requestMethod) ? this.resolvedMethods : null;
    }

    public List<String> checkHeaders(List<String> requestHeaders) {
        if (requestHeaders == null) {
            return null;
        }
        if (requestHeaders.isEmpty()) {
            return Collections.emptyList();
        }
        if (ObjectUtils.isEmpty(this.allowedHeaders)) {
            return null;
        }
        boolean allowAnyHeader = this.allowedHeaders.contains(ALL);
        ArrayList<String> result = new ArrayList<String>(requestHeaders.size());
        block0: for (String requestHeader : requestHeaders) {
            if (!StringUtils.hasText(requestHeader)) continue;
            requestHeader = requestHeader.trim();
            if (allowAnyHeader) {
                result.add(requestHeader);
                continue;
            }
            for (String allowedHeader : this.allowedHeaders) {
                if (!requestHeader.equalsIgnoreCase(allowedHeader)) continue;
                result.add(requestHeader);
                continue block0;
            }
        }
        return result.isEmpty() ? null : result;
    }

    static {
        ArrayList<HttpMethod> rawMethods = new ArrayList<HttpMethod>(2);
        rawMethods.add(HttpMethod.GET);
        rawMethods.add(HttpMethod.HEAD);
        DEFAULT_METHODS = Collections.unmodifiableList(rawMethods);
    }
}

