#!/bin/bash

echo "启动中。。。"

pid=$(ps -ef | grep "[c]fnat" | grep -v "grep" | awk '{print $2}')

if [ -n "$pid" ]; then
  echo "找到 cfnat 进程，PID: $pid"
  echo "你之前似乎已经运行过cfnat了，现在将结束旧进程"
  kill -9 $pid
else
  echo "没有找到运行中的cfnat 跳过本操作"
fi
chmod 777 cfnat

# 如果你想修改参数就改下面对应的地方
addr=0.0.0.0
lport=1234
forward_port=443
code=200
colo=HKG
delay=150
domain=cloudflaremirrors.com/debian
ipnum=20
ips=4
num=10
random=true
task=100
tls=true
# -addr string
#  -code int
#        HTTP/HTTPS 响应状态码 (default 200)
#  -colo string
#        数据中心: 筛选数据中心例如 HKG,SJC,LAX (多个数据中心用逗号隔开,留空则忽略匹配)
#  -delay int
#        有效延迟（毫秒）: 超过此延迟将断开连接 (default 300)
#  -domain string
#        响应状态码检查的域名地址 (default "cloudflaremirrors.com/debian")
#  -ipnum int
#        有效IP数: 提取的有效IP数量 (default 20)
#  -ips string
#        转发IP类型: 指定生成IPv4还是IPv6地址 (4或6) (default "4")
#  -num int
#        负载IP数: 目标负载 IP 数量 (default 10)
#  -port int
#        转发目标端口 (default 443)
#  -random
#        是否随机生成IP，如果为false，则从CIDR中拆分出所有IP (default true)
#  -tls
#        是否为 TLS 端口 (default true)
#  -task int
#        最大并发请求数: 并发请求最大协程数 (default 100)
# 启动 cfnat 并将输出重定向到日志文件
nohup ./cfnat -addr "$addr:$lport" -code "$code" -delay "$delay" -domain "$domain" -ipnum "$ipnum" -ips "$ips" -num "$num" -random "$random" -task "$task" -tls "$tls" -port "$forward_port" > /dev/null 2>&1 &


sleep 1

pid2=$(ps -ef | grep "[c]fnat" | grep -v "grep" | awk '{print $2}')


if [ -n "$pid2" ]; then
  echo "找到 cfnat 进程，PID: $pid2"
  echo "cfnat 运行成功，如果想结束运行请执行结束运行脚本"
else
  echo "cfnat 运行失败"
fi