![](https://raw.githubusercontent.com/PseudoTV/PseudoTV_Artwork/master/PseudoTV%20Live/Flat/PTVL%20-%20Metro%20-%20Fanart%20(1).png)

# PseudoTV Live for Kodi™

## What is it?:

PseudoTV Live transforms your Kodi Library and Sources (Plugins, UPnP, etc...) into a broadcast or cable TV emulator, complete with configurable channels. UI Provided by Kodis PVR frontend via IPTV Simple.

[Changelog](https://github.com/PseudoTV/PseudoTV_Live/raw/master/plugin.video.pseudotv.live/changelog.txt)

[Forum: Kodi.TV](https://forum.kodi.tv/showthread.php?tid=355549)

[Discussion: Kodi.TV](https://forum.kodi.tv/showthread.php?tid=346803)

[![License](https://img.shields.io/github/license/PseudoTV/PseudoTV_Live?style=flat-square)](https://github.com/PseudoTV/PseudoTV_Live/blob/master/LICENSE)
[![Codacy Badge](https://img.shields.io/codacy/grade/efcc007bd689449f8cf89569ac6a311b.svg?style=flat-square)](https://www.codacy.com/app/PseudoTV/PseudoTV_Live/dashboard)
[![GitHub commit activity](https://img.shields.io/github/commit-activity/m/PseudoTV/PseudoTV_Live.svg?color=red&style=flat-square)](https://github.com/PseudoTV/PseudoTV_Live/commits?author=Lunatixz)
[![Kodi URL](https://img.shields.io/badge/Supports-Kodi%2019+-blue.svg?style=flat-square)](https://kodi.tv/download)
[![Kodi Donate](https://img.shields.io/badge/Donate%20to-Kodi-blue.svg?style=flat-square)](https://kodi.tv/contribute/donate)
[![Lunatixz Coffee](https://img.shields.io/badge/Buy%20%20Coffee-Lunatixz-blue.svg?style=flat-square)](https://www.buymeacoffee.com/Lunatixz)
[![Lunatixz Patreon](https://img.shields.io/badge/Patreon-Lunatixz-blue.svg?style=flat-square)](https://www.patreon.com/pseudotv)
[![Lunatixz Paypal](https://img.shields.io/badge/Paypal-Lunatixz-blue.svg?style=flat-square)](https://paypal.me/Lunatixz)
[![Twitter URL](https://img.shields.io/twitter/follow/PseudoTV_Live.svg?color=blue&label=%40PseudoTV_Live&style=flat-square)](https://twitter.com/PseudoTV_Live)
[![Feature Requests](https://feathub.com/PseudoTV/PseudoTV_Live?format=svg)](https://feathub.com/PseudoTV/PseudoTV_Live)

# Special Thanks:
- @xbmc If you are enjoying this project please donate to Kodi!
- @phunkyfish for his continued work and help with IPTV Simple.
- @IAmJayFord for awesome PseudoTV Live Icon/Fanart sets.
- @preroller for fantastic PseudoTV Live Bumpers.

### License

* [GNU GPL v3](http://www.gnu.org/licenses/gpl.html)
* Copyright 2009-2021


------------

# Features:
- Predefined Channels based on your Kodi library content; categorized by: 


- Automatic Channel logos, sourced from Kodi resource packs.

- Optional video overlay to display channel bug and other pending features.

- IPTV-Simple VOD support. Watch any EPG event (Past/Present/Future) directly via "Play Programme" context menu option.

- "Play from here" context menu  option queues channel as a playlist from any starting position.

- "More Info..." context menu option, displays detailed media information.

- Custom Channel grouping & genre colors.

- Third-Party M3U/XMLTV Importing with channel number collision logic.

- Efficient meta parsing & pagination.

- Media metadata parsing for "accurate" duration/runtime values.

- Option to save "accurate" (Parsed) duration meta to your Kodi database.

- "on the fly" channel creation, with automated background building.

- Ease of use; User Interface provided by Kodis PVR frontend.

- Music Genre PVR "Radio" Channels.

- Multi-Room channel configurations w/Automatic client detection.

- "Auto Tuning" Automatic channel creation from "Pre-Defined" configurations.

- Your choice of "Playback Methods". See post below for details.

- Smart Seeking. See below for details.

- "User-Defined" Channel Manager, create custom channels from any source available to Kodi. ie. Plugins, UPNP, Nodes, Smart playlists.

- Seasonal Holiday Channel, See changelog above for details.

- "Recommended Channels" & "Recommended Services" Plugins preconfigured for easy import into PseudoTV Live.

- Many more...

------------

# Supported Plugins:
*All plugins are supported by PseudoTV Live through the channel manager. The list below contains configuration free channels.

[PlutoTV](https://forum.kodi.tv/showthread.php?tid=315513)

[ChannelsDVR](https://forum.kodi.tv/showthread.php?tid=334947)

[Locast](https://forum.kodi.tv/showthread.php?tid=357406)

[HDhomerun Simple](https://forum.kodi.tv/showthread.php?tid=327117)

[AiryTV](https://forum.kodi.tv/showthread.php?tid=361486)

[Discovery+](https://forum.kodi.tv/showthread.php?tid=340055)

[Crackle](https://forum.kodi.tv/showthread.php?tid=)

[TubiTV](https://forum.kodi.tv/showthread.php?tid=)

------------

# Settings:

## Playback Method: 

1. PVR Callback - This method keeps Kodi believing you are using a Live feed from the PVR backend. Pros| Kodi PVR UI and Widget updates. Near infinite channel playback. Cons| Slower channel content changes. (1-60secs. depending on your system). If "Overlay" is enabled in settings; and active during content change you will be met with a custom background. (Currently static).

2. Playlist - Standard Kodi playlist queue (not to be confused with a smart playlist). Pros| Channel content changes quickly. Cons| Kodi does not treat playback as PVR channel, Playlist queues are finite.

## Seek tolerance (Smart Seeking):

Adjusting seek tolerance (in seconds) adds a buffer at the beginning of media that is currently selected to play and which includes an offset for a "Pseudo" Live effect. The greater the number the more it ignores the time differential between "live" and "load" times.
ex. If after a show ends your next show which should start at the beginning starting a few seconds into the future; due to a lag in loading time. Raising the seek tolerance well remedy this... 0 disables tolerance.

## Seek Threshold(Smart Seeking):

Adjusting seek threshold(percentage). threshold to which the current content can be played back before dismissing for the next queue. Ex. The content you select to play maybe near the end instead of loading two seconds of credits; PseudoTV Live will tune the next show automatically. 100% disables threshold (content played till the end).

## Parse for Accurate Duration Meta:

1. "Prefer Kodi Library" - Duration meta collected from the values provided by your metadata provider. ie. TVDB, TMDB, etc... Pros: Faster background channel building, Cons: Usually inaccrate, rounded values.

2. "Prefer File Metadata" - Media files are parsed individually for real runtimes. Pros: Accurate EPG guide times, Cons: Slower background channel building. File extensions supported `.avi,.mp4,.m4v,.3gp,.3g2,.f4v,.mov,.mkv,.flv,.ts,.m2ts,.strm`

	`.strm` files require matching `.nfo` sharing the same name. ex. `foobar movie,the.strm` & `foobar movie,the.nfo` Supported nfo parameters `runtime,duration,durationinseconds`. *note `runtime,duration` in minutes.

	*see "Save Accurate Duration to Kodis Library"

## Save Accurate Duration to Kodis Library:

- Inorder to reduce parsing times when using "Prefer File Metadata" PseudoTV Live can store the new accurate duration meta to Kodis library, there are no downsides to this process except for extra cpu usage. If you notice performance penalties when enabled, disable it... There is a fallback 28 day cache to avoid unnecessary file parsing. 

## Imports:

Imports are considered "third-party" and are not treated as "PseudoTV" channels. Channel configurations, channel numbering, onscreen overlays are all disabled. Imports are 1:1 m3u/xmltv imports with the exception of channel numbers which maybe altered as described below.

### M3U
- Supports all [common m3u paramters](https://github.com/kodi-pvr/pvr.iptvsimple#m3u-format-elements "common m3u paramters") including KODIPROP. File or URL must meet minimum requirements: 

`#EXTINF:0 tvg-id="" tvg-name="" tvg-chno="" ,ChannelName`

`http://path-to-stream/live/channel-feed`


- "Filter channels using the `provider` parameter (Optional)." - In-order for this feature to work the provided m3u must contain the following example:

1. `provider` ex. `provider=Locast`,`provider=PlutoTV`. If you would like to import only `PlutoTV` sources, enter `PlutoTV`. For multiples enter `Locast|PlutoTV`



### XMLTV 
- requires one of the two timestamps:
	1. `%Y%m%d%H%M%S` - Local Time 

	1. `%Y%m%d%H%M%S +%z` - UTC Time with Offset
    
    
## Options:
    
- Centralized file location: Location to store PseudoTV Live M3U/XMLTV and other shared resources. ie. Playlists, Nodes and Channel Logos.

    
------------

# General Information:


## - Channel Logos:

Logo's are cached and may not be refreshed immediately.... For immediate update use PseudoTV Lives channel manager to swap logo.

Logo folder location -  `/userdata/plugin.video.pseudotv.live/cache/logos`.

Logo's are cap-sensitive and must match the channel name exactly as it appears in the guide. Supported formats `*.jpg,*.png,*.gif`

If no logo is found, PseudoTV Live will parse for a matching logo in the following folder order. `/addons/plugin.video.pseudotv.live/resources/images`, `*resource.images.pseudotv.logos`, ** [`resource.images.studios.white`, `resource.images.studios.coloured`], `resource.images.moviegenreicons.transparent`, `resource.images.musicgenreicons.text`
 *user selected "logo" resource pack (default shown). | **color preference selected in settings.

[Resource pack](https://github.com/PseudoTV/PseudoTV_Resources/blob/master/README.md) - Standard Kodi image resource packs. 


## - Channel Sharing (Multi-Room):

### Server:

For "Multi-Room", Select an instance of Kodi/PseudoTV Live that will act as your primary "server". *All instances of Kodi must be configured for sharing. ie. Shared/Mapped Drives and Central Database (mySQL). Only your "Server" instance of PseudoTV Live will build/update channels. 

	1 https://kodi.wiki/view/MySQL 

	1 https://kodi.wiki/view/Path_substitution 

### Client:

Enable under "Multi-Room", select between two options.

	1 Remote Path - Use a remote url hosted by your server instance which is auto-detected. *http://localhost:50001/pseudotv.m3u **http://localhost:50001/pseudotv.xml ***http://localhost:50001/genres.xml

	1 Network Path - Select a shared network path same as configure on the server instance.

## - Channel Ordering (Numbering):

### - Number Assignment:

For full control of channel numbering it is recommend users create "Custom" user-defined channels. Channels 1-999 are reserved to users, anything higher is reserved and auto assigned to pre-defined channels.

Pre-defined channels yield no control over numbering; numbers are auto assign by type (ranging from channels 1000-9999), using lowest available number by type.

Imported M3Us and "Recommend Services" auto assigned by a multiplier based on the amount of imports staring at channel 10000, then appending the imports channel number. 

For example importing two M3Us/services. Import one will start at 10000, the other 20000. ex. If you are importing a m3u that contains channel 4.1, and 11. They will appear as 10004.1 and 10011. 

Each import is limited to 9999 (assuming each channel is an interger. Sub-Numbering, ie. floats ex. 4.1 extend the amount of possible imports) channels per import with a total of 9 total imports allowed.

- Channel Range:
-- `1-999` User-defined
-- `1000-9999` Pre-defined
-- `10000-99999` Imports (Third-party m3u and recommend services)

### - EPG Ordering:

#### - IPTV Simple Settings:

"only number by order" must be disbled if you would like to respect the channel numbers assigned in PseudoTV Live.
*NOTE: PseudoTV Live automatically applies the optimal settings to IPTV Simple in-order to maximize the user experience.

#### - Kodi PVR & LiveTV Settings:

If you want the exact channel numbers from PseudoTV Live to reflect onscreen, you will have to enable "Use channel order from backend". While in settings "Synchronize channel groups with backend" should also be enabled.
*NOTE: changes will require users to clear data from the same PVR settings menu

## - Channel Manager:

### - Color Legend:
- In-use (White) - Existing channel configuration.
- Unused (Dim-Grey) - Available for configuration.
- Favorite (Yellow) - User Favorites.
- Radio (Cyan) - User-defined Radio/Music channel.
-  Uneditable (Orange) - Pre-defined or Parental Locked channels are displayed as "Uneditable" within the manager.
-  Warnings (Red) - Indicates either a new channel that hasn't populated (yet) or an existing channel without content (won't display in guide).

------------

# FYI & Known Issues:

- If content is ignored/not added to the guide or episodes start/end before their assigned EPG time ie. guide times are off. Under "Parse for Accurate Duration Meta" select "Prefer File Metadata". Kodis library usually contain rounded duration/runtime values which will yield inaccurate guide times. Parsing the file directly grabs the actual duration value. If content is ignored, it is usually because Kodis library contains no duration/runtime information. Again, parsing the file resolves this problem. If however both your library and file contain no duration meta content will remain be ignored.

- Multiple PVR backends supported.

- Blank EPG cells; Kodis EPG data is malformed; Enter Kodis "PVR & LiveTV" settings, navigate to "Guide" and click "Clear data".

- Context Menu may be unavailable while viewing EPG.  To enable go do Kodis "PVR & LiveTV" then "Guide" and changing the default select action to "show context menu".

- Some video sources (i.e. plugins, UPnP) do not support seeking, which could cause playback to fail. Try loading the content via Context Menu ("Play Programme","Play from here").

- All content must include duration details either embedded into the file or via Kodis Library.

- Settings are dim and unelectable. Some settings require content to operate (ex. Selecting TV Networks require your library have TV Content). There are also actions that can not simultaneously run while PseudoTV background tasks are performed (ie. If you wait for tasks to finish, settings will become selectable). If you experience an error message and your settings are now unselectable. Either reboot Kodi, or disable/enable PseudoTV Live to temporarily fix, and be sure to report your error with a log.

- Enable "Channel surfing" (Only available in PVR Playback mode). Navigate Kodis settings, find PVR Live TV settings and Playback then disabled confirm channel switches by pressing "ok".

- "One Click" channel playback... Navigate to Kodis PRV & Live TV settings and change selection action.

- Channel Manager Colors, Dim = Unused, White = User-defined, Orange = Pre-defined, Red = Failed (Channel may not have content / appear in the guide and/or PseudoTV hasn't built the channel yet.)

- You can not skip during playback... unless you are using the "Playlist" playback mode.
  However, you can play any single show from the guide at any time or start playlist playback from any given position in the guide using the available context menu items.
  Play programme == Play single show from the start.
  Play from here == Queues guide content from this position and starts playback.

  ![Play Programme](https://i.imgur.com/ykLfzu6.png "Play Programme")
  ![Play From Here](https://i.imgur.com/ZSZzpmy.png "Play From Here")

- Channel surfing only works while in PVR CallbacK mode and during linear playback; VOD playback exits PVR.

------------

# Plugin Developer Integration.
- PseudoTV Live features two integration methods. 

1. "Recommend Services" which is a full m3u/xmltv import provide by [IPTV Manager](https://github.com/add-ons/service.iptv.manager) or a local generated m3u/xmltv set. *see imports

2. "Recommend Channels" allows VOD content to fully intergrate into PseudoTV Live.
Inorder for a plugin to announce itself to PseudoTV Live it must run a "Beacon" service. Examples can be found below. 

[Beacon Asset Example](https://github.com/PseudoTV/PseudoTV_Live/raw/master/plugin.video.pseudotv.live/asset.json)

[Locast Example (Live)](https://github.com/Lunatixz/KODI_Addons/blob/master/plugin.video.locast/pseudotv_recommended.py)

[Crackle Example (VOD)](https://github.com/Lunatixz/KODI_Addons/blob/master/plugin.video.crackle/pseudotv_recommended.py)

[Pluto TV Example (Live & VOD)](https://github.com/Lunatixz/KODI_Addons/blob/master/plugin.video.plutotv/pseudotv_recommended.py)