<?php
/**
 * @noinspection PhpMultipleClassDeclarationsInspection
 */

declare(strict_types=1);

namespace Siel\Acumulus\OpenCart\OpenCart3\Helpers;

use Registry;
use Siel\Acumulus\Helpers\Container;
use Siel\Acumulus\OpenCart\Helpers\OcHelper as BaseOcHelper;

/**
 * OC3 specific OcHelper methods.
 */
class OcHelper extends BaseOcHelper
{
    public function __construct(Registry $registry, Container $acumulusContainer)
    {
        $this->languageSettingKey = 'config_admin_language';
        parent::__construct($registry, $acumulusContainer);
    }

    protected function addEvents(): void
    {
        $this->addEvent('acumulus', 'catalog/model/*/addOrder/after', 'eventOrderUpdate');
        $this->addEvent('acumulus', 'catalog/model/*/addOrderHistory/after', 'eventOrderUpdate');
        $this->addEvent('acumulus', 'admin/model/*/addOrder/after', 'eventOrderUpdate');
        $this->addEvent('acumulus', 'admin/model/*/addOrderHistory/after', 'eventOrderUpdate');
        $this->addEvent('acumulus', 'admin/view/common/column_left/before', 'eventViewColumnLeft');
        $this->addEvent('acumulus', 'admin/controller/sale/order/info/before', 'eventControllerSaleOrderInfo');
        $this->addEvent('acumulus', 'admin/view/sale/order_info/before', 'eventViewSaleOrderInfo');
    }

    protected function addEvent(string $code, string $trigger, string $method, bool $status = true, int $sort_order = 0): void
    {
        /** @var \ModelSettingEvent $model */
        $model = $this->registry->getModel('setting/event');
        $model->addEvent(
            $code,
            $trigger,
            $this->registry->getRoute($method, $code),
            (int) $status,
            $sort_order,
        );
    }
}
