#!/system/bin/sh

START_TS=$(date +%s)

echo "[*] Waiting for full system boot..."
while [ "$(getprop sys.boot_completed)" != "1" ] && [ "$(getprop sys.boot_completed)" != "true" ]; do
    sleep 1
done

echo "[*] System boot completed. Waiting 5 extra seconds..."
sleep 5

END_TS=$(date +%s)
WAIT_TIME=$((END_TS - START_TS))

SCRIPT_PATH="$0"
SCRIPT_DIR="$(dirname "$SCRIPT_PATH")"
LOG_FILE="${SCRIPT_DIR}/shizuku_exec.log"
TMP_OUT="/data/local/tmp/shizuku_exec_output.log"

rm -f "$TMP_OUT"

{
echo "[*] ===== Shizuku Execution Log ====="
echo "[*] Time: $(date)"
echo "[*] Total wait time before execution: ${WAIT_TIME} seconds"
echo "[*] Searching for libshizuku.so..."

LIB_PATH=$(find /data/app/ -type f -name "libshizuku.so" 2>/dev/null | head -n 1)

if [ -z "$LIB_PATH" ] || [ ! -f "$LIB_PATH" ]; then
    echo "[!] libshizuku.so not found."
    echo "[!] Please make sure the Shizuku app is installed on your device."
    echo "[!] Aborting."
    exit 1
fi

echo "[*] Found: $LIB_PATH"
chmod +x "$LIB_PATH"
echo "[*] Executing..."
"$LIB_PATH"
RET=$?

echo "[*] Exit code: $RET"

if [ "$RET" -eq 0 ]; then
    echo "[*] Shizuku executed successfully."
else
    echo "[!] Shizuku execution failed."
fi

exit "$RET"
} | tee "$TMP_OUT"

cp "$TMP_OUT" "$LOG_FILE"
rm -f "$TMP_OUT"