import os
import xbmc
import base64
import threading

from six.moves import urllib_request

from elementum.daemon import shutdown
from elementum.config import init, ELEMENTUMD_HOST, ONLY_CLIENT
from elementum.logger import log
from kodi_six.utils import py2_decode, PY2


class ElementumMonitor(xbmc.Monitor):
    def __init__(self):
        self._closing = threading.Event()

    def __str__(self):
        return 'ElementumMonitor'

    @property
    def closing(self):
        return self._closing

    def onAbortRequested(self):
        log.debug('{0}.onAbortRequested()'.format(self))

        # Only when closing Kodi
        if self.abortRequested():
            xbmc.executebuiltin("Dialog.Close(all, true)")
            if not ONLY_CLIENT:
                shutdown()
            try:
                self._closing.set()
                self._closing.clear()
            except SystemExit as e:
                if e.code != 0:
                    os._exit(0)
                pass

    def onSettingsChanged(self):
        log.debug('{0}.onSettingsChanged()'.format(self))

        try:
            init()
            urllib_request.urlopen("%s/reload" % ELEMENTUMD_HOST)
            urllib_request.urlopen("%s/cmd/clear_page_cache" % ELEMENTUMD_HOST)
        except:
            pass

    def onNotification(self, sender, method, data):
        log.debug('{0}.onNotification({1}, {2}, {3})'.format(self, sender, method, py2_decode(data)))

        if PY2:
            data_base64 = base64.b64encode(data)
        else:
            data_base64 = base64.b64encode(data.encode("utf-8"))

        try:
            urllib_request.urlopen("%s/notification?sender=%s&method=%s&data=%s" % (
                ELEMENTUMD_HOST,
                sender,
                method,
                data_base64))
        except:
            pass
