# -*- coding: utf-8 -*-

""" ^ SECTION 1:
    This should be at the top of your code to declare the type of text
    format you're using. Without this you may find some text editors save
    it in an incompatible format and this can make bug tracking extremely
    confusing! More info here: https://www.python.org/dev/peps/pep-0263/
"""

#----------------------------------------------------------------

"""
    SECTION 2:
    This is where you'd put your license details, the GPL3 license 
    is the most common to use as it makes it easy for others to fork
    and improve upon your code. If you're re-using others code ALWAYS
    check the license first, removal of licenses is NOT allowed and you
    generally have to keep to the same license used in the original work
    (check license details as some do differ).

    Although not all licenses require it (some do, some don't),
    you should always give credit to the original author(s). Someone may have spent
    months if not years on the code so really it's the very least you can do if
    you choose to use their work as a base for your own.
"""
# License: GPL (http://www.gnu.org/licenses/gpl-3.0.html)
# Addon: plugin.video.shark
# Author: Shark55

#----------------------------------------------------------------

"""
    SECTION 3:
    This is your global imports, any modules you need to import code from
    are added here. You'll see a handful of the more common imports below.
"""
import os           # access operating system commands
import xbmc         # the base xbmc functions, pretty much every add-on is going to need at least one function from here
import xbmcaddon    # pull addon specific information such as settings, id, fanart etc.
import xbmcplugin   # contains functions required for creating directory structure style add-ons (plugins)

# The following are often used, we are not using them in this particular file so they are commented out

# import re           # allows use of regex commands, if you're intending on scraping you'll need this
# import xbmcgui      # gui based functions, contains things like creating dialog pop-up windows

from koding import route, Addon_Setting, Add_Dir, Find_In_Text, Open_URL, OK_Dialog
from koding import Open_Settings, Play_Video, Run, Text_File

#------------------------------------------------------------

"""
    SECTION 4:
    These are our global variables, anything we set here can be accessed by any of
    our functions later on. Please bare in mind though that if you change the value
    of a global variable from inside a function the value will revert back to the
    value set here once that function has completed.
"""
debug        = Addon_Setting(setting='debug')       # Grab the setting of our debug mode in add-on settings
addon_id     = xbmcaddon.Addon().getAddonInfo('id') # Grab our add-on id

# Set the base plugin url you want to hook into
BASE  = "plugin://plugin.video.youtube/playlist/"
BASE2 = "plugin://plugin.video.youtube/channel/"

# Set each of your YouTube playlist id's
YOUTUBE_CHANNEL_ID_1 = "PLnN45r-xvI8TUPWofFRZ7CDrMaDUuUJ3q"
YOUTUBE_CHANNEL_ID_2 = "PLfoNZDHitwjX0k3OYMdr_q5OOyZNleqga"
YOUTUBE_CHANNEL_ID_3 = "PLtc57NTUizP4FFPP6c_Xkp8NDvjhIw3Rj"
YOUTUBE_CHANNEL_ID_4 = "PLoIHbFaEyozDb-E_lBlHiGgnIV8MQ2thm"
YOUTUBE_CHANNEL_ID_5 = "PLfoNZDHitwjXaNGKMmGXPXOqxrXoZ3u0i"
YOUTUBE_CHANNEL_ID_6 = "PL1NbHSfosBuHQUCC9DPnnaHqGOGYJRjQV"
YOUTUBE_CHANNEL_ID_7 = "PL86428130B1D6261A"
YOUTUBE_CHANNEL_ID_8 = "PL1NbHSfosBuGdR6tYWGK3girPiStlwNFC"
YOUTUBE_CHANNEL_ID_9 = "PL1NbHSfosBuEc2WpAr3YUIg5w6oZDDSBA"
YOUTUBE_CHANNEL_ID_10 = "PL1NbHSfosBuHZhcqhsOcFLjKHDtL2wR7r"
YOUTUBE_CHANNEL_ID_11 = "PL1NbHSfosBuEEDMuw03gMJF3Opzy6RECU"
YOUTUBE_CHANNEL_ID_12 = "PLfoNZDHitwjV3n6yM-XXGfXn2navand6p"
#YOUTUBE_CHANNEL_ID_13 = "UCYqS5taU5bbxgBt12tZrd9A"
#YOUTUBE_CHANNEL_ID_14 = "UCMkebZXHuUgKb5jBOIQ4Iyg"
YOUTUBE_CHANNEL_ID_15 = "PLtc57NTUizP4TeyC0fAJrjLPM73Xyhovh"
YOUTUBE_CHANNEL_ID_16 = "PLtc57NTUizP45ufUzhTLr1paL6JYMnuz-"
YOUTUBE_CHANNEL_ID_17 = "PLnN45r-xvI8TPQRpSZ4MdPXLzVyiVy4Rj"
YOUTUBE_CHANNEL_ID_18 = "PL1NbHSfosBuHInmjsLcBuqeSV256FqlOO"
YOUTUBE_CHANNEL_ID_19 = "PLtc57NTUizP5Ipw3v7GXNaJd6mK6bd-kG"
YOUTUBE_CHANNEL_ID_20 = "PLfoNZDHitwjUUrM4dYe542iCcRpEzS_RX"
#----------------------------------------------------------------

"""
    SECTION 5:
    Add our custom functions in here, it's VERY important these go in this section
    as the code in section 6 relies on these functions. If that code tries to run
    before these functions are declared the add-on will fail.

    You'll notice each function in here has a decorator above it (an @route() line of code),
    this assigns a mode to the function so it can be called with Add_Dir and it also tells
    the code what paramaters to send through. For example you'll notice the Main_Menu() function
    we've assigned to the mode "main" - this means if we ever want to get Add_Dir to open that
    function we just use the mode "main". This particular function does not require any extra
    params to be sent through but if you look at the Simple_Dialog() function you'll see we send through
    2 different paramaters (title and msg), if you look at the Add_Dir function in Main_Menu()
    on line 106 you'll see we've sent these through as a dictionary. Using that same format you can send
    through as many different params as you wish.
"""

#----------------------------------------------------------------
# This is the main menu we open into
@route(mode='main_menu')
def Main_Menu():
# An example title/message we're going to send through to a popup dialog in the first Add_Dir item
    my_message= "{'title' : 'LIVE EVENTS', 'msg' :''}"
        
# Add some YT Playlists (see we're using BASE as the url)
    #Add_Dir(
        #name="Live Events,Mabe", url=my_message, mode="simple_dialog", folder=False,
        #icon="")

    Add_Dir( 
        name="[B][COLOR deepskyblue]NHL Condensed Game[/COLOR][/B]", url=BASE+YOUTUBE_CHANNEL_ID_18+"/", folder=True,
        icon="http://www.shark55.com/thumbnail/NHL.jpg")		
		
    Add_Dir( 
        name="[B][COLOR deepskyblue]NHL GAME RECAPS[/COLOR][/B]", url=BASE+YOUTUBE_CHANNEL_ID_6+"/", folder=True,
        icon="http://www.shark55.com/thumbnail/NHL.jpg")

    Add_Dir( 
        name="[B][COLOR deepskyblue]NHL GAME RECAPS[/COLOR][/B]", url=BASE+YOUTUBE_CHANNEL_ID_17+"/", folder=True,
        icon="http://www.shark55.com/thumbnail/NHL.jpg")

    Add_Dir( 
        name="[B][COLOR deepskyblue]NHL GAME RECAPS[/COLOR][/B]", url=BASE+YOUTUBE_CHANNEL_ID_1+"/", folder=True,
        icon="http://www.shark55.com/thumbnail/NHL.jpg")		

    Add_Dir( 
        name="[B][COLOR deepskyblue]TOP TEN LIST[/COLOR][/B]", url=BASE+YOUTUBE_CHANNEL_ID_7+"/", folder=True,
        icon="http://www.shark55.com/thumbnail/NHL.jpg")

    Add_Dir( 
        name="[B][COLOR deepskyblue]BEST OF THE NIGHT[/COLOR][/B]", url=BASE+YOUTUBE_CHANNEL_ID_8+"/", folder=True,
        icon="http://www.shark55.com/thumbnail/NHL.jpg")
		
    Add_Dir( 
        name="[B][COLOR deepskyblue]SlowMoMonday[/COLOR][/B]", url=BASE+YOUTUBE_CHANNEL_ID_9+"/", folder=True,
        icon="http://www.shark55.com/thumbnail/NHL.jpg")

    Add_Dir( 
        name="[B][COLOR deepskyblue]Super Saves[/COLOR][/B]", url=BASE+YOUTUBE_CHANNEL_ID_10+"/", folder=True,
        icon="http://www.shark55.com/thumbnail/NHL.jpg")
		
    Add_Dir( 
        name="[B][COLOR deepskyblue]FREE HOCKEY FRIDAY[/COLOR][/B]", url=BASE+YOUTUBE_CHANNEL_ID_11+"/", folder=True,
        icon="http://www.shark55.com/thumbnail/NHL.jpg")
		
    Add_Dir( 
        name="[B][COLORlawngreen]NASCAR Race Rewind[/COLOR][/B]", url=BASE+YOUTUBE_CHANNEL_ID_16+"/", folder=True,
        icon="http://www.shark55.com/thumbnail/NASCAR.jpg")
		
    Add_Dir( 
        name="[B][COLORlawngreen]NASCAR Full Race Replays 2019[/COLOR][/B]", url=BASE+YOUTUBE_CHANNEL_ID_19+"/", folder=True,
        icon="http://www.shark55.com/thumbnail/NASCAR.jpg")		

    Add_Dir( 
        name="[B][COLORlawngreen]NASCAR Full Race Replays 2018[/COLOR][/B]", url=BASE+YOUTUBE_CHANNEL_ID_15+"/", folder=True,
        icon="http://www.shark55.com/thumbnail/NASCAR.jpg")
		
    Add_Dir( 
        name="[B][COLORlawngreen]NASCAR Full Race Replays 2017[/COLOR][/B]", url=BASE+YOUTUBE_CHANNEL_ID_3+"/", folder=True,
        icon="http://www.shark55.com/thumbnail/NASCAR.jpg")
		
    Add_Dir( 
        name="[B][COLORdodgerblue]Formula One Testing 2019[/COLOR][/B]", url=BASE+YOUTUBE_CHANNEL_ID_2+"/", folder=True,
        icon="http://www.shark55.com/thumbnail/F1.jpg")	

    Add_Dir( 
        name="[B][COLORdodgerblue]Formula One 2018 Highlights[/COLOR][/B]", url=BASE+YOUTUBE_CHANNEL_ID_20+"/",folder=False,
        icon="http://www.shark55.com/thumbnail/F1.jpg")			
		
    Add_Dir( 
        name="[B][COLORdodgerblue]Formula One 2017 Highlights[/COLOR][/B]", url=BASE+YOUTUBE_CHANNEL_ID_5+"/",folder=False,
        icon="http://www.shark55.com/thumbnail/F1.jpg")		
    
    Add_Dir( 
        name="[B][COLORdodgerblue]Formula One Vault[/COLOR][/B]", url=BASE+YOUTUBE_CHANNEL_ID_12+"/", folder=True,
        icon="http://www.shark55.com/thumbnail/F1.jpg")
		
    Add_Dir( 
        name="[B][COLORchartreuse]Speedy Dundee Speedway[/COLOR][/B]", url=BASE+YOUTUBE_CHANNEL_ID_4+"/", folder=False,
        icon="https://i.ytimg.com/vi/0DeX4m_y81g/hqdefault.jpg?sqp=-oaymwEXCPYBEIoBSFryq4qpAwkIARUAAIhCGAE=&rs=AOn4CLB_sVdsW1oYywEOqM5zMF8kMB7ZnQ")
		
		

# Add some YT channels (see we're using BASE2 as the url for this one)
    #Add_Dir( 
        #name="Johnny Gault[B][COLOR orangered] Learning,Guid,Tec[/B][/COLOR]", url=BASE2+YOUTUBE_CHANNEL_ID_13+"/", folder=True,
        #icon="http://www.shark55.com/thumbnail/tattoologo.jpg")
		
    #Add_Dir(
        #name="Carl Grace[B][COLOR orangered] Tattoo special request by Tim[/B][/COLOR]", url=BASE2+YOUTUBE_CHANNEL_ID_14+"/", folder=True,
        #icon="http://www.shark55.com/thumbnail/tattoologo.jpg")		
		
#----------------------------------------------------------------
# A basic OK Dialog
@route(mode='koding_settings')
def Koding_Settings():
    Open_Settings()
#----------------------------------------------------------------
# A basic OK Dialog
@route(mode='simple_dialog', args=['title','msg'])
def Simple_Dialog(title,msg):
    OK_Dialog(title, msg)
#----------------------------------------------------------------

"""
    SECTION 6:
    Essential if creating list items, this tells kodi we're done creating our list items.
    The list will not populate without this. In the run command you need to set default to
    whatever route you want to open into, in this example the 'main_menu' route which opens the
    Main_Menu() function up at the top.
"""
if __name__ == "__main__":
    Run(default='main_menu')
    xbmcplugin.endOfDirectory(int(sys.argv[1]))