//
//  yuvFragmentShader.fsh
//
//
//  Created by luguilong on.
//  Copyright xunlei 2016. All rights reserved.
//

// 在OpenGL3.2 Core Profile中，版本号必须显式地给出
#version 150

#if __VERSION__ >= 140
in vec2 v_texcoord;
out vec4  myOutPut;
#else
varying vec2 v_texcoord;
#endif

uniform sampler2D s_texture_y;
uniform sampler2D s_texture_u;
uniform sampler2D s_texture_v;

void main()
{
    #if __VERSION__ >= 140
     float y = texture(s_texture_y, v_texcoord).r - 0.0625;
     float u = texture(s_texture_u, v_texcoord).r - 0.5;
     float v = texture(s_texture_v, v_texcoord).r - 0.5;
    #else
     float y = texture2D(s_texture_y, v_texcoord).r - 0.0625;
     float u = texture2D(s_texture_u, v_texcoord).r - 0.5;
     float v = texture2D(s_texture_v, v_texcoord).r - 0.5;
    #endif
    
     float r = 1.164 * y + 1.596 * v;
     float g = 1.164 * y - 0.391 * u - 0.813 * v;
     float b = 1.164 * y + 2.018 * u;
    
#if __VERSION__ >= 140
     myOutPut = vec4(r, g, b, 1.0);
#else
     gl_FragColor = vec4(r, g, b, 1.0);
#endif
    
}