//
//  vertexShader.vsh
//
//
//  Created by luguilong.
//  Copyright xunlei 2016. All rights reserved.
//

// 在OpenGL3.2 Core Profile中，版本号必须显式地给出
#version 150

#if __VERSION__ >= 140
in vec4 position;
in vec2 texcoord;
#else
attribute vec4 position;
attribute vec2 texcoord;
#endif

uniform mat4 modelViewProjectionMatrix;

#if __VERSION__ >= 140
out vec2 v_texcoord;
#else
varying vec2 v_texcoord;
#endif

void main()
{
    gl_Position = modelViewProjectionMatrix * position;
    v_texcoord = texcoord.xy;
}