# -*- coding: utf-8 -*-


import traceback
import re
import json
from resources.lib.modules import control, log_utils


def rd_cache_check(url):
    import resolveurl
    from resolveurl.plugins.realdebrid import RealDebridResolver
    from resolveurl import common
    net = common.Net()
    USER_AGENT = 'ResolveURL for Kodi/%s' % control.getKodiVersion()
    token = RealDebridResolver.get_setting('token')
    headers = {'Authorization': 'Bearer %s' % token}
    rest_base_url = 'https://api.real-debrid.com/rest/1.0'
    check_cache_path = 'torrents/instantAvailability'
    try:
        if url.lower().startswith('magnet:'):
            r = re.search('''magnet:.+?urn:([a-zA-Z0-9]+):([a-zA-Z0-9]+)''', url.lower(), re.I)
            if r:
                _hash, _format = r.group(2).lower(), r.group(1)
                try:
                    url = '%s/%s/%s' % (rest_base_url, check_cache_path, _hash)
                    result = net.http_GET(url, headers=headers).content
                    js_result = json.loads(result)
                    _hash_info = js_result.get(_hash, {})
                    if isinstance(_hash_info, dict):
                        if len(_hash_info.get('rd')) > 0:
                            if control.setting('addon_debug') == 'true':
                                log_utils.log('Real-Debrid: %s is readily available to stream' % _hash)
                                log_utils.log('Real-Debrid: %s ' % _hash_info)
                            return _hash_info
                except Exception as e:
                    log_utils.log("Real-Debrid Error: CHECK CACHE | %s" % e)
                    if '401' in str(e):
                        try:
                            RealDebridResolver().refresh_token()
                            url = '%s/%s/%s' % (rest_base_url, check_cache_path, _hash)
                            result = net.http_GET(url, headers=headers).content
                            js_result = json.loads(result)
                            _hash_info = js_result.get(_hash, {})
                            if isinstance(_hash_info, dict):
                                if len(_hash_info.get('rd')) > 0:
                                    if control.setting('addon_debug') == 'true':
                                        log_utils.log('Real-Debrid: %s is readily available to stream' % _hash)
                                        log_utils.log('Real-Debrid: %s ' % _hash_info)
                                    return _hash_info
                        except Exception as e:
                            log_utils.log("Real-Debrid Error: CHECK CACHE | %s" % e)
                            raise
                    else:
                        return
        else:
            return
    except Exception:
        failure = traceback.format_exc()
        log_utils.log('Debrid - Check Torrent Cache - Exception: ' + str(failure))
        return {}
