const columnDefinitions = {
  0: {
    index: 0,
    name: 'Time [h]',
    description: 'Time',
    valueType: {
      type: 'NUMERIC',
    },
    kind: {
      type: 'REFERENCE',
      class: {
        type: 'REFERENCE_DIMENSION',
        name: 'Time',
        dimension: { type: 'DIMENSION', dimensionType: 'TIME' },
        unit: {
          type: 'UNIT',
          value: 'HOURS',
          dimension: { type: 'DIMENSION', dimensionType: 'TIME' },
        },
      },
    },
  },
  1: {
    index: 1,
    name: 'cal_ls_opt_do',
    description: 'Dissolved Oxygen',
    valueType: {
      type: 'NUMERIC',
      range: [0, 100],
    },
    kind: {
      type: 'FACTOR',
      class: {
        type: 'DESCRIPTOR',
        name: 'Dissolved Oxygen',
        dimension: { type: 'DIMENSION', dimensionType: 'CONCENTRATION' },
        unit: {
          type: 'UNIT',
          value: 'PERCENT',
          dimension: { type: 'DIMENSION', dimensionType: 'CONCENTRATION' },
        },
      },
    },
  },
  2: {
    index: 2,
    name: 'm_ph',
    description: 'pH',
    valueType: {
      type: 'NUMERIC',
      range: [0, 14],
    },
    kind: {
      type: 'FACTOR',
      class: {
        type: 'DESCRIPTOR',
        name: 'pH',
        dimension: { type: 'DIMENSION', dimensionType: 'CONCENTRATION' },
      },
    },
  },
  3: {
    index: 3,
    name: 'm_stirrer',
    description: 'Stirring Speed',
    valueType: {
      type: 'NUMERIC',
    },
    kind: {
      type: 'FACTOR',
      class: {
        type: 'DESCRIPTOR',
        name: 'Stirring Speed',
        dimension: { type: 'DIMENSION', dimensionType: 'SPEED' },
        unit: {
          type: 'UNIT',
          value: 'RPM',
          dimension: { type: 'DIMENSION', dimensionType: 'SPEED' },
        },
      },
    },
  },
  4: {
    index: 4,
    name: 'dm_spump1',
    description: 'Volume',
    valueType: {
      type: 'NUMERIC',
    },
    kind: {
      type: 'FACTOR',
      class: {
        type: 'DESCRIPTOR',
        name: 'Volume',
        dimension: { type: 'DIMENSION', dimensionType: 'VOLUME' },
        unit: {
          type: 'UNIT',
          value: 'MILLILITER',
          dimension: { type: 'DIMENSION', dimensionType: 'VOLUME' },
        },
      },
    },
  },
};

export default columnDefinitions;
