import * as fs from 'fs';
import lodash from 'lodash';
import papaparse from 'papaparse';
import * as fsml_utils from 'fsml-utils';
import * as fsml_standard from 'fsml-standard';
import columnDefinitions from './columnDefinitions.js';

const { set } = lodash;

const applikonParser = {
  name: 'applikonParser',
  type: 'parser',
  run: (file) => {
    let buffer = file;
    let fileReference;
    if (typeof file === 'string') {
      fileReference = file;
      buffer = fs.readFileSync(file);
    }
    const dataString = buffer.toString('utf-8');

    const { data } = papaparse.parse(dataString);

    const FileData = fsml_utils.createTemplateForType(
      fsml_standard.FileData
    );
    set(FileData, "reference", fileReference)

    const TabularData = fsml_utils.createTemplateForType(
      fsml_standard.TabularData
    );

    set(TabularData, 'name', 'Applikon Bioreactor');
    set(TabularData, 'column', columnDefinitions);
    set(TabularData, 'fileReference', FileData);

    data.forEach((dataRow, rowIndex) => {
      const values = [];
      dataRow.forEach((value, columnIndex) => {
        values.push({
          index: columnIndex,
          value,
        });
      });
      const Row = fsml_utils.createTemplateForType(fsml_standard.Row);
      set(Row, 'index', rowIndex);
      set(Row, 'values', values);
      TabularData.rows.push(Row);
    });

    return { data: TabularData };
  },
  isApplicable: (file) => {
    console.info(`Checking if file can be parsed...`);
    let canBeParsed = true;
    if (typeof file === 'string') {
      canBeParsed = file.endsWith('.csv');
      try {
        fs.readFileSync(file);
      } catch (error) {
        throw new Error(error);
      }
    }
    return canBeParsed;
  },
};

export default applikonParser;
