init python:
	lessons.add_current('play, stop, fadein, fadeout')

label music_and_sounds:
	show rn 2 smile
	
	rn "Настало время разобраться с музыкой!"
	
	$ code.show('play music "sound/music/usual.ogg"')
	show rn 2 smile:
		rn_moving 0.5 xpos 0.28
	
	rn "Самый простой пример воспроизведения музыки выглядит вот так."
	rn "В начале идёт команда [sts]play[ste], потом указывается канал воспроизведения, а затем - путь к файлу, который нужно запустить."
	
	show rn 3 smile with dissolve
	rn "Прежде всего стоит сказать, что это - именно максимально упрощённый пример, и писать прямо так - плохая идея."
	rn "Проблема в том, что при указании пути к файлу напрямую, его придётся менять по всей игре, если позже ты решишь заменить его другим файлом."
	rn "А это мало того, что неудобно, так о некоторых местах можно и вообще забыть!"
	
	python:
		code.show('''
			# в init python
			music_list = {}
			music_list["usual"] = "your/path.ogg"
			
			# в сценарии
			play music music_list["usual"]
		''')
	
	show rn 2 wink with dspr
	rn "Чтобы такого не было, этот путь нужно куда-то записать в [sts]init[ste]-блоке, а при воспроизведении - доставать его оттуда."
	show rn 2 smile with dspr
	rn "В случае изменения пути к файлу, теперь его нужно будет исправить лишь в одном месте, и всё гарантированно продолжит работать."
	rn "Здорово, правда? {w=0.5}Но для этого нужно самую малость усложнить код."
	
	
	$ code.show('play music music_list["usual"]')
	
	show rn 4 smile with dissolve
	rn "Кроме того, уметь проигрывать музыку только так - не очень-то полезно."
	rn "Как есть параметры у команды [sts]show[ste] из прошлого урока, так они есть и у команды [sts]play[ste]."
	
	rn "Я расскажу о двух самых важных."
	rn "Добавление [sts]fadeout 1[ste] в конце укажет, что сначала нужно плавно, за секунду, снизить громкость текущей мелодии до нуля, и лишь потом начать новую."
	rn "Точно также есть параметр [sts]fadein 1.5[ste], который указывает время плавного повышения громкости."
	
	show rn 1 smile with dissolve
	rn "Конечно, их можно использовать и одновременно."
	
	show rn 1 smile:
		rn_moving 0.5 xpos 0.5
	$ code.hide()
	
	rn "Теперь поговорим о каналах воспроизведения."
	
	show rn 2 smile with dissolve
	rn "Изначально есть 3 категории каналов."
	
	rn "Музыка: с одним каналом [sts]music[ste], в котором указанные файлы после завершения начинаются с начала."
	
	rn "Звуки: [sts]sound[ste], [sts]sound2[ste] и [sts]sound3[ste] - эти каналы отвечают за однократное воспроизведение. Полезно для звука открытия двери, например."
	rn "На одном канале может проигрываться только 1 файл, поэтому таких каналов сделано сразу 3 штуки."
	rn "Обычно звуки принято хранить в [sts]sound/sfx/[ste]."
	
	rn "Ну и каналы для окружения: [sts]ambience[ste], [sts]sound_loop[ste], [sts]sound_loop2[ste] и [sts]sound_loop3[ste]."
	rn "Эти каналы повторяют воспроизведение своих файлов, как и [sts]music[ste]."
	rn "Отличие в том, что у окружения есть отдельный параметр громкости на экране настроек."
	rn "К примеру, пользователю может быть удобно снизить громкость сверчков, оставив музыку на прежнем уровне."
	rn "Звуки окружения обычно складируются в папке [sts]sound/ambience/[ste]."
	
	
	$ code.show('stop music')
	show rn 2 smile:
		rn_moving 0.5 xpos 0.28
	
	rn "После того, как мы научились запускать музыку, было бы неплохо научиться и останавливать её, не так ли?"
	rn "Как видишь, это делается очень просто: команда [sts]stop[ste] и название канала."
	
	$ code.show('stop music fadeout 1')
	rn "А для плавной остановки здесь тоже есть параметр [sts]fadeout[ste]."
	
	
	show rn 2 smile:
		rn_moving 0.5 xpos 0.5
	$ code.hide()
	
	rn "Думаю, для начала тебе этого хватит."
	
	show rn 3 smile with dissolve
	rn "Конечно, в движке для работы с музыкой есть множество инструментов: громкость, пауза, перемотка, очереди, создание своих каналов и много чего ещё..."
	rn "Однако, вряд ли тебе всё это пригодится в самом начале."
	
	show rn 2 smile with dissolve
	rn "Тем более, что все эти детали ты всегда сможешь найти в документации - я всё ещё призываю тебя не стесняться туда заглядывать за подробностями!"
	
	rn "На этом базовая часть туториала подошла к концу."
	rn "До встречи в других разделах!"
