import com.urbancode.air.*
import com.urbancode.air.plugin.scm.*
import java.text.*
import groovy.xml.XmlUtil;

final def dateParser = new DateParser();
final def apTool = new AirPluginTool(this.args[0], this.args[1]);

//------------------------------------------------------------------------------
// PARSE PROPERTIES
//------------------------------------------------------------------------------

final def stepProps = apTool.getStepProperties()
final def workDir = new File('.').canonicalFile


final String host       = stepProps['source/repo/repoHost']
final String username   = stepProps['source/repo/username']
final String password   = stepProps['source/repo/password'] ?: stepProps['source/repo/passScript']
final String accurevCmd = stepProps['source/repo/commandPath'] ?: 'accurev'
final String depotName  = stepProps['source/repo/depotName']

final String srcName    = stepProps['source'];
final File dir          = new File(workDir, stepProps['source/dirOffset'] ?: '.').canonicalFile // get checkout directory
final String streamName = stepProps['source/stream']

def userExcludesString  = stepProps['source/excludeUsers'] ?: ''
def fileFiltersString   = stepProps['source/fileFilters'] ?: '';

final String changesUrl = stepProps['changesUrl']

final def startRevision = stepProps['startRevision'] ?: ''
final def endRevision   = stepProps['endRevision'] ?: ''
final def startDate     = dateParser.parseDate(stepProps['startDate']) // explicit start date ?: startBuildLife.actualWorkspaceDate
final def endDate       = dateParser.parseDate(stepProps['endDate'])   // explicit end date ?: buildLife.actualWorkspaceDate

// create the directory ahead of time
dir.mkdirs()

// Execute
SCMChangelog changelog = new SCMChangelog()
changelog.scmCommand = accurevCmd
changelog.host = host
changelog.username = username
changelog.password = password
changelog.directory = dir
changelog.streamName = streamName
changelog.depotName = depotName
changelog.startRevision = startRevision
changelog.endRevision = endRevision
changelog.startDate = startDate
changelog.endDate = endDate
changelog.changesUrl = changesUrl

changelog.changeSetFilter.setUserExcludes(userExcludesString)
changelog.changeSetFilter.setFileFilters(fileFiltersString)

changelog.execute()
