/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Build
* (c) Copyright IBM Corporation 2012, 2014. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
package com.urbancode.air.plugin.scm

import com.urbancode.air.*

import java.io.File;
import java.util.Date;

public class SCMTag extends SCMStep {

    //**************************************************************************
    // CLASS
    //**************************************************************************

    //**************************************************************************
    // INSTANCE
    //**************************************************************************
    
    String tagName

    /**
     *
     */
    public void execute() {
        boolean error = false
        
        this.login()
        
        try {
            assert tagName : 'Tag Name is a required attribute'
            assert streamName : 'Stream Name is a required attribute'
    
            //
            // create tag in local repo
            //
            def tagCommand = [scmCommand, 'mksnap', '-s', tagName, '-b', streamName];
            if (host) {
                tagCommand << '-H' << host
            }
            if (revision) {
                tagCommand << "-t" << revision;
            }
            else if (date) {
                tagCommand << "-t" << scmHelper.formatDate(date);
            }
            else {
                tagCommand << "-t" << "now";
            }
            cmdHelper.runCommand('Creating Tag', tagCommand);
        }
        catch (ExitCodeException e) {
            println e.getMessage()
            error = true
        }
        finally {
            this.logout()
            
            if (error) {
                System.exit(1)
            }
        }
    }
}
