import com.urbancode.air.*
import com.urbancode.air.plugin.accuwork.*
    
final def apTool = new AirPluginTool(this.args[0], this.args[1]);

//------------------------------------------------------------------------------
// PARSE PROPERTIES
//------------------------------------------------------------------------------

final def stepProps = apTool.getStepProperties()
final def workDir = new File('.').canonicalFile

final String host       = stepProps['automation/repoHost']
final String username   = stepProps['automation/username']
final String password   = stepProps['automation/password'] ?: stepProps['automation/passwordScript']
final String accurevCmd = stepProps['automation/commandPath'] ?: 'accurev'
final String issueDB    = stepProps['automation/issueDB']
final String bugIds     = stepProps['bugIds']
final String status     = stepProps['status']

//------------------------------------------------------------------------------
// EXECUTE
//------------------------------------------------------------------------------
workDir.mkdirs()

List<String> bugIdList = bugIds?.split(",")

println "Bug Ids: " + bugIdList.toString()
if (!status) {
    println "Status is required"
    System.exit(1)
}

ChangeStatus cs = new ChangeStatus()
cs.host = host
cs.username = username
cs.password = password
cs.scmCommand = accurevCmd
cs.issueDB = issueDB
cs.directory = workDir
cs.bugIdList = bugIdList
cs.status = status
cs.execute()