import com.urbancode.air.*
import com.urbancode.air.plugin.accuwork.*
    
final def apTool = new AirPluginTool(this.args[0], this.args[1]);

//------------------------------------------------------------------------------
// PARSE PROPERTIES
//------------------------------------------------------------------------------

final def stepProps = apTool.getStepProperties()
final def workDir = new File('.').canonicalFile

final String host       = stepProps['automation/repoHost']
final String username   = stepProps['automation/username']
final String password   = stepProps['automation/password'] ?: stepProps['automation/passwordScript']
final String accurevCmd = stepProps['automation/commandPath'] ?: 'accurev'
final String issueDB    = stepProps['automation/issueDB']
final String issueUrl   = stepProps['automation/issueUrl']

//------------------------------------------------------------------------------
// EXECUTE
//------------------------------------------------------------------------------
workDir.mkdirs()

GetDetails gd = new GetDetails()
gd.host = host
gd.username = username
gd.password = password
gd.scmCommand = accurevCmd
gd.issueDB = issueDB
gd.directory = workDir
gd.issueUrl = issueUrl
gd.execute()