/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Build
* (c) Copyright IBM Corporation 2012, 2014. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
import com.urbancode.air.*
import com.urbancode.air.plugin.accuwork.*
    
final def apTool = new AirPluginTool(this.args[0], this.args[1]);

//------------------------------------------------------------------------------
// PARSE PROPERTIES
//------------------------------------------------------------------------------

final def stepProps = apTool.getStepProperties()
final def workDir = new File('.').canonicalFile

final String host       = stepProps['automation/repoHost']
final String username   = stepProps['automation/username']
final String password   = stepProps['automation/password'] ?: stepProps['automation/passwordScript']
final String accurevCmd = stepProps['automation/commandPath'] ?: 'accurev'
final String issueDB    = stepProps['automation/issueDB']
final String bugIds     = stepProps['bugIds']
final String comment    = stepProps['comment']

//------------------------------------------------------------------------------
// EXECUTE
//------------------------------------------------------------------------------
workDir.mkdirs()

List<String> bugIdList = bugIds?.split(",")

println "Bug Ids: " + bugIdList.toString()
if (!comment) {
    println "Comment is required"
    System.exit(1)
}

AddComment ac = new AddComment()
ac.host = host
ac.username = username
ac.password = password
ac.scmCommand = accurevCmd
ac.issueDB = issueDB
ac.directory = workDir
ac.bugIdList = bugIdList
ac.comment = comment
ac.execute()