/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.util.crypto.algs;

import com.infradna.tool.bridge_method_injector.BridgeMethodsAdded;
import com.urbancode.commons.util.ObjectUtil;
import com.urbancode.commons.util.crypto.algs.CryptStringAlgorithm;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import org.apache.commons.codec.binary.Base64;

@BridgeMethodsAdded
public class PBEAlg
implements CryptStringAlgorithm {
    private static final int ITERATION_COUNT = 1000;
    private static final int PBE_SALT_LENGTH = 8;
    private static final int PBE_PWD_LENGTH = 8;
    private static final String PBE_ALG = "PBEWithMD5AndDES";
    private SecureRandom secureRandom = null;

    public String getAlgPrefix() {
        return "pbe";
    }

    public boolean isSupported() {
        return true;
    }

    public String encode(String value) throws GeneralSecurityException {
        return this.encryptPBE(value);
    }

    public boolean isDecodeSupported() {
        return true;
    }

    public String decode(String encoded) throws GeneralSecurityException {
        return this.decryptPBE(encoded);
    }

    public boolean validate(String plainText, String cipherText) throws GeneralSecurityException {
        return ObjectUtil.isEqual(plainText, this.decode(cipherText));
    }

    public SecureRandom getSecureRandom() {
        return this.secureRandom;
    }

    public void setSecureRandom(SecureRandom secureRandom) {
        this.secureRandom = secureRandom;
    }

    public boolean shouldReencode(String cipherText) throws GeneralSecurityException {
        return false;
    }

    protected String encryptPBE(String value) throws GeneralSecurityException {
        String result;
        if (value != null) {
            byte[] data = this.getUtf8Bytes(value);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            SecureRandom sr = this.getSecureRandom();
            byte[] salt = new byte[8];
            sr.nextBytes(salt);
            byte[] passByte = new byte[8];
            sr.nextBytes(passByte);
            for (int i = 0; i < passByte.length; ++i) {
                passByte[i] = (byte)(passByte[i] % 26 + 97);
            }
            char[] password = this.getAsciiChars(passByte);
            PBEKeySpec keyspec = new PBEKeySpec(password, salt, 1000);
            SecretKey key = SecretKeyFactory.getInstance(PBE_ALG).generateSecret(keyspec);
            Cipher cipher = Cipher.getInstance(PBE_ALG);
            PBEParameterSpec paramspec = new PBEParameterSpec(salt, 1000);
            cipher.init(1, (Key)key, paramspec);
            for (int i = 0; i < salt.length; ++i) {
                baos.write(salt[i]);
                baos.write(passByte[i]);
            }
            baos.write(passByte, salt.length, passByte.length - salt.length);
            byte[] finalBytes = cipher.doFinal(data);
            try {
                baos.write(finalBytes);
            }
            catch (IOException impossible) {
                throw new AssertionError((Object)impossible);
            }
            keyspec.clearPassword();
            result = Base64.encodeBase64String((byte[])baos.toByteArray());
            try {
                baos.close();
            }
            catch (IOException ioe) {}
        } else {
            result = null;
        }
        return result;
    }

    protected String decryptPBE(String cryptValue) throws GeneralSecurityException {
        String result;
        if (cryptValue != null) {
            char[] password;
            byte[] data;
            String strippedCrypt = cryptValue;
            try {
                data = Base64.decodeBase64((byte[])strippedCrypt.getBytes("US-ASCII"));
            }
            catch (UnsupportedEncodingException impossible) {
                throw new AssertionError((Object)impossible);
            }
            if (data.length < 16) {
                throw new IllegalArgumentException("Invalid Encrypted String");
            }
            byte[] passByte = new byte[8];
            byte[] salt = new byte[8];
            System.arraycopy(data, 16, passByte, 8, 0);
            for (int i = 0; i < 8; ++i) {
                salt[i] = data[i * 2];
                passByte[i] = data[i * 2 + 1];
            }
            try {
                password = new String(passByte, "UTF-8").toCharArray();
            }
            catch (UnsupportedEncodingException impossible) {
                throw new AssertionError((Object)impossible);
            }
            PBEKeySpec keyspec = new PBEKeySpec(password, salt, 1000);
            SecretKey key = SecretKeyFactory.getInstance(PBE_ALG).generateSecret(keyspec);
            PBEParameterSpec paramspec = new PBEParameterSpec(salt, 1000);
            Cipher cipher = Cipher.getInstance(PBE_ALG);
            cipher.init(2, (Key)key, paramspec);
            byte[] output = cipher.doFinal(data, 16, data.length - 8 - 8);
            keyspec.clearPassword();
            try {
                result = new String(output, "UTF-8");
            }
            catch (UnsupportedEncodingException impossible) {
                throw new AssertionError((Object)impossible);
            }
        }
        result = cryptValue;
        return result;
    }

    private byte[] getUtf8Bytes(String value) {
        try {
            return value.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("UTF-8 is unsupported, but this is required in JVM spec", e);
        }
    }

    private char[] getAsciiChars(byte[] value) {
        try {
            char[] chars = new String(value, "US-ASCII").toCharArray();
            return chars;
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("US-ASCII is unsupported, but this is required in JVM spec", e);
        }
    }
}

