/*
 * Licensed Materials - Property of IBM Corp.
 * IBM UrbanCode Deploy
 * (c) Copyright IBM Corporation 2016. All Rights Reserved.
 *
 * U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
 * GSA ADP Schedule Contract with IBM Corp.
 */

import groovy.json.JsonSlurper

import javax.servlet.http.*

import org.apache.http.HttpResponse
import org.apache.http.HttpStatus
import org.apache.http.client.methods.HttpGet
import org.apache.http.util.EntityUtils

import com.urbancode.air.plugin.artifactory.ArtifactoryHelper
import com.urbancode.commons.httpcomponentsutil.HttpClientBuilder
import com.urbancode.commons.util.IO

import com.urbancode.air.*
import com.urbancode.ubuild.codestation.client.*
import com.urbancode.air.plugin.automation.*

def isEmpty(value) {
    return value == null || value.equals("")
}

final def workDir = new File('.').canonicalFile


final def apTool = new AirPluginTool(this.args[0], this.args[1])
final def stepProps = apTool.getStepProperties()


final def REPO_PATH_SEPARATOR = "/";

// Integration
def automation = stepProps['automation']
final String repoUrl = stepProps['automation/url']
final String username = stepProps['automation/user']
final String password = stepProps['automation/password'] ?: props['automation/passScript']

final def repoName = stepProps['repositoryName']
final def targetPath = stepProps['targetPath'];
final def baseDir = stepProps['baseDir']
final def extensionName = stepProps['extensionName']


while (repoUrl.endsWith(REPO_PATH_SEPARATOR)) {
    repoUrl = repoUrl.substring(0, repoUrl.length() - 1);
}

def exitVal = 0;
HttpClientBuilder builder = ArtifactoryHelper.getBuilder();
ArtifactoryHelper.createClient(username, password);


def uploadDir = null;


uploadDir = new File(workDir, baseDir)

ArtifactoryHelper.uploadFileToRepo(repoUrl, repoName, targetPath, uploadDir, extensionName)
String printMsg = "Upload '" + extensionName + "' files under " + uploadDir.getAbsolutePath() + " to Repository:${repoName}"
println printMsg

apTool.setOutputProperty("buildlife/artifactory.versionId", targetPath)
apTool.setOutputProperty("buildlife/artifact.repository.prop.sheet.${automation}", automation)
apTool.storeOutputProperties()

System.exit(exitVal);
